/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.compiler;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import org.mvel2.CompileException;
import org.mvel2.DataConversion;
import org.mvel2.ErrorDetail;
import org.mvel2.Operator;
import org.mvel2.ParserContext;
import org.mvel2.ast.ASTNode;
import org.mvel2.ast.AssertNode;
import org.mvel2.ast.AssignmentNode;
import org.mvel2.ast.DeclTypedVarNode;
import org.mvel2.ast.DeepAssignmentNode;
import org.mvel2.ast.DoNode;
import org.mvel2.ast.DoUntilNode;
import org.mvel2.ast.EndOfStatement;
import org.mvel2.ast.Fold;
import org.mvel2.ast.ForEachNode;
import org.mvel2.ast.ForNode;
import org.mvel2.ast.Function;
import org.mvel2.ast.IfNode;
import org.mvel2.ast.ImportNode;
import org.mvel2.ast.IndexedAssignmentNode;
import org.mvel2.ast.IndexedDeclTypedVarNode;
import org.mvel2.ast.IndexedOperativeAssign;
import org.mvel2.ast.IndexedPostFixDecNode;
import org.mvel2.ast.IndexedPostFixIncNode;
import org.mvel2.ast.IndexedPreFixDecNode;
import org.mvel2.ast.IndexedPreFixIncNode;
import org.mvel2.ast.InlineCollectionNode;
import org.mvel2.ast.InterceptorWrapper;
import org.mvel2.ast.Invert;
import org.mvel2.ast.IsDef;
import org.mvel2.ast.LineLabel;
import org.mvel2.ast.LiteralDeepPropertyNode;
import org.mvel2.ast.LiteralNode;
import org.mvel2.ast.Negation;
import org.mvel2.ast.NewObjectNode;
import org.mvel2.ast.OperativeAssign;
import org.mvel2.ast.OperatorNode;
import org.mvel2.ast.PostFixDecNode;
import org.mvel2.ast.PostFixIncNode;
import org.mvel2.ast.PreFixDecNode;
import org.mvel2.ast.PreFixIncNode;
import org.mvel2.ast.RegExMatch;
import org.mvel2.ast.ReturnNode;
import org.mvel2.ast.StaticImportNode;
import org.mvel2.ast.Substatement;
import org.mvel2.ast.ThisWithNode;
import org.mvel2.ast.TypeCast;
import org.mvel2.ast.TypeDescriptor;
import org.mvel2.ast.TypedVarNode;
import org.mvel2.ast.Union;
import org.mvel2.ast.UntilNode;
import org.mvel2.ast.WhileNode;
import org.mvel2.ast.WithNode;
import org.mvel2.compiler.BlankLiteral;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.math.MathProcessor;
import org.mvel2.util.ArrayTools;
import org.mvel2.util.ExecutionStack;
import org.mvel2.util.ParseTools;
import org.mvel2.util.PropertyTools;
import org.mvel2.util.Soundex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractParser
implements Serializable {
    protected char[] expr;
    protected int cursor;
    protected int start;
    protected int length;
    protected int fields;
    protected static final int OP_OVERFLOW = -2;
    protected static final int OP_TERMINATE = -1;
    protected static final int OP_RESET_FRAME = 0;
    protected static final int OP_CONTINUE = 1;
    protected boolean greedy = true;
    protected boolean lastWasIdentifier = false;
    protected boolean lastWasLineLabel = false;
    protected boolean lastWasComment = false;
    protected boolean literalOnly = true;
    protected boolean debugSymbols = false;
    protected int lastLineStart = -1;
    protected int line = 1;
    protected ASTNode lastNode;
    private static final WeakHashMap<String, char[]> EX_PRECACHE = new WeakHashMap(15);
    public static final HashMap<String, Object> LITERALS = new HashMap(70, 0.4f);
    public static final HashMap<String, Integer> OPERATORS = new HashMap(50, 0.4f);
    protected ExecutionStack stk;
    protected ExecutionStack splitAccumulator = new ExecutionStack();
    protected static ThreadLocal<ParserContext> parserContext;
    protected ParserContext pCtx;
    protected ExecutionStack dStack;
    protected Object ctx;
    protected VariableResolverFactory variableFactory;
    protected static final int SET = 0;
    protected static final int REMOVE = 1;
    protected static final int GET = 2;
    protected static final int GET_OR_CREATE = 3;
    public static final int LEVEL_5_CONTROL_FLOW = 5;
    public static final int LEVEL_4_ASSIGNMENT = 4;
    public static final int LEVEL_3_ITERATION = 3;
    public static final int LEVEL_2_MULTI_STATEMENT = 2;
    public static final int LEVEL_1_BASIC_LANG = 1;
    public static final int LEVEL_0_PROPERTY_ONLY = 0;

    protected ASTNode nextTokenSkipSymbols() {
        ASTNode n = this.nextToken();
        if (n != null && n.getFields() == -1) {
            n = this.nextToken();
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ASTNode nextToken() {
        try {
            if (this.cursor >= this.length) {
                return null;
            }
            if (!this.splitAccumulator.isEmpty()) {
                this.lastNode = (ASTNode)this.splitAccumulator.pop();
                return this.lastNode;
            }
            this.start = this.cursor;
            boolean capture = false;
            boolean union = false;
            this.pCtx = this.getParserContext();
            if (this.debugSymbols) {
                if (!this.lastWasLineLabel) {
                    if (this.pCtx.getSourceFile() == null) {
                        throw new CompileException("unable to produce debugging symbols: source name must be provided.");
                    }
                    this.line = this.pCtx.getLineCount();
                    this.skipWhitespaceWithLineAccounting();
                    if (!this.pCtx.isKnownLine(this.pCtx.getSourceFile(), this.pCtx.setLineCount(this.line)) && !this.pCtx.isBlockSymbols()) {
                        this.lastWasLineLabel = true;
                        this.pCtx.setLineAndOffset(this.line, this.cursor);
                        this.lastNode = this.pCtx.setLastLineLabel(new LineLabel(this.pCtx.getSourceFile(), this.line));
                        return this.lastNode;
                    }
                } else {
                    this.lastWasLineLabel = false;
                    this.lastWasComment = false;
                }
            }
            while (this.start != this.length && ParseTools.isWhitespace(this.expr[this.start])) {
                ++this.start;
            }
            this.cursor = this.start;
            block92: while (this.cursor != this.length) {
                if (ParseTools.isIdentifierPart(this.expr[this.cursor])) {
                    capture = true;
                    ++this.cursor;
                    continue;
                }
                if (capture) {
                    String t = new String(this.expr, this.start, this.cursor - this.start);
                    if (OPERATORS.containsKey(t)) {
                        switch (OPERATORS.get(t)) {
                            case 34: {
                                this.start = this.cursor = this.trimRight(this.cursor);
                                if (!ParseTools.isIdentifierPart(this.expr[this.cursor])) {
                                    throw new CompileException("unexpected character (expected identifier): " + this.expr[this.cursor], this.expr, this.cursor);
                                }
                                do {
                                    this.captureToNextTokenJunction();
                                    this.skipWhitespaceWithLineAccounting();
                                } while (this.cursor < this.length && this.expr[this.cursor] == '[');
                                if (this.cursor < this.length && !this.lastNonWhite(']')) {
                                    this.captureToEOT();
                                }
                                this.lastNode = new NewObjectNode(this.subArray(this.start, this.cursor), this.fields);
                                this.skipWhitespaceWithLineAccounting();
                                if (this.cursor != this.length && this.expr[this.cursor] == '{') {
                                    if (!((NewObjectNode)this.lastNode).getTypeDescr().isUndimensionedArray()) {
                                        throw new CompileException("conflicting syntax: dimensioned array with initializer block", this.expr, this.cursor);
                                    }
                                    this.start = this.cursor;
                                    Class egressType = this.lastNode.getEgressType();
                                    if (egressType == null) {
                                        try {
                                            egressType = TypeDescriptor.getClassReference(this.pCtx, ((NewObjectNode)this.lastNode).getTypeDescr());
                                        }
                                        catch (ClassNotFoundException e) {
                                            throw new CompileException("could not instantiate class", e);
                                        }
                                    }
                                    this.cursor = ParseTools.balancedCapture(this.expr, this.cursor, this.expr[this.cursor]) + 1;
                                    if (this.tokenContinues()) {
                                        this.start = this.cursor;
                                        this.lastNode = new InlineCollectionNode(this.expr, this.start, this.start, this.fields, egressType, this.pCtx);
                                        this.captureToEOT();
                                        this.lastNode = new Union(this.expr, this.start + 1, this.cursor, this.fields, this.lastNode);
                                        return this.lastNode;
                                    }
                                    this.lastNode = new InlineCollectionNode(this.expr, this.start, this.cursor, this.fields, egressType, this.pCtx);
                                    return this.lastNode;
                                }
                                if (!((NewObjectNode)this.lastNode).getTypeDescr().isUndimensionedArray()) return this.lastNode;
                                throw new CompileException("array initializer expected", this.expr, this.cursor);
                            }
                            case 97: {
                                this.start = this.cursor = this.trimRight(this.cursor);
                                this.captureToEOS();
                                this.lastNode = new AssertNode(this.subArray(this.start, this.cursor--), this.fields);
                                return this.lastNode;
                            }
                            case 99: {
                                this.start = this.cursor = this.trimRight(this.cursor);
                                this.captureToEOS();
                                this.lastNode = new ReturnNode(this.subArray(this.start, this.cursor), this.fields);
                                return this.lastNode;
                            }
                            case 39: {
                                return this.captureCodeBlock(65536);
                            }
                            case 40: {
                                throw new CompileException("else without if", this.cursor);
                            }
                            case 38: {
                                return this.captureCodeBlock(131072);
                            }
                            case 41: {
                                return this.captureCodeBlock(0x100000);
                            }
                            case 42: {
                                return this.captureCodeBlock(524288);
                            }
                            case 43: {
                                return this.captureCodeBlock(0x800000);
                            }
                            case 46: {
                                return this.captureCodeBlock(262144);
                            }
                            case 45: {
                                return this.captureCodeBlock(0x200000);
                            }
                            case 47: {
                                this.start = this.cursor = this.trimRight(this.cursor);
                                this.captureToNextTokenJunction();
                                this.lastNode = new IsDef(this.subArray(this.start, this.cursor));
                                return this.lastNode;
                            }
                            case 96: {
                                this.start = this.cursor = this.trimRight(this.cursor);
                                this.captureToEOS();
                                ImportNode importNode = new ImportNode(this.subArray(this.start, this.cursor));
                                if (importNode.isPackageImport()) {
                                    this.pCtx.addPackageImport(importNode.getPackageImport());
                                } else {
                                    this.pCtx.addImport(importNode.getImportClass().getSimpleName(), importNode.getImportClass());
                                }
                                this.lastNode = importNode;
                                return this.lastNode;
                            }
                            case 95: {
                                this.start = this.cursor = this.trimRight(this.cursor);
                                this.captureToEOS();
                                this.lastNode = new StaticImportNode(this.subArray(this.start, this.cursor));
                                return this.lastNode;
                            }
                            case 100: {
                                this.lastNode = this.captureCodeBlock(100);
                                this.start = this.cursor + 1;
                                return this.lastNode;
                            }
                            case 98: {
                                this.start = this.cursor + 1;
                                this.captureToEOT();
                                int end = this.cursor;
                                this.skipWhitespace();
                                if (this.expr[this.cursor] == '=') {
                                    this.cursor = this.start;
                                    if (end != this.cursor) continue block92;
                                    throw new CompileException("illegal use of reserved word: var");
                                }
                                String name = new String(this.subArray(this.start, end));
                                int idx = this.pCtx.variableIndexOf(name);
                                if (idx != -1) {
                                    this.lastNode = new IndexedDeclTypedVarNode(idx, Object.class);
                                    return this.lastNode;
                                }
                                this.lastNode = new DeclTypedVarNode(name, Object.class, this.fields, this.pCtx);
                                return this.lastNode;
                            }
                        }
                    }
                    this.skipWhitespace();
                    if (this.cursor != this.length && this.expr[this.cursor] == '(') {
                        this.cursor = ParseTools.balancedCapture(this.expr, this.cursor, '(') + 1;
                    }
                    if (this.cursor != this.length) {
                        switch (this.expr[this.cursor]) {
                            case '?': {
                                if (this.lookToLast() == '.') {
                                    capture = true;
                                    ++this.cursor;
                                    continue block92;
                                }
                            }
                            case '+': {
                                switch (this.lookAhead()) {
                                    case '+': {
                                        String name = new String(this.subArray(this.start, this.trimLeft(this.cursor)));
                                        int idx = this.pCtx.variableIndexOf(name);
                                        this.lastNode = idx != -1 ? new IndexedPostFixIncNode(idx) : new PostFixIncNode(name);
                                        this.cursor += 2;
                                        this.expectEOS();
                                        return this.lastNode;
                                    }
                                    case '=': {
                                        String name = ParseTools.createStringTrimmed(this.expr, this.start, this.cursor - this.start);
                                        this.start = this.cursor += 2;
                                        this.captureToEOS();
                                        if (union) {
                                            this.lastNode = new DeepAssignmentNode(this.subArray(this.start, this.cursor), this.fields, 0, t, this.pCtx);
                                            return this.lastNode;
                                        }
                                        int idx = this.pCtx.variableIndexOf(name);
                                        if (idx != -1) {
                                            this.lastNode = new IndexedAssignmentNode(this.subArray(this.start, this.cursor), this.fields, 0, name, idx, this.pCtx);
                                            return this.lastNode;
                                        }
                                        this.lastNode = new AssignmentNode(this.subArray(this.start, this.cursor), this.fields, 0, name, this.pCtx);
                                        return this.lastNode;
                                    }
                                }
                                if (!ParseTools.isDigit(this.lookAhead()) || this.cursor <= 1 || this.expr[this.cursor - 1] != 'E' && this.expr[this.cursor - 1] != 'e' || !ParseTools.isDigit(this.expr[this.cursor - 2])) break;
                                ++this.cursor;
                                capture = true;
                                continue block92;
                            }
                            case '-': {
                                switch (this.lookAhead()) {
                                    case '-': {
                                        String name = new String(this.subArray(this.start, this.trimLeft(this.cursor)));
                                        int idx = this.pCtx.variableIndexOf(name);
                                        this.lastNode = idx != -1 ? new IndexedPostFixDecNode(idx) : new PostFixDecNode(name);
                                        this.cursor += 2;
                                        this.expectEOS();
                                        return this.lastNode;
                                    }
                                    case '=': {
                                        String name = new String(this.expr, this.start, this.trimLeft(this.cursor) - this.start);
                                        this.start = this.cursor += 2;
                                        this.captureToEOS();
                                        if (union) {
                                            this.lastNode = new DeepAssignmentNode(this.subArray(this.start, this.cursor), this.fields, 1, t, this.pCtx);
                                            return this.lastNode;
                                        }
                                        int idx = this.pCtx.variableIndexOf(name);
                                        if (idx != -1) {
                                            this.lastNode = new IndexedOperativeAssign(this.subArray(this.start, this.cursor), 1, idx, this.fields);
                                            return this.lastNode;
                                        }
                                        this.lastNode = new OperativeAssign(name, this.subArray(this.start, this.cursor), 1, this.fields);
                                        return this.lastNode;
                                    }
                                }
                                if (!ParseTools.isDigit(this.lookAhead()) || this.cursor <= 1 || this.expr[this.cursor - 1] != 'E' && this.expr[this.cursor - 1] != 'e' || !ParseTools.isDigit(this.expr[this.cursor - 2])) break;
                                ++this.cursor;
                                capture = true;
                                continue block92;
                            }
                            case '%': 
                            case '&': 
                            case '*': 
                            case '/': 
                            case '^': 
                            case '|': 
                            case '\u00ab': 
                            case '\u00ac': 
                            case '\u00bb': {
                                char op = this.expr[this.cursor];
                                if (this.lookAhead() == '=') {
                                    String name = new String(this.expr, this.start, this.trimLeft(this.cursor) - this.start);
                                    this.start = this.cursor += 2;
                                    this.captureToEOS();
                                    if (union) {
                                        this.lastNode = new DeepAssignmentNode(this.subArray(this.start, this.cursor), this.fields, AbstractParser._bwOpLookup(op), t, this.pCtx);
                                        return this.lastNode;
                                    }
                                    int idx = this.pCtx.variableIndexOf(name);
                                    if (idx != -1) {
                                        this.lastNode = new IndexedOperativeAssign(this.subArray(this.start, this.cursor), AbstractParser._bwOpLookup(op), idx, this.fields);
                                        return this.lastNode;
                                    }
                                    this.lastNode = new OperativeAssign(name, this.subArray(this.start, this.cursor), AbstractParser._bwOpLookup(op), this.fields);
                                    return this.lastNode;
                                }
                            }
                            case '<': {
                                if (this.lookAhead() != '<' || this.lookAhead(2) != '=') break;
                                String name = new String(this.expr, this.start, this.trimLeft(this.cursor) - this.start);
                                this.start = this.cursor += 3;
                                this.captureToEOS();
                                if (union) {
                                    this.lastNode = new DeepAssignmentNode(this.subArray(this.start, this.cursor), this.fields, 10, t, this.pCtx);
                                    return this.lastNode;
                                }
                                int idx = this.pCtx.variableIndexOf(name);
                                if (idx != -1) {
                                    this.lastNode = new IndexedOperativeAssign(this.subArray(this.start, this.cursor), 10, idx, this.fields);
                                    return this.lastNode;
                                }
                                this.lastNode = new OperativeAssign(name, this.subArray(this.start, this.cursor), 10, this.fields);
                                return this.lastNode;
                            }
                            case '>': {
                                if (this.lookAhead() != '>') break;
                                if (this.lookAhead(2) == '=') {
                                    String name = new String(this.expr, this.start, this.trimLeft(this.cursor) - this.start);
                                    this.start = this.cursor += 3;
                                    this.captureToEOS();
                                    if (union) {
                                        this.lastNode = new DeepAssignmentNode(this.subArray(this.start, this.cursor), this.fields, 9, t, this.pCtx);
                                        return this.lastNode;
                                    }
                                    int idx = this.pCtx.variableIndexOf(name);
                                    if (idx != -1) {
                                        this.lastNode = new IndexedOperativeAssign(this.subArray(this.start, this.cursor), 9, idx, this.fields);
                                        return this.lastNode;
                                    }
                                    this.lastNode = new OperativeAssign(name, this.subArray(this.start, this.cursor), 9, this.fields);
                                    return this.lastNode;
                                }
                                if (this.lookAhead(2) != '>' || this.lookAhead(3) != '=') break;
                                String name = new String(this.expr, this.start, this.trimLeft(this.cursor) - this.start);
                                this.start = this.cursor += 4;
                                this.captureToEOS();
                                if (union) {
                                    this.lastNode = new DeepAssignmentNode(this.subArray(this.start, this.cursor), this.fields, 11, t, this.pCtx);
                                    return this.lastNode;
                                }
                                int idx2 = this.pCtx.variableIndexOf(name);
                                if (idx2 != -1) {
                                    this.lastNode = new IndexedOperativeAssign(this.subArray(this.start, this.cursor), 11, idx2, this.fields);
                                    return this.lastNode;
                                }
                                this.lastNode = new OperativeAssign(name, this.subArray(this.start, this.cursor), 11, this.fields);
                                return this.lastNode;
                            }
                            case '[': {
                                this.cursor = ParseTools.balancedCapture(this.expr, this.cursor, '[') + 1;
                                continue block92;
                            }
                            case '.': {
                                union = true;
                                ++this.cursor;
                                this.skipWhitespaceWithLineAccounting();
                                continue block92;
                            }
                            case '{': {
                                if (!union) break;
                                this.cursor = ParseTools.balancedCapture(this.expr, this.cursor, '{') + 1;
                                continue block92;
                            }
                            case '~': {
                                if (this.lookAhead() != '=') break;
                                char[] tmp = this.subArray(this.start, this.trimLeft(this.cursor));
                                this.start = this.cursor += 2;
                                if (!this.isNextIdentifierOrLiteral()) {
                                    throw new CompileException("unexpected symbol '" + this.expr[this.cursor] + "'", this.expr, this.cursor);
                                }
                                this.captureToEOT();
                                this.lastNode = new RegExMatch(tmp, this.fields, this.subArray(this.start, this.cursor));
                                return this.lastNode;
                            }
                            case '=': {
                                int idx;
                                if (this.lookAhead() == '+') {
                                    String name = new String(this.expr, this.start, this.trimLeft(this.cursor) - this.start);
                                    this.start = this.cursor += 2;
                                    if (!this.isNextIdentifierOrLiteral()) {
                                        throw new CompileException("unexpected symbol '" + this.expr[this.cursor] + "'", this.expr, this.cursor);
                                    }
                                    this.captureToEOS();
                                    int idx2 = this.pCtx.variableIndexOf(name);
                                    if (idx2 != -1) {
                                        this.lastNode = new IndexedOperativeAssign(this.subArray(this.start, this.cursor), 0, idx2, this.fields);
                                        return this.lastNode;
                                    }
                                    this.lastNode = new OperativeAssign(name, this.subArray(this.start, this.cursor), 0, this.fields);
                                    return this.lastNode;
                                }
                                if (this.lookAhead() == '-') {
                                    String name = new String(this.expr, this.start, this.trimLeft(this.cursor) - this.start);
                                    this.start = this.cursor += 2;
                                    if (!this.isNextIdentifierOrLiteral()) {
                                        throw new CompileException("unexpected symbol '" + this.expr[this.cursor] + "'", this.expr, this.cursor);
                                    }
                                    this.captureToEOS();
                                    int idx3 = this.pCtx.variableIndexOf(name);
                                    if (idx3 != -1) {
                                        this.lastNode = new IndexedOperativeAssign(this.subArray(this.start, this.cursor), 1, idx3, this.fields);
                                        return this.lastNode;
                                    }
                                    this.lastNode = new OperativeAssign(name, this.subArray(this.start, this.cursor), 1, this.fields);
                                    return this.lastNode;
                                }
                                if (!this.greedy || this.lookAhead() == '=') break;
                                ++this.cursor;
                                this.captureToEOS();
                                if (union) {
                                    this.lastNode = new DeepAssignmentNode(this.subArray(this.start, this.cursor), this.fields | 0x400, this.pCtx);
                                    return this.lastNode;
                                }
                                if (this.lastWasIdentifier) {
                                    if (this.lastNode.getLiteralValue() instanceof String) {
                                        TypeDescriptor tDescr = new TypeDescriptor(((String)this.lastNode.getLiteralValue()).toCharArray(), 0);
                                        try {
                                            this.lastNode.setLiteralValue(TypeDescriptor.getClassReference(this.pCtx, tDescr));
                                            this.lastNode.discard();
                                        }
                                        catch (Exception e) {
                                            // empty catch block
                                        }
                                    }
                                    if (this.lastNode.isLiteral() && this.lastNode.getLiteralValue() instanceof Class) {
                                        this.lastNode.discard();
                                        this.captureToEOS();
                                        return new TypedVarNode(this.subArray(this.start, this.cursor), this.fields | 0x400, (Class)this.lastNode.getLiteralValue(), this.pCtx);
                                    }
                                    if ((this.fields & 0x10) != 0 || !(this.stk.peek() instanceof Class)) throw new CompileException("unknown class or illegal statement: " + this.lastNode.getLiteralValue(), this.expr, this.cursor);
                                    this.captureToEOS();
                                    return new TypedVarNode(this.subArray(this.start, this.cursor), this.fields | 0x400, (Class)this.stk.pop(), this.pCtx);
                                }
                                if (this.pCtx != null && ((idx = this.pCtx.variableIndexOf(t)) != -1 || this.pCtx.isIndexAllocation())) {
                                    IndexedAssignmentNode ian = new IndexedAssignmentNode(this.subArray(this.start, this.cursor), 1024, idx, this.pCtx);
                                    if (idx == -1) {
                                        t = ian.getAssignmentVar();
                                        this.pCtx.addIndexedVariable(t);
                                        ian.setRegister(this.pCtx.variableIndexOf(t));
                                    }
                                    this.lastNode = ian;
                                    return this.lastNode;
                                }
                                this.lastNode = new AssignmentNode(this.subArray(this.start, this.cursor), this.fields | 0x400, this.pCtx);
                                return this.lastNode;
                            }
                        }
                    }
                    this.trimWhitespace();
                    return this.createPropertyToken(this.start, this.cursor);
                }
                switch (this.expr[this.cursor]) {
                    case '.': {
                        ++this.cursor;
                        if (ParseTools.isDigit(this.expr[this.cursor])) {
                            capture = true;
                            continue block92;
                        }
                        this.expectNextChar_IW('{');
                        char[] tmp = this.subArray(this.start, this.cursor - 1);
                        this.start = this.cursor;
                        this.cursor = ParseTools.balancedCapture(this.expr, this.start, '{') + 1;
                        this.lastNode = new ThisWithNode(tmp, this.subArray(this.start + 1, this.cursor - 1), this.fields);
                        return this.lastNode;
                    }
                    case '@': {
                        ++this.start;
                        this.captureToEOT();
                        if (this.pCtx.getInterceptors() == null) throw new CompileException("reference to undefined interceptor: " + new String(this.expr, this.start, this.cursor - this.start), this.expr, this.cursor);
                        String name = new String(this.expr, this.start, this.cursor - this.start);
                        if (!this.pCtx.getInterceptors().containsKey(name)) {
                            throw new CompileException("reference to undefined interceptor: " + new String(this.expr, this.start, this.cursor - this.start), this.expr, this.cursor);
                        }
                        this.lastNode = new InterceptorWrapper(this.pCtx.getInterceptors().get(name), this.nextToken());
                        return this.lastNode;
                    }
                    case '=': {
                        return this.createOperator(this.expr, this.start, this.cursor += 2);
                    }
                    case '-': {
                        if (this.lookAhead() == '-') {
                            this.cursor += 2;
                            this.skipWhitespace();
                            this.start = this.cursor;
                            this.captureIdentifier();
                            String name = new String(this.subArray(this.start, this.cursor));
                            int idx = this.pCtx.variableIndexOf(name);
                            if (idx != -1) {
                                this.lastNode = new IndexedPreFixDecNode(idx);
                                return this.lastNode;
                            }
                            this.lastNode = new PreFixDecNode(name);
                            return this.lastNode;
                        }
                        if (this.cursor != 0 && !ParseTools.isWhitespace(this.lookBehind()) || !ParseTools.isDigit(this.lookAhead())) {
                            return this.createOperator(this.expr, this.start, this.cursor++ + 1);
                        }
                        if (this.cursor - 1 != 0 || !ParseTools.isDigit(this.lookBehind()) && ParseTools.isDigit(this.lookAhead())) {
                            ++this.cursor;
                            continue block92;
                        }
                    }
                    case '+': {
                        if (this.lookAhead() != '+') return this.createOperator(this.expr, this.start, this.cursor++ + 1);
                        this.cursor += 2;
                        this.skipWhitespace();
                        this.start = this.cursor;
                        this.captureIdentifier();
                        String name = new String(this.subArray(this.start, this.cursor));
                        int idx = this.pCtx.variableIndexOf(name);
                        if (idx != -1) {
                            this.lastNode = new IndexedPreFixIncNode(idx);
                            return this.lastNode;
                        }
                        this.lastNode = new PreFixIncNode(name);
                        return this.lastNode;
                    }
                    case '*': {
                        if (this.lookAhead() != '*') return this.createOperator(this.expr, this.start, this.cursor++ + 1);
                        ++this.cursor;
                        return this.createOperator(this.expr, this.start, this.cursor++ + 1);
                    }
                    case ';': {
                        ++this.cursor;
                        this.lastWasIdentifier = false;
                        this.lastNode = new EndOfStatement();
                        return this.lastNode;
                    }
                    case '#': 
                    case '/': {
                        switch (this.skipCommentBlock()) {
                            case -1: {
                                return null;
                            }
                            case 0: {
                                continue block92;
                            }
                        }
                    }
                    case '%': 
                    case ':': 
                    case '?': 
                    case '^': {
                        return this.createOperator(this.expr, this.start, this.cursor++ + 1);
                    }
                    case '(': {
                        int st;
                        TypeDescriptor tDescr;
                        ++this.cursor;
                        boolean singleToken = true;
                        boolean lastWS = false;
                        this.skipWhitespace();
                        int brace = 1;
                        while (this.cursor != this.length && brace != 0) {
                            block68 : switch (this.expr[this.cursor]) {
                                case '(': {
                                    ++brace;
                                    break;
                                }
                                case ')': {
                                    --brace;
                                    break;
                                }
                                case '\'': {
                                    this.cursor = ParseTools.captureStringLiteral('\'', this.expr, this.cursor, this.length);
                                    break;
                                }
                                case '\"': {
                                    this.cursor = ParseTools.captureStringLiteral('\"', this.expr, this.cursor, this.length);
                                    break;
                                }
                                case 'i': {
                                    if (this.lookAhead() != 'n' || !ParseTools.isWhitespace(this.lookAhead(2))) break;
                                    int level = brace;
                                    while (this.cursor != this.length) {
                                        switch (this.expr[this.cursor]) {
                                            case '(': {
                                                ++brace;
                                                break;
                                            }
                                            case ')': {
                                                if (--brace >= level) break;
                                                ++this.cursor;
                                                if (this.tokenContinues()) {
                                                    this.lastNode = new Fold(ParseTools.subset(this.expr, this.trimRight(this.start + 1), this.cursor - this.start - 2), this.fields);
                                                    this.start = this.cursor;
                                                    if (this.expr[this.start] == '.') {
                                                        ++this.start;
                                                    }
                                                    this.captureToEOT();
                                                    this.lastNode = new Union(this.expr, this.trimRight(this.start), this.cursor, this.fields, this.lastNode);
                                                    return this.lastNode;
                                                }
                                                this.lastNode = new Fold(ParseTools.subset(this.expr, this.trimRight(this.start + 1), this.cursor - this.start - 2), this.fields);
                                                return this.lastNode;
                                            }
                                            case '\'': {
                                                this.cursor = ParseTools.captureStringLiteral('\'', this.expr, this.cursor, this.length);
                                                break;
                                            }
                                            case '\"': {
                                                this.cursor = ParseTools.captureStringLiteral('\"', this.expr, this.cursor, this.length);
                                            }
                                        }
                                        ++this.cursor;
                                    }
                                    throw new CompileException("unterminated projection; closing parathesis required", this.expr, this.cursor);
                                }
                                default: {
                                    if (lastWS && this.expr[this.cursor] != '.') {
                                        switch (this.expr[this.cursor]) {
                                            case '[': 
                                            case ']': {
                                                break block68;
                                            }
                                        }
                                        if (ParseTools.isIdentifierPart(this.expr[this.cursor]) || this.expr[this.cursor] == '.') break;
                                        singleToken = false;
                                        break;
                                    }
                                    if (!ParseTools.isWhitespace(this.expr[this.cursor])) break;
                                    lastWS = true;
                                    this.skipWhitespace();
                                    --this.cursor;
                                }
                            }
                            ++this.cursor;
                        }
                        if (brace != 0) {
                            throw new CompileException("unbalanced braces in expression: (" + brace + "):", this.expr, this.cursor);
                        }
                        char[] tmp = null;
                        if (singleToken && (tDescr = new TypeDescriptor(tmp = ParseTools.subset(this.expr, st = this.trimRight(this.start + 1), this.trimLeft(this.cursor - 1) - st), this.fields)).getClassName() != null) {
                            try {
                                Class cls = TypeDescriptor.getClassReference(this.pCtx, tDescr);
                                this.start = this.cursor;
                                this.captureToEOS();
                                this.lastNode = new TypeCast(ParseTools.subset(this.expr, this.start, this.cursor - this.start), cls, this.fields);
                                return this.lastNode;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        if (tmp != null) {
                            return this.handleUnion(this.handleSubstatement(new Substatement(tmp, this.fields)));
                        }
                        this.start = this.trimRight(this.start + 1);
                        return this.handleUnion(this.handleSubstatement(new Substatement(ParseTools.subset(this.expr, this.start, this.trimLeft(this.cursor - 1) - this.start), this.fields)));
                    }
                    case ')': 
                    case ']': 
                    case '}': {
                        throw new CompileException("unbalanced braces", this.expr, this.cursor);
                    }
                    case '>': {
                        if (this.expr[this.cursor + 1] == '>') {
                            if (this.expr[this.cursor += 2] != '>') return this.createOperator(this.expr, this.start, this.cursor);
                            ++this.cursor;
                            return this.createOperator(this.expr, this.start, this.cursor);
                        }
                        if (this.expr[this.cursor + 1] != '=') return this.createOperator(this.expr, this.start, ++this.cursor);
                        return this.createOperator(this.expr, this.start, this.cursor += 2);
                    }
                    case '<': {
                        if (this.expr[++this.cursor] == '<') {
                            if (this.expr[++this.cursor] != '<') return this.createOperator(this.expr, this.start, this.cursor);
                            ++this.cursor;
                            return this.createOperator(this.expr, this.start, this.cursor);
                        }
                        if (this.expr[this.cursor] != '=') return this.createOperator(this.expr, this.start, this.cursor);
                        return this.createOperator(this.expr, this.start, ++this.cursor);
                    }
                    case '\"': 
                    case '\'': {
                        this.cursor = ParseTools.captureStringLiteral(this.expr[this.cursor], this.expr, this.cursor, this.length);
                        this.lastNode = new LiteralNode(ParseTools.handleStringEscapes(ParseTools.subset(this.expr, this.start + 1, this.cursor - this.start - 1)), String.class);
                        ++this.cursor;
                        if (!this.tokenContinues()) return this.lastNode;
                        this.lastNode = this.handleUnion(this.lastNode);
                        return this.lastNode;
                    }
                    case '&': {
                        if (this.expr[this.cursor++ + 1] != '&') return this.createOperator(this.expr, this.start, this.cursor);
                        return this.createOperator(this.expr, this.start, ++this.cursor);
                    }
                    case '|': {
                        if (this.expr[this.cursor++ + 1] != '|') return this.createOperator(this.expr, this.start, this.cursor);
                        return new OperatorNode(OPERATORS.get(new String(this.expr, this.start, ++this.cursor - this.start)));
                    }
                    case '~': {
                        if ((this.cursor++ - 1 != 0 || !ParseTools.isIdentifierPart(this.lookBehind())) && ParseTools.isDigit(this.expr[this.cursor])) {
                            this.start = this.cursor;
                            this.captureToEOT();
                            this.lastNode = new Invert(ParseTools.subset(this.expr, this.start, this.cursor - this.start), this.fields);
                            return this.lastNode;
                        }
                        if (this.expr[this.cursor] == '(') {
                            this.start = this.cursor--;
                            this.captureToEOT();
                            this.lastNode = new Invert(ParseTools.subset(this.expr, this.start, this.cursor - this.start), this.fields);
                            return this.lastNode;
                        }
                        if (this.expr[this.cursor] != '=') return this.createOperator(this.expr, this.start, this.cursor);
                        ++this.cursor;
                        return this.createOperator(this.expr, this.start, this.cursor);
                    }
                    case '!': {
                        ++this.cursor;
                        if (this.isNextIdentifier()) {
                            if (this.lastNode != null && !this.lastNode.isOperator()) {
                                throw new CompileException("unexpected operator '!'", this.expr, this.cursor);
                            }
                            this.start = this.cursor;
                            this.captureToEOT();
                            String name = new String(this.expr, this.start, this.cursor - this.start);
                            if ("new".equals(name) || "isdef".equals(name)) {
                                this.captureToEOT();
                                this.lastNode = new Negation(ParseTools.subset(this.expr, this.start, this.cursor - this.start), this.fields);
                                return this.lastNode;
                            }
                            this.lastNode = new Negation(name.toCharArray(), this.fields);
                            return this.lastNode;
                        }
                        if (this.expr[this.cursor] == '(') {
                            this.start = this.cursor--;
                            this.captureToEOT();
                            this.lastNode = new Negation(ParseTools.subset(this.expr, this.start, this.cursor - this.start), this.fields);
                            return this.lastNode;
                        }
                        if (this.expr[this.cursor] == '=') return this.createOperator(this.expr, this.start, ++this.cursor);
                        throw new CompileException("unexpected operator '!'", this.expr, this.cursor, null);
                    }
                    case '[': 
                    case '{': {
                        this.cursor = ParseTools.balancedCapture(this.expr, this.cursor, this.expr[this.cursor]) + 1;
                        if (this.tokenContinues()) {
                            this.start = this.cursor;
                            this.lastNode = new InlineCollectionNode(this.expr, this.start, this.start, this.fields, this.pCtx);
                            this.captureToEOT();
                            if (this.expr[this.start] == '.') {
                                ++this.start;
                            }
                            this.lastNode = new Union(this.expr, this.start, this.cursor, this.fields, this.lastNode);
                            return this.lastNode;
                        }
                        this.lastNode = new InlineCollectionNode(this.expr, this.start, this.cursor, this.fields, this.pCtx);
                        return this.lastNode;
                    }
                }
                ++this.cursor;
            }
            if (this.start != this.cursor) return this.createPropertyToken(this.start, this.cursor);
            return null;
        }
        catch (NumberFormatException e) {
            CompileException c = new CompileException("badly formatted number: " + e.getMessage(), this.expr, this.cursor, e);
            c.setLineNumber(this.line);
            c.setColumn(this.cursor - this.lastLineStart);
            throw c;
        }
        catch (StringIndexOutOfBoundsException e) {
            CompileException c = new CompileException("unexpected end of statement", this.expr, this.cursor, e);
            c.setLineNumber(this.line);
            c.setColumn(this.cursor - this.lastLineStart);
            throw c;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            CompileException c = new CompileException("unexpected end of statement", this.expr, this.cursor, e);
            c.setLineNumber(this.line);
            c.setColumn(this.cursor - this.lastLineStart);
            throw c;
        }
        catch (CompileException e) {
            e.setExpr(this.expr);
            e.setLineNumber(this.line);
            e.setColumn(this.cursor - this.lastLineStart);
            throw e;
        }
    }

    public ASTNode handleSubstatement(Substatement stmt) {
        if (stmt.getStatement() != null && stmt.getStatement().isLiteralOnly()) {
            return new LiteralNode(stmt.getStatement().getValue(null, null, null));
        }
        return stmt;
    }

    protected ASTNode handleUnion(ASTNode node) {
        if (this.cursor != this.length) {
            this.skipWhitespace();
            if (this.expr[this.cursor] == '.') {
                int union = this.cursor + 1;
                this.captureToEOT();
                this.lastNode = new Union(this.expr, union, this.cursor, this.fields, node);
                return this.lastNode;
            }
        }
        this.lastNode = node;
        return this.lastNode;
    }

    private ASTNode createOperator(char[] expr, int start, int end) {
        this.lastWasIdentifier = false;
        this.lastNode = new OperatorNode(OPERATORS.get(new String(expr, start, end - start)));
        return this.lastNode;
    }

    private char[] subArray(int start, int end) {
        if (start >= end) {
            return new char[0];
        }
        char[] newA = new char[end - start];
        for (int i = 0; i != newA.length; ++i) {
            newA[i] = this.expr[i + start];
        }
        return newA;
    }

    private ASTNode createPropertyToken(int start, int end) {
        String tmp;
        this.lastWasIdentifier = true;
        if (parserContext != null && parserContext.get() != null && parserContext.get().hasImports()) {
            char[] _subset = ParseTools.subset(this.expr, start, this.cursor - start);
            int offset = ArrayTools.findFirst('.', _subset);
            if (offset != -1) {
                String iStr = new String(_subset, 0, offset);
                if (this.pCtx.hasImport(iStr)) {
                    this.lastNode = new LiteralDeepPropertyNode(ParseTools.subset(_subset, offset + 1, _subset.length - offset - 1), this.fields, this.pCtx.getImport(iStr));
                    return this.lastNode;
                }
            } else {
                tmp = new String(_subset);
                if (this.pCtx.hasImport(tmp)) {
                    this.lastNode = new LiteralNode(this.pCtx.getStaticOrClassImport(tmp));
                    return this.lastNode;
                }
                this.lastWasIdentifier = true;
            }
        }
        if (LITERALS.containsKey(tmp = new String(this.expr, start, end - start))) {
            this.lastNode = new LiteralNode(LITERALS.get(tmp));
            return this.lastNode;
        }
        if (OPERATORS.containsKey(tmp)) {
            this.lastNode = new OperatorNode(OPERATORS.get(tmp));
            return this.lastNode;
        }
        this.lastNode = new ASTNode(this.expr, start, end, this.fields);
        return this.lastNode;
    }

    private ASTNode createBlockToken(int condStart, int condEnd, int blockStart, int blockEnd, int type) {
        this.lastWasIdentifier = false;
        ++this.cursor;
        if (this.isStatementNotManuallyTerminated()) {
            this.splitAccumulator.add(new EndOfStatement());
        }
        switch (type) {
            case 65536: {
                return new IfNode(this.subArray(condStart, condEnd), this.subArray(blockStart, blockEnd), this.fields);
            }
            case 0x800000: {
                for (int i = condStart; i < condEnd; ++i) {
                    if (this.expr[i] == ';') {
                        return new ForNode(this.subArray(condStart, condEnd), this.subArray(blockStart, blockEnd), this.fields);
                    }
                    if (this.expr[i] == ':') break;
                }
            }
            case 131072: {
                return new ForEachNode(this.subArray(condStart, condEnd), this.subArray(blockStart, blockEnd), this.fields, this.pCtx);
            }
            case 0x100000: {
                return new WhileNode(this.subArray(condStart, condEnd), this.subArray(blockStart, blockEnd), this.fields);
            }
            case 524288: {
                return new UntilNode(this.subArray(condStart, condEnd), this.subArray(blockStart, blockEnd), this.fields);
            }
            case 0x200000: {
                return new DoNode(this.subArray(condStart, condEnd), this.subArray(blockStart, blockEnd), this.fields);
            }
            case 0x400000: {
                return new DoUntilNode(this.subArray(condStart, condEnd), this.subArray(blockStart, blockEnd));
            }
        }
        return new WithNode(this.subArray(condStart, condEnd), this.subArray(blockStart, blockEnd), this.fields);
    }

    private ASTNode captureCodeBlock(int type) {
        boolean cond = true;
        ASTNode first = null;
        ASTNode tk = null;
        switch (type) {
            case 65536: {
                do {
                    if (tk != null) {
                        this.captureToNextTokenJunction();
                        this.skipWhitespace();
                        boolean bl = cond = this.expr[this.cursor] != '{' && this.expr[this.cursor] == 'i' && this.expr[++this.cursor] == 'f' && this.expr[this.cursor = this.incNextNonBlank()] == '(';
                    }
                    if (((IfNode)(tk = this._captureBlock(tk, this.expr, cond, type))).getElseBlock() != null) {
                        ++this.cursor;
                        return first;
                    }
                    if (first == null) {
                        first = tk;
                    }
                    if (this.cursor == this.length || this.expr[this.cursor] == ';') continue;
                    ++this.cursor;
                } while (this.ifThenElseBlockContinues());
                return first;
            }
            case 0x200000: {
                this.skipWhitespaceWithLineAccounting();
                return this._captureBlock(null, this.expr, false, type);
            }
        }
        this.captureToNextTokenJunction();
        this.skipWhitespaceWithLineAccounting();
        return this._captureBlock(null, this.expr, true, type);
    }

    private ASTNode _captureBlock(ASTNode node, char[] expr, boolean cond, int type) {
        int blockEnd;
        int blockStart;
        int[] cap;
        this.skipWhitespace();
        int startCond = 0;
        int endCond = 0;
        if (type == 100) {
            int blockEnd2;
            int blockStart2;
            int start = this.cursor;
            this.captureToNextTokenJunction();
            if (this.cursor == this.length) {
                throw new CompileException("unexpected end of statement", expr, start);
            }
            startCond = this.cursor;
            String name = ParseTools.createStringTrimmed(expr, start, startCond - start);
            if (AbstractParser.isReservedWord(name) || AbstractParser.isNotValidNameorLabel(name)) {
                throw new CompileException("illegal function name or use of reserved word", expr, this.cursor);
            }
            this.cursor = this.nextNonBlank();
            if (expr[this.cursor] == '(') {
                startCond = this.cursor;
                this.cursor = ParseTools.balancedCapture(expr, startCond, '(');
                endCond = this.cursor++;
                ++startCond;
                this.skipWhitespace();
                if (this.cursor >= this.length) {
                    throw new CompileException("incomplete statement", expr, this.cursor);
                }
                if (expr[this.cursor] == '{') {
                    blockStart2 = this.cursor;
                    blockEnd2 = this.cursor = ParseTools.balancedCapture(expr, blockStart2, '{');
                } else {
                    blockStart2 = this.cursor - 1;
                    this.captureToEOS();
                    blockEnd2 = this.cursor;
                }
            } else if (expr[this.cursor] == '{') {
                blockStart2 = this.cursor;
                blockEnd2 = this.cursor = ParseTools.balancedCapture(expr, blockStart2, '{');
            } else {
                blockStart2 = this.cursor - 1;
                this.captureToEOS();
                blockEnd2 = this.cursor;
            }
            blockStart2 = this.trimRight(blockStart2 + 1);
            blockEnd2 = this.trimLeft(blockEnd2);
            ++this.cursor;
            if (this.isStatementNotManuallyTerminated()) {
                this.splitAccumulator.add(new EndOfStatement());
            }
            return new Function(name, this.subArray(startCond, endCond), this.subArray(blockStart2, blockEnd2), this.pCtx);
        }
        if (cond) {
            if (expr[this.cursor] != '(') {
                throw new CompileException("expected '(' but encountered: " + expr[this.cursor]);
            }
            startCond = this.cursor;
            cap = ParseTools.balancedCaptureWithLineAccounting(expr, startCond, '(');
            this.cursor = cap[0];
            endCond = this.cursor++;
            ++startCond;
            this.pCtx.incrementLineCount(cap[1]);
        }
        this.skipWhitespace();
        if (this.cursor >= this.length) {
            throw new CompileException("unexpected end of statement", expr, this.cursor);
        }
        if (expr[this.cursor] == '{') {
            blockStart = this.cursor;
            cap = ParseTools.balancedCaptureWithLineAccounting(expr, blockStart, '{');
            blockEnd = this.cursor = cap[0];
            this.pCtx.incrementLineCount(cap[1]);
        } else {
            blockStart = this.cursor - 1;
            this.captureToEOSorEOL();
            blockEnd = this.cursor + 1;
        }
        if (type == 65536) {
            IfNode ifNode = (IfNode)node;
            if (node != null) {
                if (!cond) {
                    return ifNode.setElseBlock(this.subArray(this.trimRight(blockStart + 1), this.trimLeft(blockEnd - 1)));
                }
                return ifNode.setElseIf((IfNode)this.createBlockToken(startCond, endCond, this.trimRight(blockStart + 1), this.trimLeft(blockEnd), type));
            }
            return this.createBlockToken(startCond, endCond, blockStart + 1, blockEnd, type);
        }
        if (type == 0x200000) {
            ++this.cursor;
            this.skipWhitespaceWithLineAccounting();
            this.start = this.cursor;
            this.captureToNextTokenJunction();
            String name = new String(expr, this.start, this.cursor - this.start);
            if ("while".equals(name)) {
                this.skipWhitespaceWithLineAccounting();
                startCond = this.cursor + 1;
                cap = ParseTools.balancedCaptureWithLineAccounting(expr, this.cursor, '(');
                endCond = this.cursor = cap[0];
                this.pCtx.incrementLineCount(cap[1]);
                return this.createBlockToken(startCond, endCond, this.trimRight(blockStart + 1), this.trimLeft(blockEnd), type);
            }
            if ("until".equals(name)) {
                this.skipWhitespaceWithLineAccounting();
                startCond = this.cursor + 1;
                cap = ParseTools.balancedCaptureWithLineAccounting(expr, this.cursor, '(');
                endCond = this.cursor = cap[0];
                this.pCtx.incrementLineCount(cap[1]);
                return this.createBlockToken(startCond, endCond, this.trimRight(blockStart + 1), this.trimLeft(blockEnd), 0x400000);
            }
            throw new CompileException("expected 'while' or 'until' but encountered: " + name, expr, this.cursor);
        }
        return this.createBlockToken(startCond, endCond, this.trimRight(blockStart + 1), this.trimLeft(blockEnd), type);
    }

    protected boolean ifThenElseBlockContinues() {
        if (this.cursor + 4 < this.length) {
            if (this.expr[this.cursor] != ';') {
                --this.cursor;
            }
            this.skipWhitespaceWithLineAccounting();
            this.skipCommentBlock();
            return this.expr[this.cursor] == 'e' && this.expr[this.cursor + 1] == 'l' && this.expr[this.cursor + 2] == 's' && this.expr[this.cursor + 3] == 'e' && (ParseTools.isWhitespace(this.expr[this.cursor + 4]) || this.expr[this.cursor + 4] == '{');
        }
        return false;
    }

    protected int skipCommentBlock() {
        if (this.lookAhead() == this.expr[this.cursor]) {
            this.captureToEOL();
            this.line = this.pCtx.getLineCount();
            this.skipWhitespaceWithLineAccounting();
            if (this.lastNode instanceof LineLabel) {
                this.pCtx.getLastLineLabel().setLineNumber(this.line);
                this.pCtx.addKnownLine(this.line);
            }
            this.lastWasComment = true;
            this.pCtx.setLineCount(this.line);
            this.start = this.cursor;
            if (this.start >= this.length) {
                return -1;
            }
            return 0;
        }
        if (this.expr[this.cursor] == '/' && this.lookAhead() == '*') {
            int len = this.length - 1;
            this.line = this.pCtx.getLineCount();
            do {
                ++this.cursor;
                this.skipWhitespaceWithLineAccounting();
                if (this.cursor != len) continue;
                throw new CompileException("unterminated block comment", this.expr, this.cursor);
            } while (this.expr[this.cursor] != '*' || this.lookAhead() != '/');
            if ((this.cursor += 2) >= this.length) {
                return 0;
            }
            this.skipWhitespaceWithLineAccounting();
            this.start = this.cursor;
            this.pCtx.setLineCount(this.line);
            if (this.lastNode instanceof LineLabel) {
                this.pCtx.getLastLineLabel().setLineNumber(this.line);
                this.pCtx.addKnownLine(this.line);
            }
            this.lastWasComment = true;
            return 0;
        }
        return 1;
    }

    protected boolean tokenContinues() {
        if (this.cursor == this.length) {
            return false;
        }
        if (this.expr[this.cursor] == '.' || this.expr[this.cursor] == '[') {
            return true;
        }
        if (ParseTools.isWhitespace(this.expr[this.cursor])) {
            int markCurrent = this.cursor;
            this.skipWhitespace();
            if (this.cursor != this.length && (this.expr[this.cursor] == '.' || this.expr[this.cursor] == '[')) {
                return true;
            }
            this.cursor = markCurrent;
        }
        return false;
    }

    protected void expectEOS() {
        this.skipWhitespace();
        if (this.cursor != this.length && this.expr[this.cursor] != ';') {
            switch (this.expr[this.cursor]) {
                case '&': {
                    if (this.lookAhead() != '&') break;
                    return;
                }
                case '|': {
                    if (this.lookAhead() != '|') break;
                    return;
                }
                case '!': {
                    if (this.lookAhead() != '=') break;
                    return;
                }
                case '<': 
                case '>': {
                    return;
                }
                case '=': {
                    switch (this.lookAhead()) {
                        case '*': 
                        case '+': 
                        case '-': 
                        case '=': {
                            return;
                        }
                    }
                    break;
                }
                case '*': 
                case '+': 
                case '-': 
                case '/': {
                    if (this.lookAhead() != '=') break;
                    return;
                }
            }
            throw new CompileException("expected end of statement but encountered: " + (this.cursor == this.length ? "<end of stream>" : Character.valueOf(this.expr[this.cursor])), this.expr, this.cursor);
        }
    }

    protected boolean isNextIdentifier() {
        while (this.cursor != this.length && ParseTools.isWhitespace(this.expr[this.cursor])) {
            ++this.cursor;
        }
        return this.cursor != this.length && ParseTools.isIdentifierPart(this.expr[this.cursor]);
    }

    protected void captureToEOS() {
        while (this.cursor != this.length) {
            switch (this.expr[this.cursor]) {
                case '(': 
                case '[': 
                case '{': {
                    this.cursor = ParseTools.balancedCapture(this.expr, this.cursor, this.expr[this.cursor]);
                    if (this.cursor < this.length) break;
                    return;
                }
                case ';': 
                case '}': {
                    return;
                }
            }
            ++this.cursor;
        }
    }

    protected void captureToEOSorEOL() {
        while (this.cursor != this.length && this.expr[this.cursor] != '\n' && this.expr[this.cursor] != '\r' && this.expr[this.cursor] != ';') {
            ++this.cursor;
        }
    }

    protected void captureToEOL() {
        while (this.cursor != this.length && this.expr[this.cursor] != '\n') {
            ++this.cursor;
        }
    }

    protected void captureIdentifier() {
        boolean captured = false;
        if (this.cursor == this.length) {
            throw new CompileException("unexpected end of statement: EOF", this.expr, this.cursor);
        }
        while (this.cursor != this.length) {
            switch (this.expr[this.cursor]) {
                case ';': {
                    return;
                }
            }
            if (!ParseTools.isIdentifierPart(this.expr[this.cursor])) {
                if (captured) {
                    return;
                }
                throw new CompileException("unexpected symbol (was expecting an identifier): " + this.expr[this.cursor], this.expr, this.cursor);
            }
            captured = true;
            ++this.cursor;
        }
    }

    protected void captureToEOT() {
        this.skipWhitespace();
        block7: do {
            switch (this.expr[this.cursor]) {
                case '(': 
                case '[': 
                case '{': {
                    this.cursor = ParseTools.balancedCapture(this.expr, this.cursor, this.expr[this.cursor]);
                    if (this.cursor != -1) continue block7;
                    throw new CompileException("unbalanced braces", this.expr, this.cursor);
                }
                case '&': 
                case ';': 
                case '=': 
                case '|': {
                    return;
                }
                case '.': {
                    this.skipWhitespace();
                    break;
                }
                case '\'': {
                    this.cursor = ParseTools.captureStringLiteral('\'', this.expr, this.cursor, this.length);
                    break;
                }
                case '\"': {
                    this.cursor = ParseTools.captureStringLiteral('\"', this.expr, this.cursor, this.length);
                    break;
                }
                default: {
                    if (!ParseTools.isWhitespace(this.expr[this.cursor])) continue block7;
                    this.skipWhitespace();
                    if (this.expr[this.cursor] == '.') {
                        if (this.cursor != this.length) {
                            ++this.cursor;
                        }
                        this.skipWhitespace();
                        break;
                    }
                    this.trimWhitespace();
                    return;
                }
            }
        } while (++this.cursor != this.length);
    }

    protected boolean lastNonWhite(char c) {
        int i = this.cursor - 1;
        while (ParseTools.isWhitespace(this.expr[i])) {
            --i;
        }
        return c == this.expr[i];
    }

    protected int trimLeft(int pos) {
        while (pos != 0 && pos > this.start && ParseTools.isWhitespace(this.expr[pos - 1])) {
            --pos;
        }
        return pos;
    }

    protected int trimRight(int pos) {
        while (pos != this.length && ParseTools.isWhitespace(this.expr[pos])) {
            ++pos;
        }
        return pos;
    }

    protected void skipWhitespace() {
        while (this.cursor != this.length && ParseTools.isWhitespace(this.expr[this.cursor])) {
            ++this.cursor;
        }
    }

    protected void skipWhitespaceWithLineAccounting() {
        block4: while (this.cursor != this.length && ParseTools.isWhitespace(this.expr[this.cursor])) {
            switch (this.expr[this.cursor]) {
                case '\n': {
                    ++this.line;
                    this.lastLineStart = this.cursor;
                }
                case '\r': {
                    ++this.cursor;
                    continue block4;
                }
            }
            ++this.cursor;
        }
    }

    protected void captureToNextTokenJunction() {
        block4: while (this.cursor != this.length) {
            switch (this.expr[this.cursor]) {
                case '(': 
                case '{': {
                    return;
                }
                case '[': {
                    int[] c = ParseTools.balancedCaptureWithLineAccounting(this.expr, this.cursor, '[');
                    this.cursor = c[0] + 1;
                    this.line += c[1];
                    continue block4;
                }
            }
            if (ParseTools.isWhitespace(this.expr[this.cursor])) {
                return;
            }
            ++this.cursor;
        }
    }

    protected void trimWhitespace() {
        while (this.cursor != 0 && ParseTools.isWhitespace(this.expr[this.cursor - 1])) {
            --this.cursor;
        }
    }

    public static boolean isReservedWord(String name) {
        return LITERALS.containsKey(name) || OPERATORS.containsKey(name);
    }

    public static boolean isNotValidNameorLabel(String name) {
        for (char c : name.toCharArray()) {
            if (c == '.') {
                return true;
            }
            if (ParseTools.isIdentifierPart(c)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setExpression(String expression) {
        if (expression != null && expression.length() != 0) {
            WeakHashMap<String, char[]> weakHashMap = EX_PRECACHE;
            synchronized (weakHashMap) {
                this.expr = EX_PRECACHE.get(expression);
                if (this.expr == null) {
                    this.expr = expression.toCharArray();
                    this.length = this.expr.length;
                    while (this.length != 0 && ParseTools.isWhitespace(this.expr[this.length - 1])) {
                        --this.length;
                    }
                    char[] e = new char[this.length];
                    for (int i = 0; i != e.length; ++i) {
                        e[i] = this.expr[i];
                    }
                    EX_PRECACHE.put(expression, e);
                } else {
                    this.length = this.expr.length;
                }
            }
        }
    }

    protected void setExpression(char[] expression) {
        this.expr = expression;
        this.length = expression.length;
        while (this.length != 0 && ParseTools.isWhitespace(this.expr[this.length - 1])) {
            --this.length;
        }
    }

    protected char lookToLast() {
        if (this.cursor == 0) {
            return '\u0000';
        }
        int temp = this.cursor;
        while (temp != 0 && ParseTools.isWhitespace(this.expr[--temp])) {
        }
        return this.expr[temp];
    }

    protected char lookBehind() {
        if (this.cursor == 0) {
            return '\u0000';
        }
        return this.expr[this.cursor - 1];
    }

    protected char lookAhead() {
        if (this.cursor < this.length) {
            return this.expr[this.cursor + 1];
        }
        return '\u0000';
    }

    protected char lookAhead(int range) {
        if (this.cursor + range >= this.length) {
            return '\u0000';
        }
        return this.expr[this.cursor + range];
    }

    protected boolean isNextIdentifierOrLiteral() {
        int tmp = this.cursor;
        if (tmp == this.length) {
            return false;
        }
        while (tmp != this.length && ParseTools.isWhitespace(this.expr[tmp])) {
            ++tmp;
        }
        if (tmp == this.length) {
            return false;
        }
        char n = this.expr[tmp];
        return ParseTools.isIdentifierPart(n) || ParseTools.isDigit(n) || n == '\'' || n == '\"';
    }

    public int incNextNonBlank() {
        ++this.cursor;
        return this.nextNonBlank();
    }

    public int nextNonBlank() {
        int i;
        if (this.cursor + 1 >= this.length) {
            return -1;
        }
        for (i = this.cursor; i != this.length && ParseTools.isWhitespace(this.expr[i]); ++i) {
        }
        return i;
    }

    public void expectNextChar_IW(char c) {
        this.nextNonBlank();
        if (this.cursor == this.length) {
            throw new CompileException("unexpected end of statement", this.expr, this.cursor);
        }
        if (this.expr[this.cursor] != c) {
            throw new CompileException("unexpected character ('" + this.expr[this.cursor] + "'); was expecting: " + c);
        }
    }

    protected boolean isStatementNotManuallyTerminated() {
        int c;
        if (this.cursor >= this.length) {
            return false;
        }
        for (c = this.cursor; c != this.length && ParseTools.isWhitespace(this.expr[c]); ++c) {
        }
        return c == this.length || this.expr[c] != ';';
    }

    protected ParserContext getParserContext() {
        if (parserContext == null || parserContext.get() == null) {
            this.newContext();
        }
        return parserContext.get();
    }

    public static ParserContext getCurrentThreadParserContext() {
        return AbstractParser.contextControl(3, null, null);
    }

    public static void setCurrentThreadParserContext(ParserContext pCtx) {
        AbstractParser.contextControl(0, pCtx, null);
    }

    public void newContext() {
        AbstractParser.contextControl(0, new ParserContext(), this);
    }

    public void newContext(ParserContext pCtx) {
        AbstractParser.contextControl(0, pCtx, this);
    }

    public void removeContext() {
        AbstractParser.contextControl(1, null, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParserContext contextControl(int operation, ParserContext pCtx, AbstractParser parser) {
        Runtime runtime = Runtime.getRuntime();
        synchronized (runtime) {
            if (parserContext == null) {
                parserContext = new ThreadLocal();
            }
            switch (operation) {
                case 0: {
                    pCtx.setRootParser(parser);
                    parserContext.set(pCtx);
                    return pCtx;
                }
                case 1: {
                    parserContext.set(null);
                    return null;
                }
                case 3: {
                    if (parserContext.get() == null) {
                        parserContext.set(new ParserContext(parser));
                    }
                }
                case 2: {
                    return parserContext.get();
                }
            }
        }
        return null;
    }

    public boolean isDebugSymbols() {
        return this.debugSymbols;
    }

    public void setDebugSymbols(boolean debugSymbols) {
        this.debugSymbols = debugSymbols;
    }

    protected static String getCurrentSourceFileName() {
        if (parserContext != null && parserContext.get() != null) {
            return parserContext.get().getSourceFile();
        }
        return null;
    }

    protected void addFatalError(String message) {
        this.getParserContext().addError(new ErrorDetail(this.getParserContext().getLineCount(), this.cursor - this.getParserContext().getLineOffset(), true, message));
    }

    protected void addFatalError(String message, int row, int cols) {
        this.getParserContext().addError(new ErrorDetail(row, cols, true, message));
    }

    protected void addWarning(String message) {
        this.getParserContext().addError(new ErrorDetail(message, false));
    }

    public static void setLanguageLevel(int level) {
        OPERATORS.clear();
        OPERATORS.putAll(AbstractParser.loadLanguageFeaturesByLevel(level));
    }

    public static HashMap<String, Integer> loadLanguageFeaturesByLevel(int languageLevel) {
        HashMap<String, Integer> operatorsTable = new HashMap<String, Integer>();
        switch (languageLevel) {
            case 5: {
                operatorsTable.put("if", 39);
                operatorsTable.put("else", 40);
                operatorsTable.put("?", 29);
                operatorsTable.put("switch", 44);
                operatorsTable.put("function", 100);
                operatorsTable.put("def", 100);
                operatorsTable.put("isdef", 47);
            }
            case 4: {
                operatorsTable.put("=", 31);
                operatorsTable.put("var", 98);
                operatorsTable.put("+=", 52);
                operatorsTable.put("-=", 53);
                operatorsTable.put("/=", 55);
                operatorsTable.put("%=", 56);
            }
            case 3: {
                operatorsTable.put("foreach", 38);
                operatorsTable.put("while", 41);
                operatorsTable.put("until", 42);
                operatorsTable.put("for", 43);
                operatorsTable.put("do", 45);
            }
            case 2: {
                operatorsTable.put("return", 99);
                operatorsTable.put(";", 37);
            }
            case 1: {
                operatorsTable.put("+", 0);
                operatorsTable.put("-", 1);
                operatorsTable.put("*", 2);
                operatorsTable.put("**", 5);
                operatorsTable.put("/", 3);
                operatorsTable.put("%", 4);
                operatorsTable.put("==", 18);
                operatorsTable.put("!=", 19);
                operatorsTable.put(">", 15);
                operatorsTable.put(">=", 17);
                operatorsTable.put("<", 14);
                operatorsTable.put("<=", 16);
                operatorsTable.put("&&", 21);
                operatorsTable.put("and", 21);
                operatorsTable.put("||", 22);
                operatorsTable.put("or", 23);
                operatorsTable.put("~=", 24);
                operatorsTable.put("instanceof", 25);
                operatorsTable.put("is", 25);
                operatorsTable.put("contains", 26);
                operatorsTable.put("soundslike", 27);
                operatorsTable.put("strsim", 28);
                operatorsTable.put("convertable_to", 36);
                operatorsTable.put("#", 20);
                operatorsTable.put("&", 6);
                operatorsTable.put("|", 7);
                operatorsTable.put("^", 8);
                operatorsTable.put("<<", 10);
                operatorsTable.put("<<<", 12);
                operatorsTable.put(">>", 9);
                operatorsTable.put(">>>", 11);
                operatorsTable.put("new", 34);
                operatorsTable.put("in", 35);
                operatorsTable.put("with", 46);
                operatorsTable.put("assert", 97);
                operatorsTable.put("import", 96);
                operatorsTable.put("import_static", 95);
                operatorsTable.put("++", 50);
                operatorsTable.put("--", 51);
            }
            case 0: {
                operatorsTable.put(":", 30);
            }
        }
        return operatorsTable;
    }

    public static void resetParserContext() {
        AbstractParser.contextControl(1, null, null);
    }

    protected static boolean isArithmeticOperator(int operator) {
        return operator != -1 && operator < 6;
    }

    protected int arithmeticFunctionReduction(int operator) {
        block30: {
            boolean x = false;
            int y = 0;
            ASTNode tk = this.nextToken();
            if (tk != null) {
                int operator2 = tk.getOperator();
                if (AbstractParser.isArithmeticOperator(operator2) && Operator.PTABLE[operator2] > Operator.PTABLE[operator]) {
                    this.xswap();
                    operator = operator2;
                    this.dStack.push(operator, this.nextToken().getReducedValue(this.ctx, this.ctx, this.variableFactory));
                    while (true) {
                        if ((tk = this.nextToken()) != null && (operator2 = tk.getOperator().intValue()) != -1 && operator2 != 37 && Operator.PTABLE[operator2] > Operator.PTABLE[operator]) {
                            if (x) {
                                this.xswap();
                            }
                            operator = operator2;
                            this.dStack.push(operator, this.nextToken().getReducedValue(this.ctx, this.ctx, this.variableFactory));
                            y = 1;
                            continue;
                        }
                        if (tk != null && operator2 != -1 && operator2 != 37) {
                            if (Operator.PTABLE[operator2] == Operator.PTABLE[operator]) {
                                if (x) {
                                    this.xswap();
                                }
                                while (!this.dStack.isEmpty()) {
                                    this.dreduce();
                                }
                                operator = operator2;
                                this.dStack.push(operator, this.nextToken().getReducedValue(this.ctx, this.ctx, this.variableFactory));
                                ++y;
                                continue;
                            }
                            if (!this.dStack.isEmpty()) {
                                do {
                                    if (y == 1) {
                                        this.dreduce2();
                                        y = 0;
                                        continue;
                                    }
                                    this.dreduce();
                                } while (this.dStack.size() > 1);
                            }
                            if (!this.dStack.isEmpty()) {
                                this.stk.push(this.dStack.pop());
                                this.xswap();
                            }
                            operator = tk.getOperator();
                            while (this.stk.size() != 1 && this.stk.peek2() instanceof Integer && (operator2 = ((Integer)this.stk.peek2()).intValue()) < Operator.PTABLE.length && Operator.PTABLE[operator2] >= Operator.PTABLE[operator]) {
                                this.xswap();
                                this.reduce();
                            }
                        } else {
                            x = false;
                            if (this.dStack.size() > 1) {
                                do {
                                    if (y == 1) {
                                        this.dreduce2();
                                        y = 0;
                                        continue;
                                    }
                                    this.dreduce();
                                } while (this.dStack.size() > 1);
                                x = true;
                            }
                            if (!this.dStack.isEmpty()) {
                                this.stk.push(this.dStack.pop());
                            } else if (x) {
                                this.xswap();
                            }
                            y = 0;
                            break block30;
                        }
                        y = 0;
                        if (tk != null && (tk = this.nextToken()) != null) {
                            switch (operator) {
                                case 21: {
                                    if (!((Boolean)this.stk.peek()).booleanValue()) {
                                        return -1;
                                    }
                                    this.splitAccumulator.add(tk);
                                    return 21;
                                }
                                case 22: {
                                    if (((Boolean)this.stk.peek()).booleanValue()) {
                                        return -1;
                                    }
                                    this.splitAccumulator.add(tk);
                                    return 22;
                                }
                            }
                            this.stk.push(tk.getReducedValue(this.ctx, this.ctx, this.variableFactory), operator);
                        }
                        x = true;
                        y = 0;
                    }
                }
                if (!tk.isOperator()) {
                    throw new CompileException("unexpected token: " + tk.getName());
                }
                this.reduce();
                this.splitAccumulator.push(tk);
            }
        }
        while (this.stk.isReduceable()) {
            this.reduce();
            if (!this.stk.isReduceable()) continue;
            this.xswap();
        }
        return 0;
    }

    private void dreduce() {
        this.stk.push(this.dStack.pop(), this.dStack.pop());
        this.reduce();
    }

    private void dreduce2() {
        Object o1 = this.dStack.pop();
        Object o2 = this.dStack.pop();
        if (!this.dStack.isEmpty()) {
            this.stk.push(this.dStack.pop());
        }
        this.stk.push(o1);
        this.stk.push(o2);
        this.reduce();
    }

    private void xswap() {
        this.stk.push(this.stk.pop(), this.stk.pop());
    }

    protected void reduce() {
        try {
            int operator = (Integer)this.stk.pop();
            switch (operator) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    this.stk.push(MathProcessor.doOperations(this.stk.peek2(), operator, this.stk.pop2()));
                    break;
                }
                case 21: {
                    Object v1 = this.stk.pop();
                    this.stk.push((Boolean)this.stk.pop() != false && (Boolean)v1 != false);
                    break;
                }
                case 22: {
                    Object v1 = this.stk.pop();
                    this.stk.push((Boolean)this.stk.pop() != false || (Boolean)v1 != false);
                    break;
                }
                case 23: {
                    Object v1 = this.stk.pop();
                    Object v2 = this.stk.pop();
                    if (!PropertyTools.isEmpty(v2) || !PropertyTools.isEmpty(v1)) {
                        this.stk.clear();
                        this.stk.push(!PropertyTools.isEmpty(v2) ? v2 : v1);
                        return;
                    }
                    this.stk.push(null);
                    break;
                }
                case 24: {
                    this.stk.push(Pattern.compile(String.valueOf(this.stk.pop())).matcher(String.valueOf(this.stk.pop())).matches());
                    break;
                }
                case 25: {
                    this.stk.push(((Class)this.stk.pop()).isInstance(this.stk.pop()));
                    break;
                }
                case 36: {
                    this.stk.push(DataConversion.canConvert(this.stk.peek2().getClass(), (Class)this.stk.pop2()));
                    break;
                }
                case 26: {
                    this.stk.push(ParseTools.containsCheck(this.stk.peek2(), this.stk.pop2()));
                    break;
                }
                case 6: {
                    this.stk.push(AbstractParser.asInt(this.stk.peek2()) & AbstractParser.asInt(this.stk.pop2()));
                    break;
                }
                case 7: {
                    this.stk.push(AbstractParser.asInt(this.stk.peek2()) | AbstractParser.asInt(this.stk.pop2()));
                    break;
                }
                case 8: {
                    this.stk.push(AbstractParser.asInt(this.stk.peek2()) ^ AbstractParser.asInt(this.stk.pop2()));
                    break;
                }
                case 10: {
                    this.stk.push(AbstractParser.asInt(this.stk.peek2()) << AbstractParser.asInt(this.stk.pop2()));
                    break;
                }
                case 12: {
                    int iv2 = AbstractParser.asInt(this.stk.peek2());
                    if (iv2 < 0) {
                        iv2 *= -1;
                    }
                    this.stk.push(iv2 << AbstractParser.asInt(this.stk.pop2()));
                    break;
                }
                case 9: {
                    this.stk.push(AbstractParser.asInt(this.stk.peek2()) >> AbstractParser.asInt(this.stk.pop2()));
                    break;
                }
                case 11: {
                    this.stk.push(AbstractParser.asInt(this.stk.peek2()) >>> AbstractParser.asInt(this.stk.pop2()));
                    break;
                }
                case 27: {
                    this.stk.push(Soundex.soundex(String.valueOf(this.stk.pop())).equals(Soundex.soundex(String.valueOf(this.stk.pop()))));
                    break;
                }
                case 28: {
                    this.stk.push(Float.valueOf(ParseTools.similarity(String.valueOf(this.stk.pop()), String.valueOf(this.stk.pop()))));
                }
            }
        }
        catch (ClassCastException e) {
            throw new CompileException("syntax error or incompatable types", this.expr, this.cursor, e);
        }
        catch (ArithmeticException e) {
            throw new CompileException("arithmetic error: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new CompileException("failed to subEval expression", e);
        }
    }

    private static int _bwOpLookup(char c) {
        switch (c) {
            case '|': {
                return 7;
            }
            case '&': {
                return 6;
            }
            case '^': {
                return 8;
            }
            case '*': {
                return 2;
            }
            case '/': {
                return 3;
            }
            case '+': {
                return 0;
            }
            case '%': {
                return 4;
            }
            case '\u00ab': {
                return 10;
            }
            case '\u00bb': {
                return 9;
            }
            case '\u00ac': {
                return 11;
            }
        }
        return -1;
    }

    private static int asInt(Object o) {
        return (Integer)o;
    }

    static {
        LITERALS.put("true", Boolean.TRUE);
        LITERALS.put("false", Boolean.FALSE);
        LITERALS.put("null", null);
        LITERALS.put("nil", null);
        LITERALS.put("empty", BlankLiteral.INSTANCE);
        LITERALS.put("System", System.class);
        LITERALS.put("String", String.class);
        LITERALS.put("CharSequence", CharSequence.class);
        LITERALS.put("Integer", Integer.class);
        LITERALS.put("int", Integer.class);
        LITERALS.put("Long", Long.class);
        LITERALS.put("long", Long.class);
        LITERALS.put("Boolean", Boolean.class);
        LITERALS.put("boolean", Boolean.class);
        LITERALS.put("Short", Short.class);
        LITERALS.put("short", Short.class);
        LITERALS.put("Character", Character.class);
        LITERALS.put("char", Character.class);
        LITERALS.put("Double", Double.class);
        LITERALS.put("double", Double.class);
        LITERALS.put("Float", Float.class);
        LITERALS.put("float", Float.class);
        LITERALS.put("Math", Math.class);
        LITERALS.put("Void", Void.class);
        LITERALS.put("Object", Object.class);
        LITERALS.put("Class", Class.class);
        LITERALS.put("ClassLoader", ClassLoader.class);
        LITERALS.put("Runtime", Runtime.class);
        LITERALS.put("Thread", Thread.class);
        LITERALS.put("Compiler", Compiler.class);
        LITERALS.put("StringBuffer", StringBuffer.class);
        LITERALS.put("ThreadLocal", ThreadLocal.class);
        LITERALS.put("SecurityManager", SecurityManager.class);
        LITERALS.put("StrictMath", StrictMath.class);
        LITERALS.put("Array", Array.class);
        if (Double.parseDouble(System.getProperty("java.version").substring(0, 3)) >= 1.5) {
            try {
                LITERALS.put("StringBuilder", Thread.currentThread().getContextClassLoader().loadClass("java.lang.StringBuilder"));
            }
            catch (Exception e) {
                throw new RuntimeException("cannot resolve a built-in literal", e);
            }
        }
        AbstractParser.setLanguageLevel(5);
    }
}

