package org.mvel2;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ClassAugmentations {
    private static ClassAugmentations INSTANCE = new ClassAugmentations();

    protected Map<Class<?>, Map<String, Set<Method>>> classAugmentations;

    private ClassAugmentations() {
    }

    public static ClassAugmentations get() {
        return INSTANCE;
    }

    public void addClassAugmentation(Class<?> clazz, String name, Method method) {
        if (this.classAugmentations == null) this.classAugmentations = new LinkedHashMap<Class<?>, Map<String, Set<Method>>>();
        if (!this.classAugmentations.containsKey(clazz)) {
            this.classAugmentations.put(clazz, new LinkedHashMap<String, Set<Method>>());
        }
        if (!this.classAugmentations.get(clazz).containsKey(name)) {
            this.classAugmentations.get(clazz).put(name, new HashSet<Method>());
        }

        this.classAugmentations.get(clazz).get(name).add(method);
    }

    public Set<Method> getClassAugmentations(Class<?> clazz, String name) {
        if( this.classAugmentations == null ) {
            return null;
        } else if( !this.classAugmentations.containsKey(clazz) ) {
            return null;
        } else {
            return this.classAugmentations.get(clazz).get(name);
        }
    }
}
