/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.core;

import java.io.Serializable;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.integration.PropertyHandler;
import org.mvel2.integration.PropertyHandlerFactory;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.tests.core.AbstractTest;
import org.mvel2.util.SharedVariableSpaceModel;
import org.mvel2.util.VariableSpaceCompiler;

public class IntegrationTests
extends AbstractTest {
    protected void setUp() throws Exception {
        super.setUp();
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
        OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.SAFE_REFLECTIVE);
        PropertyHandlerFactory.registerPropertyHandler(MyClass.class, (PropertyHandler)new NullPropertyHandler());
        PropertyHandlerFactory.registerPropertyHandler(MyInterface.class, (PropertyHandler)new NullPropertyHandler());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = false;
        PropertyHandlerFactory.unregisterPropertyHandler(MyClass.class);
        PropertyHandlerFactory.unregisterPropertyHandler(MyInterface.class);
    }

    public void test1() {
        IntegrationTests.assertEquals(null, (Object)MVEL.eval((String)"whatever", (Object)new MySubClass()));
    }

    public void test2() {
        IntegrationTests.assertEquals(null, (Object)MVEL.eval((String)"whatever", (Object)new MyInterfacedSubClass()));
    }

    public void testIndexedVariableFactory() {
        ParserContext ctx = ParserContext.create();
        String[] vars = new String[]{"a", "b"};
        Object[] vals = new Object[]{"foo", "bar"};
        ctx.setIndexAllocation(true);
        ctx.addIndexedInput(vars);
        String expr = "def myfunc(z) { a + b + z }; myfunc('poop');";
        SharedVariableSpaceModel model = VariableSpaceCompiler.compileShared((String)expr, (ParserContext)ctx, (Object[])vals);
        Serializable s = MVEL.compileExpression((String)expr, (ParserContext)ctx);
        IntegrationTests.assertEquals((Object)"foobarpoop", (Object)MVEL.executeExpression((Object)s, (VariableResolverFactory)model.createFactory()));
    }

    class MyInterfacedSubClass
    extends MyInterfacedClass {
        MyInterfacedSubClass() {
        }
    }

    class MyInterfacedClass
    implements MyInterface {
        MyInterfacedClass() {
        }
    }

    static interface MyInterface {
    }

    class MySubClass
    extends MyClass {
        MySubClass() {
        }
    }

    class MyClass {
        MyClass() {
        }

        public String getWhatever() {
            return "foo";
        }
    }

    class NullPropertyHandler
    implements PropertyHandler {
        NullPropertyHandler() {
        }

        public Object getProperty(String name, Object contextObj, VariableResolverFactory variableFactory) {
            return null;
        }

        public Object setProperty(String name, Object contextObj, VariableResolverFactory variableFactory, Object value) {
            return null;
        }
    }
}

