/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.optimizers.impl.refl;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.mvel2.CompileException;
import org.mvel2.DataConversion;
import org.mvel2.MVEL;
import org.mvel2.OptimizationFailure;
import org.mvel2.ParserContext;
import org.mvel2.PropertyAccessException;
import org.mvel2.ast.Function;
import org.mvel2.ast.TypeDescriptor;
import org.mvel2.compiler.Accessor;
import org.mvel2.compiler.AccessorNode;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.compiler.PropertyVerifier;
import org.mvel2.integration.GlobalListenerFactory;
import org.mvel2.integration.PropertyHandler;
import org.mvel2.integration.PropertyHandlerFactory;
import org.mvel2.integration.VariableResolver;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.AbstractOptimizer;
import org.mvel2.optimizers.AccessorOptimizer;
import org.mvel2.optimizers.impl.refl.collection.ArrayCreator;
import org.mvel2.optimizers.impl.refl.collection.ExprValueAccessor;
import org.mvel2.optimizers.impl.refl.collection.ListCreator;
import org.mvel2.optimizers.impl.refl.collection.MapCreator;
import org.mvel2.optimizers.impl.refl.nodes.ArrayAccessor;
import org.mvel2.optimizers.impl.refl.nodes.ArrayAccessorNest;
import org.mvel2.optimizers.impl.refl.nodes.ArrayLength;
import org.mvel2.optimizers.impl.refl.nodes.ConstructorAccessor;
import org.mvel2.optimizers.impl.refl.nodes.DynamicFieldAccessor;
import org.mvel2.optimizers.impl.refl.nodes.DynamicFunctionAccessor;
import org.mvel2.optimizers.impl.refl.nodes.FieldAccessor;
import org.mvel2.optimizers.impl.refl.nodes.FieldAccessorNH;
import org.mvel2.optimizers.impl.refl.nodes.FunctionAccessor;
import org.mvel2.optimizers.impl.refl.nodes.GetterAccessor;
import org.mvel2.optimizers.impl.refl.nodes.GetterAccessorNH;
import org.mvel2.optimizers.impl.refl.nodes.IndexedCharSeqAccessor;
import org.mvel2.optimizers.impl.refl.nodes.IndexedCharSeqAccessorNest;
import org.mvel2.optimizers.impl.refl.nodes.IndexedVariableAccessor;
import org.mvel2.optimizers.impl.refl.nodes.ListAccessor;
import org.mvel2.optimizers.impl.refl.nodes.ListAccessorNest;
import org.mvel2.optimizers.impl.refl.nodes.MapAccessor;
import org.mvel2.optimizers.impl.refl.nodes.MapAccessorNest;
import org.mvel2.optimizers.impl.refl.nodes.MethodAccessor;
import org.mvel2.optimizers.impl.refl.nodes.MethodAccessorNH;
import org.mvel2.optimizers.impl.refl.nodes.Notify;
import org.mvel2.optimizers.impl.refl.nodes.NullSafe;
import org.mvel2.optimizers.impl.refl.nodes.PropertyHandlerAccessor;
import org.mvel2.optimizers.impl.refl.nodes.SetterAccessor;
import org.mvel2.optimizers.impl.refl.nodes.StaticReferenceAccessor;
import org.mvel2.optimizers.impl.refl.nodes.StaticVarAccessor;
import org.mvel2.optimizers.impl.refl.nodes.StaticVarAccessorNH;
import org.mvel2.optimizers.impl.refl.nodes.ThisValueAccessor;
import org.mvel2.optimizers.impl.refl.nodes.Union;
import org.mvel2.optimizers.impl.refl.nodes.VariableAccessor;
import org.mvel2.optimizers.impl.refl.nodes.WithAccessor;
import org.mvel2.util.ArrayTools;
import org.mvel2.util.CompilerTools;
import org.mvel2.util.ErrorUtil;
import org.mvel2.util.MethodStub;
import org.mvel2.util.ParseTools;
import org.mvel2.util.PropertyTools;
import org.mvel2.util.StringAppender;

public class ReflectiveAccessorOptimizer
extends AbstractOptimizer
implements AccessorOptimizer {
    private AccessorNode rootNode;
    private AccessorNode currNode;
    private Object ctx;
    private Object thisRef;
    private Object val;
    private VariableResolverFactory variableFactory;
    private static final int DONE = -1;
    private static final Object[] EMPTYARG = new Object[0];
    private static final Class[] EMPTYCLS = new Class[0];
    private boolean first = true;
    private boolean literal = false;
    private static final Map<Integer, Accessor> REFLECTIVE_ACCESSOR_CACHE = new WeakHashMap<Integer, Accessor>();
    private Class ingressType;
    private Class returnType;

    public ReflectiveAccessorOptimizer() {
    }

    public void init() {
    }

    private ReflectiveAccessorOptimizer(ParserContext pCtx, char[] property, int start, int offset, Object ctx, Object thisRef, VariableResolverFactory variableFactory) {
        this.pCtx = pCtx;
        this.expr = property;
        this.start = start;
        this.length = property != null ? offset : start;
        this.end = start + this.length;
        this.ctx = ctx;
        this.variableFactory = variableFactory;
        this.thisRef = thisRef;
    }

    private static int createSignatureHash(String expr, Object ctx) {
        if (ctx == null) {
            return expr.hashCode();
        }
        return expr.hashCode() + ctx.getClass().hashCode();
    }

    public static Object get(String expression, Object ctx) {
        int hash = ReflectiveAccessorOptimizer.createSignatureHash(expression, ctx);
        Accessor accessor = REFLECTIVE_ACCESSOR_CACHE.get(hash);
        if (accessor != null) {
            return accessor.getValue(ctx, null, null);
        }
        accessor = new ReflectiveAccessorOptimizer().optimizeAccessor(ReflectiveAccessorOptimizer.getCurrentThreadParserContext(), expression.toCharArray(), 0, expression.length(), ctx, null, null, false, null);
        REFLECTIVE_ACCESSOR_CACHE.put(hash, accessor);
        return accessor.getValue(ctx, null, null);
    }

    public Accessor optimizeAccessor(ParserContext pCtx, char[] property, int start, int offset, Object ctx, Object thisRef, VariableResolverFactory factory, boolean root, Class ingressType) {
        this.currNode = null;
        this.rootNode = null;
        this.expr = property;
        this.start = start;
        this.end = start + offset;
        this.length = this.end - start;
        this.first = true;
        this.ctx = ctx;
        this.thisRef = thisRef;
        this.variableFactory = factory;
        this.ingressType = ingressType;
        this.pCtx = pCtx;
        return this.compileGetChain();
    }

    public Accessor optimizeSetAccessor(ParserContext pCtx, char[] property, int start, int offset, Object ctx, Object thisRef, VariableResolverFactory factory, boolean rootThisRef, Object value, Class ingressType) {
        block35: {
            this.currNode = null;
            this.rootNode = null;
            this.expr = property;
            this.start = start;
            this.first = true;
            this.length = start + offset;
            this.ctx = ctx;
            this.thisRef = thisRef;
            this.variableFactory = factory;
            this.ingressType = ingressType;
            char[] root = null;
            int split = this.findLastUnion();
            this.pCtx = pCtx;
            PropertyVerifier verifier = new PropertyVerifier(property, this.pCtx);
            if (split != -1) {
                root = ParseTools.subset(property, 0, split++);
                property = ParseTools.subset(property, split, property.length - split);
            }
            if (root != null) {
                this.expr = root;
                this.length = this.end = root.length;
                this.compileGetChain();
                ctx = this.val;
            }
            if (ctx == null) {
                throw new PropertyAccessException("could not access property: " + new String(property, this.start, this.length) + "; parent is null: " + new String(this.expr), this.expr, this.start);
            }
            try {
                Member member;
                this.expr = property;
                this.length = this.end = property.length;
                int st = 0;
                this.cursor = 0;
                this.skipWhitespace();
                if (this.collection) {
                    st = this.cursor;
                    if (this.cursor == this.end) {
                        throw new PropertyAccessException("unterminated '['", this.expr, this.start);
                    }
                    if (this.scanTo(']')) {
                        throw new PropertyAccessException("unterminated '['", this.expr, this.start);
                    }
                    String ex = new String(property, st, this.cursor - st);
                    if (ctx instanceof Map) {
                        if (MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING && PropertyHandlerFactory.hasPropertyHandler(Map.class)) {
                            this.propHandlerSet(ex, ctx, Map.class, value);
                        } else {
                            this.returnType = verifier.analyze();
                            ((Map)ctx).put(MVEL.eval(ex, ctx, this.variableFactory), DataConversion.convert(value, this.returnType));
                            this.addAccessorNode(new MapAccessorNest(ex, this.returnType));
                        }
                        return this.rootNode;
                    }
                    if (ctx instanceof List) {
                        if (MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING && PropertyHandlerFactory.hasPropertyHandler(List.class)) {
                            this.propHandlerSet(ex, ctx, List.class, value);
                        } else {
                            this.returnType = verifier.analyze();
                            ((List)ctx).set(MVEL.eval(ex, ctx, this.variableFactory, Integer.class), DataConversion.convert(value, this.returnType));
                            this.addAccessorNode(new ListAccessorNest(ex, this.returnType));
                        }
                        return this.rootNode;
                    }
                    if (MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING && PropertyHandlerFactory.hasPropertyHandler(ctx.getClass())) {
                        this.propHandlerSet(ex, ctx, ctx.getClass(), value);
                        return this.rootNode;
                    }
                    if (ctx.getClass().isArray()) {
                        if (MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING && PropertyHandlerFactory.hasPropertyHandler(Array.class)) {
                            this.propHandlerSet(ex, ctx, Array.class, value);
                        } else {
                            Array.set(ctx, MVEL.eval(ex, ctx, this.variableFactory, Integer.class), DataConversion.convert(value, ParseTools.getBaseComponentType(ctx.getClass())));
                            this.addAccessorNode(new ArrayAccessorNest(ex));
                        }
                        return this.rootNode;
                    }
                    throw new PropertyAccessException("cannot bind to collection property: " + new String(property) + ": not a recognized collection type: " + ctx.getClass(), this.expr, this.st);
                }
                if (MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING && PropertyHandlerFactory.hasPropertyHandler(ctx.getClass())) {
                    this.propHandlerSet(new String(property), ctx, ctx.getClass(), value);
                    return this.rootNode;
                }
                String tk = new String(property, 0, this.length);
                if (GlobalListenerFactory.hasSetListeners()) {
                    GlobalListenerFactory.notifySetListeners(ctx, tk, this.variableFactory, value);
                    this.addAccessorNode(new Notify(tk));
                }
                if ((member = PropertyTools.getFieldOrWriteAccessor(ctx.getClass(), tk, value == null ? null : ingressType)) instanceof Field) {
                    Field fld = (Field)member;
                    if (value != null && !fld.getType().isAssignableFrom(value.getClass())) {
                        if (!DataConversion.canConvert(fld.getType(), value.getClass())) {
                            throw new CompileException("cannot convert type: " + value.getClass() + ": to " + fld.getType(), this.expr, this.start);
                        }
                        fld.set(ctx, DataConversion.convert(value, fld.getType()));
                        this.addAccessorNode(new DynamicFieldAccessor(fld));
                    } else if (value == null && fld.getType().isPrimitive()) {
                        fld.set(ctx, PropertyTools.getPrimitiveInitialValue(fld.getType()));
                        this.addAccessorNode(new FieldAccessor(fld));
                    } else {
                        fld.set(ctx, value);
                        this.addAccessorNode(new FieldAccessor(fld));
                    }
                    break block35;
                }
                if (member != null) {
                    Method meth = (Method)member;
                    if (value != null && !meth.getParameterTypes()[0].isAssignableFrom(value.getClass())) {
                        if (!DataConversion.canConvert(meth.getParameterTypes()[0], value.getClass())) {
                            throw new CompileException("cannot convert type: " + value.getClass() + ": to " + meth.getParameterTypes()[0], this.expr, this.start);
                        }
                        meth.invoke(ctx, DataConversion.convert(value, meth.getParameterTypes()[0]));
                    } else if (value == null && meth.getParameterTypes()[0].isPrimitive()) {
                        meth.invoke(ctx, PropertyTools.getPrimitiveInitialValue(meth.getParameterTypes()[0]));
                    } else {
                        meth.invoke(ctx, value);
                    }
                    this.addAccessorNode(new SetterAccessor(meth));
                    break block35;
                }
                if (ctx instanceof Map) {
                    ((Map)ctx).put(tk, value);
                    this.addAccessorNode(new MapAccessor(tk));
                    break block35;
                }
                throw new PropertyAccessException("could not access property (" + tk + ") in: " + ingressType.getName(), this.expr, this.start);
            }
            catch (InvocationTargetException e) {
                throw new PropertyAccessException("could not access property: " + new String(property), this.expr, this.st, e);
            }
            catch (IllegalAccessException e) {
                throw new PropertyAccessException("could not access property: " + new String(property), this.expr, this.st, e);
            }
            catch (IllegalArgumentException e) {
                throw new PropertyAccessException("error binding property: " + new String(property) + " (value <<" + value + ">>::" + (value == null ? "null" : value.getClass().getCanonicalName()) + ")", this.expr, this.st, e);
            }
        }
        return this.rootNode;
    }

    private Accessor compileGetChain() {
        Object curr = this.ctx;
        this.cursor = this.start;
        try {
            if (!MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING) {
                while (this.cursor < this.end) {
                    switch (this.nextSubToken()) {
                        case 0: {
                            curr = this.getBeanProperty(curr, this.capture());
                            break;
                        }
                        case 1: {
                            curr = this.getMethod(curr, this.capture());
                            break;
                        }
                        case 2: {
                            curr = this.getCollectionProperty(curr, this.capture());
                            break;
                        }
                        case 3: {
                            curr = this.getWithProperty(curr);
                            break;
                        }
                    }
                    this.first = false;
                    if (curr != null) {
                        this.returnType = curr.getClass();
                    }
                    if (this.nullSafe && this.cursor < this.length) {
                        int os = this.expr[this.cursor] == '.' ? 1 : 0;
                        this.addAccessorNode(new NullSafe(this.expr, this.cursor + os, this.length - this.cursor - os, this.pCtx));
                        if (curr == null) break;
                    }
                    this.staticAccess = false;
                }
            } else {
                while (this.cursor < this.end) {
                    switch (this.nextSubToken()) {
                        case 0: {
                            curr = this.getBeanPropertyAO(curr, this.capture());
                            break;
                        }
                        case 1: {
                            curr = this.getMethod(curr, this.capture());
                            break;
                        }
                        case 2: {
                            curr = this.getCollectionPropertyAO(curr, this.capture());
                            break;
                        }
                        case 3: {
                            curr = this.getWithProperty(curr);
                            break;
                        }
                    }
                    this.first = false;
                    if (curr != null) {
                        this.returnType = curr.getClass();
                    }
                    if (this.nullSafe && this.cursor < this.length) {
                        int os = this.expr[this.cursor] == '.' ? 1 : 0;
                        this.addAccessorNode(new NullSafe(this.expr, this.cursor + os, this.length - this.cursor - os, this.pCtx));
                        if (curr == null) break;
                    }
                    this.staticAccess = false;
                }
            }
            this.val = curr;
            if (this.pCtx.isStrictTypeEnforcement()) {
                this.returnType = new PropertyVerifier(this.expr, this.start, this.length, this.pCtx).analyze();
            }
            return this.rootNode;
        }
        catch (InvocationTargetException e) {
            if (MVEL.INVOKED_METHOD_EXCEPTIONS_BUBBLE) {
                if (e.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)e.getTargetException();
                }
                throw new RuntimeException(e);
            }
            throw new PropertyAccessException(new String(this.expr, this.start, this.length) + ": " + e.getTargetException().getMessage(), this.expr, this.st, e);
        }
        catch (IllegalAccessException e) {
            throw new PropertyAccessException(new String(this.expr, this.start, this.length) + ": " + e.getMessage(), this.expr, this.st, e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new PropertyAccessException(new String(this.expr, this.start, this.length) + ": array index out of bounds.", this.expr, this.st, e);
        }
        catch (CompileException e) {
            throw e;
        }
        catch (NullPointerException e) {
            throw new PropertyAccessException("null pointer: " + new String(this.expr, this.start, this.length), this.expr, this.st, e);
        }
        catch (Exception e) {
            throw new CompileException(e.getMessage(), this.expr, this.st, e);
        }
    }

    private void addAccessorNode(AccessorNode an) {
        if (this.rootNode == null) {
            this.rootNode = this.currNode = an;
        } else {
            this.currNode = this.currNode.setNextNode(an);
        }
    }

    private Object getWithProperty(Object ctx) {
        String root = this.start == this.cursor ? null : new String(this.expr, this.start, this.cursor - 1).trim();
        int st = this.cursor + 1;
        this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, this.cursor, this.end, '{', this.pCtx);
        WithAccessor wa = new WithAccessor(root, this.expr, st, this.cursor++ - st, this.ingressType, false);
        this.addAccessorNode(wa);
        return wa.getValue(ctx, this.thisRef, this.variableFactory);
    }

    private Object getBeanPropertyAO(Object ctx, String property) throws Exception {
        if (GlobalListenerFactory.hasGetListeners()) {
            GlobalListenerFactory.notifyGetListeners(ctx, property, this.variableFactory);
            this.addAccessorNode(new Notify(property));
        }
        if (ctx != null && PropertyHandlerFactory.hasPropertyHandler(ctx.getClass())) {
            return this.propHandler(property, ctx, ctx.getClass());
        }
        return this.getBeanProperty(ctx, property);
    }

    private Object getBeanProperty(Object ctx, String property) throws Exception {
        Member member;
        Class<?> cls;
        if ((this.pCtx == null ? this.currType : this.pCtx.getVarOrInputTypeOrNull(property)) == Object.class && !this.pCtx.isStrongTyping()) {
            this.currType = null;
        }
        if (this.first) {
            if ("this".equals(property)) {
                this.addAccessorNode(new ThisValueAccessor());
                return this.thisRef;
            }
            if (this.variableFactory != null && this.variableFactory.isResolveable(property)) {
                if (this.variableFactory.isIndexedFactory() && this.variableFactory.isTarget(property)) {
                    int idx = this.variableFactory.variableIndexOf(property);
                    this.addAccessorNode(new IndexedVariableAccessor(idx));
                    VariableResolver vr = this.variableFactory.getIndexedVariableResolver(idx);
                    if (vr == null) {
                        this.variableFactory.setIndexedVariableResolver(idx, this.variableFactory.getVariableResolver(property));
                    }
                    return this.variableFactory.getIndexedVariableResolver(idx).getValue();
                }
                this.addAccessorNode(new VariableAccessor(property));
                return this.variableFactory.getVariableResolver(property).getValue();
            }
        }
        boolean classRef = false;
        if (ctx instanceof Class) {
            if (MVEL.COMPILER_OPT_SUPPORT_JAVA_STYLE_CLASS_LITERALS && "class".equals(property)) {
                return ctx;
            }
            cls = (Class<?>)ctx;
            classRef = true;
        } else {
            cls = ctx != null ? ctx.getClass() : null;
        }
        if (PropertyHandlerFactory.hasPropertyHandler(cls)) {
            PropertyHandlerAccessor acc = new PropertyHandlerAccessor(property, cls, PropertyHandlerFactory.getPropertyHandler(cls));
            this.addAccessorNode(acc);
            return acc.getValue(ctx, this.thisRef, this.variableFactory);
        }
        Member member2 = member = cls != null ? PropertyTools.getFieldOrAccessor(cls, property) : null;
        if (member != null && classRef && (member.getModifiers() & 8) == 0) {
            member = null;
        }
        if (member instanceof Method) {
            Object o;
            try {
                o = ((Method)member).invoke(ctx, EMPTYARG);
                if (PropertyHandlerFactory.hasNullPropertyHandler()) {
                    this.addAccessorNode(new GetterAccessorNH((Method)member, PropertyHandlerFactory.getNullPropertyHandler()));
                    if (o == null) {
                        o = PropertyHandlerFactory.getNullPropertyHandler().getProperty(member.getName(), ctx, this.variableFactory);
                    }
                } else {
                    this.addAccessorNode(new GetterAccessor((Method)member));
                }
            }
            catch (IllegalAccessException e) {
                Method iFaceMeth = ParseTools.determineActualTargetMethod((Method)member);
                if (iFaceMeth == null) {
                    throw new PropertyAccessException("could not access field: " + cls.getName() + "." + property, this.expr, this.start);
                }
                o = iFaceMeth.invoke(ctx, EMPTYARG);
                if (PropertyHandlerFactory.hasNullPropertyHandler()) {
                    this.addAccessorNode(new GetterAccessorNH((Method)member, PropertyHandlerFactory.getNullMethodHandler()));
                    if (o == null) {
                        o = PropertyHandlerFactory.getNullMethodHandler().getProperty(member.getName(), ctx, this.variableFactory);
                    }
                } else {
                    this.addAccessorNode(new GetterAccessor(iFaceMeth));
                }
            }
            catch (IllegalArgumentException e) {
                if (member.getDeclaringClass().equals(ctx)) {
                    try {
                        Class<?> c = Class.forName(member.getDeclaringClass().getName() + "$" + property);
                        throw new CompileException("name collision between innerclass: " + c.getCanonicalName() + "; and bean accessor: " + property + " (" + member.toString() + ")", this.expr, this.tkStart);
                    }
                    catch (ClassNotFoundException e2) {
                        // empty catch block
                    }
                }
                throw e;
            }
            return o;
        }
        if (member != null) {
            Object o;
            Field f = (Field)member;
            if ((f.getModifiers() & 8) != 0) {
                o = f.get(null);
                if (PropertyHandlerFactory.hasNullPropertyHandler()) {
                    this.addAccessorNode(new StaticVarAccessorNH((Field)member, PropertyHandlerFactory.getNullMethodHandler()));
                    if (o == null) {
                        o = PropertyHandlerFactory.getNullMethodHandler().getProperty(member.getName(), ctx, this.variableFactory);
                    }
                } else {
                    this.addAccessorNode(new StaticVarAccessor((Field)member));
                }
            } else {
                o = f.get(ctx);
                if (PropertyHandlerFactory.hasNullPropertyHandler()) {
                    this.addAccessorNode(new FieldAccessorNH((Field)member, PropertyHandlerFactory.getNullMethodHandler()));
                    if (o == null) {
                        o = PropertyHandlerFactory.getNullMethodHandler().getProperty(member.getName(), ctx, this.variableFactory);
                    }
                } else {
                    this.addAccessorNode(new FieldAccessor((Field)member));
                }
            }
            return o;
        }
        if (ctx instanceof Map && (((Map)ctx).containsKey(property) || this.nullSafe)) {
            this.addAccessorNode(new MapAccessor(property));
            return ((Map)ctx).get(property);
        }
        if (ctx != null && "length".equals(property) && ctx.getClass().isArray()) {
            this.addAccessorNode(new ArrayLength());
            return Array.getLength(ctx);
        }
        if (LITERALS.containsKey(property)) {
            ctx = LITERALS.get(property);
            this.addAccessorNode(new StaticReferenceAccessor(ctx));
            return ctx;
        }
        Object tryStaticMethodRef = this.tryStaticAccess();
        this.staticAccess = true;
        if (tryStaticMethodRef != null) {
            if (tryStaticMethodRef instanceof Class) {
                this.addAccessorNode(new StaticReferenceAccessor(tryStaticMethodRef));
                return tryStaticMethodRef;
            }
            if (tryStaticMethodRef instanceof Field) {
                this.addAccessorNode(new StaticVarAccessor((Field)tryStaticMethodRef));
                return ((Field)tryStaticMethodRef).get(null);
            }
            this.addAccessorNode(new StaticReferenceAccessor(tryStaticMethodRef));
            return tryStaticMethodRef;
        }
        if (ctx instanceof Class) {
            Class c = (Class)ctx;
            for (Method m : c.getMethods()) {
                if (!property.equals(m.getName())) continue;
                if (MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL) {
                    Object o = m.invoke(null, ParseTools.EMPTY_OBJ_ARR);
                    if (PropertyHandlerFactory.hasNullMethodHandler()) {
                        this.addAccessorNode(new MethodAccessorNH(m, new ExecutableStatement[0], PropertyHandlerFactory.getNullMethodHandler()));
                        if (o == null) {
                            o = PropertyHandlerFactory.getNullMethodHandler().getProperty(m.getName(), ctx, this.variableFactory);
                        }
                    } else {
                        this.addAccessorNode(new MethodAccessor(m, new ExecutableStatement[0], false));
                    }
                    return o;
                }
                this.addAccessorNode(new StaticReferenceAccessor(m));
                return m;
            }
            try {
                Class subClass = ParseTools.findClass(this.variableFactory, c.getName() + "$" + property, this.pCtx);
                this.addAccessorNode(new StaticReferenceAccessor(subClass));
                return subClass;
            }
            catch (ClassNotFoundException cnfe) {}
        } else if (MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL) {
            return this.getMethod(ctx, property);
        }
        if (ctx == null) {
            throw new PropertyAccessException("unresolvable property or identifier: " + property, this.expr, this.start);
        }
        throw new PropertyAccessException("could not access: " + property + "; in class: " + ctx.getClass().getName(), this.expr, this.start);
    }

    private Object getCollectionProperty(Object ctx, String prop) throws Exception {
        if (prop.length() > 0) {
            ctx = this.getBeanProperty(ctx, prop);
        }
        if (ctx == null) {
            return null;
        }
        int start = ++this.cursor;
        this.skipWhitespace();
        if (this.cursor == this.end) {
            throw new CompileException("unterminated '['", this.expr, this.start);
        }
        if (this.scanTo(']')) {
            throw new CompileException("unterminated '['", this.expr, this.start);
        }
        String item = new String(this.expr, start, this.cursor - start);
        boolean itemSubExpr = true;
        Object idx = null;
        try {
            idx = Integer.parseInt(item);
            itemSubExpr = false;
        }
        catch (Exception e) {
            // empty catch block
        }
        ExecutableStatement itemStmt = null;
        if (itemSubExpr) {
            try {
                itemStmt = (ExecutableStatement)ParseTools.subCompileExpression(item.toCharArray(), this.pCtx);
                idx = itemStmt.getValue(ctx, this.thisRef, this.variableFactory);
            }
            catch (CompileException e) {
                e.setExpr(this.expr);
                e.setCursor(start);
                throw e;
            }
        }
        ++this.cursor;
        if (ctx instanceof Map) {
            if (itemSubExpr) {
                this.addAccessorNode(new MapAccessorNest(itemStmt, null));
            } else {
                this.addAccessorNode(new MapAccessor(Integer.parseInt(item)));
            }
            return ((Map)ctx).get(idx);
        }
        if (ctx instanceof List) {
            if (itemSubExpr) {
                this.addAccessorNode(new ListAccessorNest(itemStmt, null));
            } else {
                this.addAccessorNode(new ListAccessor(Integer.parseInt(item)));
            }
            return ((List)ctx).get((Integer)idx);
        }
        if (ctx.getClass().isArray()) {
            if (itemSubExpr) {
                this.addAccessorNode(new ArrayAccessorNest(itemStmt));
            } else {
                this.addAccessorNode(new ArrayAccessor(Integer.parseInt(item)));
            }
            return Array.get(ctx, (Integer)idx);
        }
        if (ctx instanceof CharSequence) {
            if (itemSubExpr) {
                this.addAccessorNode(new IndexedCharSeqAccessorNest(itemStmt));
            } else {
                this.addAccessorNode(new IndexedCharSeqAccessor(Integer.parseInt(item)));
            }
            return Character.valueOf(((CharSequence)ctx).charAt((Integer)idx));
        }
        TypeDescriptor tDescr = new TypeDescriptor(this.expr, this.start, this.length, 0);
        if (tDescr.isArray()) {
            Class cls = TypeDescriptor.getClassReference((Class)ctx, tDescr, this.variableFactory, this.pCtx);
            this.rootNode = new StaticReferenceAccessor(cls);
            return cls;
        }
        throw new CompileException("illegal use of []: unknown type: " + ctx.getClass().getName(), this.expr, this.start);
    }

    private Object getCollectionPropertyAO(Object ctx, String prop) throws Exception {
        if (prop.length() > 0) {
            ctx = this.getBeanPropertyAO(ctx, prop);
        }
        if (ctx == null) {
            return null;
        }
        int _start = ++this.cursor;
        this.skipWhitespace();
        if (this.cursor == this.end) {
            throw new CompileException("unterminated '['", this.expr, this.start);
        }
        if (this.scanTo(']')) {
            throw new CompileException("unterminated '['", this.expr, this.start);
        }
        String item = new String(this.expr, _start, this.cursor - _start);
        boolean itemSubExpr = true;
        Object idx = null;
        try {
            idx = Integer.parseInt(item);
            itemSubExpr = false;
        }
        catch (Exception e) {
            // empty catch block
        }
        ExecutableStatement itemStmt = null;
        if (itemSubExpr) {
            itemStmt = (ExecutableStatement)ParseTools.subCompileExpression(item.toCharArray(), this.pCtx);
            idx = itemStmt.getValue(ctx, this.thisRef, this.variableFactory);
        }
        ++this.cursor;
        if (ctx instanceof Map) {
            if (PropertyHandlerFactory.hasPropertyHandler(Map.class)) {
                return this.propHandler(item, ctx, Map.class);
            }
            if (itemSubExpr) {
                this.addAccessorNode(new MapAccessorNest(itemStmt, null));
            } else {
                this.addAccessorNode(new MapAccessor(Integer.parseInt(item)));
            }
            return ((Map)ctx).get(idx);
        }
        if (ctx instanceof List) {
            if (PropertyHandlerFactory.hasPropertyHandler(List.class)) {
                return this.propHandler(item, ctx, List.class);
            }
            if (itemSubExpr) {
                this.addAccessorNode(new ListAccessorNest(itemStmt, null));
            } else {
                this.addAccessorNode(new ListAccessor(Integer.parseInt(item)));
            }
            return ((List)ctx).get((Integer)idx);
        }
        if (ctx.getClass().isArray()) {
            if (PropertyHandlerFactory.hasPropertyHandler(Array.class)) {
                return this.propHandler(item, ctx, Array.class);
            }
            if (itemSubExpr) {
                this.addAccessorNode(new ArrayAccessorNest(itemStmt));
            } else {
                this.addAccessorNode(new ArrayAccessor(Integer.parseInt(item)));
            }
            return Array.get(ctx, (Integer)idx);
        }
        if (ctx instanceof CharSequence) {
            if (PropertyHandlerFactory.hasPropertyHandler(CharSequence.class)) {
                return this.propHandler(item, ctx, CharSequence.class);
            }
            if (itemSubExpr) {
                this.addAccessorNode(new IndexedCharSeqAccessorNest(itemStmt));
            } else {
                this.addAccessorNode(new IndexedCharSeqAccessor(Integer.parseInt(item)));
            }
            return Character.valueOf(((CharSequence)ctx).charAt((Integer)idx));
        }
        TypeDescriptor tDescr = new TypeDescriptor(this.expr, this.start, this.end - this.start, 0);
        if (tDescr.isArray()) {
            Class cls = TypeDescriptor.getClassReference((Class)ctx, tDescr, this.variableFactory, this.pCtx);
            this.rootNode = new StaticReferenceAccessor(cls);
            return cls;
        }
        throw new CompileException("illegal use of []: unknown type: " + ctx.getClass().getName(), this.expr, this.st);
    }

    private Object getMethod(Object ctx, String name) throws Exception {
        Accessor[] es;
        Class[] argTypes;
        Object[] args;
        int st = this.cursor;
        String tk = this.cursor != this.end && this.expr[this.cursor] == '(' && (this.cursor = ParseTools.balancedCapture(this.expr, this.cursor, '(')) - st > 1 ? new String(this.expr, st + 1, this.cursor - st - 1) : "";
        ++this.cursor;
        if (tk.length() == 0) {
            args = ParseTools.EMPTY_OBJ_ARR;
            argTypes = ParseTools.EMPTY_CLS_ARR;
            es = null;
        } else {
            int i;
            List<char[]> subtokens = ParseTools.parseParameterList(tk.toCharArray(), 0, -1);
            es = new ExecutableStatement[subtokens.size()];
            args = new Object[subtokens.size()];
            argTypes = new Class[subtokens.size()];
            for (i = 0; i < subtokens.size(); ++i) {
                try {
                    es[i] = (ExecutableStatement)ParseTools.subCompileExpression(subtokens.get(i), this.pCtx);
                    args[i] = es[i].getValue(this.thisRef, this.thisRef, this.variableFactory);
                }
                catch (CompileException e) {
                    throw ErrorUtil.rewriteIfNeeded(e, this.expr, this.start);
                }
                if (!es[i].isExplicitCast()) continue;
                argTypes[i] = es[i].getKnownEgressType();
            }
            if (this.pCtx.isStrictTypeEnforcement()) {
                for (i = 0; i < args.length; ++i) {
                    argTypes[i] = es[i].getKnownEgressType();
                }
            } else {
                for (i = 0; i < args.length; ++i) {
                    if (argTypes[i] != null) continue;
                    argTypes[i] = es[i].getKnownEgressType() == Object.class ? (args[i] == null ? null : args[i].getClass()) : es[i].getKnownEgressType();
                }
            }
        }
        if (this.first && this.variableFactory != null && this.variableFactory.isResolveable(name)) {
            Object ptr = this.variableFactory.getVariableResolver(name).getValue();
            if (ptr instanceof Method) {
                ctx = ((Method)ptr).getDeclaringClass();
                name = ((Method)ptr).getName();
            } else if (ptr instanceof MethodStub) {
                ctx = ((MethodStub)ptr).getClassReference();
                name = ((MethodStub)ptr).getMethodName();
            } else {
                if (ptr instanceof Function) {
                    Function func = (Function)ptr;
                    if (!name.equals(func.getName())) {
                        this.getBeanProperty(ctx, name);
                        this.addAccessorNode(new DynamicFunctionAccessor(es));
                    } else {
                        this.addAccessorNode(new FunctionAccessor((Function)ptr, es));
                    }
                    return ((Function)ptr).call(ctx, this.thisRef, this.variableFactory, args);
                }
                throw new OptimizationFailure("attempt to optimize a method call for a reference that does not point to a method: " + name + " (reference is type: " + (ctx != null ? ctx.getClass().getName() : null) + ")");
            }
            this.first = false;
        }
        if (ctx == null) {
            throw new PropertyAccessException("null pointer or function not found: " + name, this.expr, this.start);
        }
        boolean classTarget = false;
        Class<?> cls = this.currType != null ? this.currType : ((classTarget = ctx instanceof Class) ? (Class)ctx : ctx.getClass());
        this.currType = null;
        boolean isAugmented = false;
        Class<?>[] parameterTypes = null;
        Method m = ParseTools.getBestCandidate(argTypes, name, cls, cls.getMethods(), false, classTarget, false);
        if (m != null) {
            parameterTypes = m.getParameterTypes();
        }
        if (m == null) {
            Class[] newArgTypes = new Class[argTypes.length + 1];
            newArgTypes[0] = ctx.getClass();
            for (int i = 0; i < argTypes.length; ++i) {
                newArgTypes[i + 1] = argTypes[i];
            }
            Set<Method> augmentedMethods = this.pCtx.getClassAugmentations(cls, name);
            if (augmentedMethods != null && (m = ParseTools.getBestCandidate(newArgTypes, name, cls, augmentedMethods.toArray(new Method[0]), false, false, true)) != null) {
                Class<?>[] originalParamterTypes = m.getParameterTypes();
                parameterTypes = new Class[originalParamterTypes.length - 1];
                for (int i = 1; i < originalParamterTypes.length; ++i) {
                    parameterTypes[i - 1] = originalParamterTypes[i];
                }
                isAugmented = true;
            }
        }
        if (m == null && classTarget && (m = ParseTools.getBestCandidate(argTypes, name, cls, Class.class.getMethods(), false)) != null) {
            parameterTypes = m.getParameterTypes();
        }
        if (m == null) {
            StringAppender errorBuild = new StringAppender();
            if ("size".equals(name) && args.length == 0 && cls.isArray()) {
                this.addAccessorNode(new ArrayLength());
                return Array.getLength(ctx);
            }
            for (int i = 0; i < args.length; ++i) {
                errorBuild.append(args[i] != null ? args[i].getClass().getName() : null);
                if (i >= args.length - 1) continue;
                errorBuild.append(", ");
            }
            throw new PropertyAccessException("unable to resolve method: " + cls.getName() + "." + name + "(" + errorBuild.toString() + ") [arglength=" + args.length + "]", this.expr, this.st);
        }
        if (es != null) {
            for (int i = 0; i < es.length; ++i) {
                Accessor cExpr = es[i];
                if (cExpr.getKnownIngressType() == null) {
                    cExpr.setKnownIngressType(parameterTypes[i]);
                    cExpr.computeTypeConversionRule();
                }
                if (cExpr.isConvertableIngressEgress()) continue;
                args[i] = DataConversion.convert(args[i], parameterTypes[i]);
            }
        } else {
            for (int i = 0; i < args.length; ++i) {
                args[i] = DataConversion.convert(args[i], parameterTypes[i]);
            }
        }
        Object o = null;
        if (!isAugmented) {
            o = ParseTools.getWidenedTarget(m).invoke((Object)ctx, args);
        } else {
            Object[] newArgs = new Object[args.length + 1];
            newArgs[0] = ctx;
            for (int i = 0; i < args.length; ++i) {
                newArgs[i + 1] = args[i];
            }
            o = ParseTools.getWidenedTarget(m).invoke((Object)ctx, newArgs);
        }
        if (PropertyHandlerFactory.hasNullMethodHandler()) {
            this.addAccessorNode(new MethodAccessorNH(ParseTools.getWidenedTarget(m), (ExecutableStatement[])es, PropertyHandlerFactory.getNullMethodHandler()));
            if (o == null) {
                o = PropertyHandlerFactory.getNullMethodHandler().getProperty(m.getName(), ctx, this.variableFactory);
            }
        } else {
            this.addAccessorNode(new MethodAccessor(ParseTools.getWidenedTarget(m), (ExecutableStatement[])es, isAugmented));
        }
        return o;
    }

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory) throws Exception {
        return this.rootNode.getValue(ctx, elCtx, variableFactory);
    }

    private Accessor _getAccessor(Object o, Class type) {
        if (o instanceof List) {
            Accessor[] a = new Accessor[((List)o).size()];
            int i = 0;
            for (Object item : (List)o) {
                a[i++] = this._getAccessor(item, type);
            }
            this.returnType = List.class;
            return new ListCreator(a);
        }
        if (o instanceof Map) {
            Accessor[] k = new Accessor[((Map)o).size()];
            Accessor[] v = new Accessor[k.length];
            int i = 0;
            for (Object item : ((Map)o).keySet()) {
                k[i] = this._getAccessor(item, type);
                v[i++] = this._getAccessor(((Map)o).get(item), type);
            }
            this.returnType = Map.class;
            return new MapCreator(k, v);
        }
        if (o instanceof Object[]) {
            Accessor[] a = new Accessor[((Object[])o).length];
            int i = 0;
            int dim = 0;
            if (type != null) {
                String nm = type.getName();
                while (nm.charAt(dim) == '[') {
                    ++dim;
                }
            } else {
                type = Object[].class;
                dim = 1;
            }
            try {
                Class base = ParseTools.getBaseComponentType(type);
                Class cls = dim > 1 ? ParseTools.findClass(null, ParseTools.repeatChar('[', dim - 1) + "L" + base.getName() + ";", this.pCtx) : type;
                for (Object item : (Object[])o) {
                    int n = i++;
                    Accessor accessor = this._getAccessor(item, cls);
                    a[n] = accessor;
                    CompilerTools.expectType(accessor, base, true);
                }
                return new ArrayCreator(a, ParseTools.getSubComponentType(type));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("this error should never throw:" + ParseTools.getBaseComponentType(type).getName(), e);
            }
        }
        if (this.returnType == null) {
            this.returnType = Object.class;
        }
        if (type.isArray()) {
            return new ExprValueAccessor((String)o, type, this.ctx, this.variableFactory, this.pCtx);
        }
        return new ExprValueAccessor((String)o, Object.class, this.ctx, this.variableFactory, this.pCtx);
    }

    public Accessor optimizeCollection(ParserContext pCtx, Object o, Class type, char[] property, int start, int offset, Object ctx, Object thisRef, VariableResolverFactory factory) {
        this.start = this.cursor = start;
        this.length = start + offset;
        this.returnType = type;
        this.ctx = ctx;
        this.variableFactory = factory;
        this.pCtx = pCtx;
        Accessor root = this._getAccessor(o, this.returnType);
        if (property != null && this.length > start) {
            return new Union(root, property, this.cursor, offset);
        }
        return root;
    }

    public Accessor optimizeObjectCreation(ParserContext pCtx, char[] property, int start, int offset, Object ctx, Object thisRef, VariableResolverFactory factory) {
        this.length = start + offset;
        this.cursor = this.start = start;
        this.pCtx = pCtx;
        try {
            return this.compileConstructor(property, ctx, factory);
        }
        catch (CompileException e) {
            throw ErrorUtil.rewriteIfNeeded(e, property, this.start);
        }
        catch (ClassNotFoundException e) {
            throw new CompileException("could not resolve class: " + e.getMessage(), property, this.start, e);
        }
        catch (Exception e) {
            throw new CompileException("could not create constructor: " + e.getMessage(), property, this.start, e);
        }
    }

    private void setRootNode(AccessorNode rootNode) {
        this.rootNode = this.currNode = rootNode;
    }

    private AccessorNode getRootNode() {
        return this.rootNode;
    }

    public Object getResultOptPass() {
        return this.val;
    }

    public AccessorNode compileConstructor(char[] expression, Object ctx, VariableResolverFactory vars) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException {
        String[] cnsRes = ParseTools.captureContructorAndResidual(expression, this.start, this.length);
        List<char[]> constructorParms = ParseTools.parseMethodOrConstructor(cnsRes[0].toCharArray());
        if (constructorParms != null) {
            String s = new String(ParseTools.subset(expression, 0, ArrayTools.findFirst('(', this.start, this.length, expression)));
            Class cls = ParseTools.findClass(vars, s, this.pCtx);
            ExecutableStatement[] cStmts = new ExecutableStatement[constructorParms.size()];
            for (int i = 0; i < constructorParms.size(); ++i) {
                cStmts[i] = (ExecutableStatement)ParseTools.subCompileExpression(constructorParms.get(i), this.pCtx);
            }
            Object[] parms = new Object[constructorParms.size()];
            for (int i = 0; i < constructorParms.size(); ++i) {
                parms[i] = cStmts[i].getValue(ctx, vars);
            }
            Constructor cns = ParseTools.getBestConstructorCandidate(parms, cls, this.pCtx.isStrongTyping());
            if (cns == null) {
                StringBuilder error = new StringBuilder();
                for (int i = 0; i < parms.length; ++i) {
                    error.append(parms[i].getClass().getName());
                    if (i + 1 >= parms.length) continue;
                    error.append(", ");
                }
                throw new CompileException("unable to find constructor: " + cls.getName() + "(" + error.toString() + ")", this.expr, this.start);
            }
            for (int i = 0; i < parms.length; ++i) {
                parms[i] = DataConversion.convert(parms[i], cns.getParameterTypes()[i]);
            }
            AccessorNode ca = new ConstructorAccessor(cns, cStmts);
            if (cnsRes.length > 1) {
                ReflectiveAccessorOptimizer compiledOptimizer = new ReflectiveAccessorOptimizer(this.pCtx, cnsRes[1].toCharArray(), 0, cnsRes[1].length(), cns.newInstance(parms), ctx, vars);
                compiledOptimizer.ingressType = cns.getDeclaringClass();
                compiledOptimizer.setRootNode(ca);
                compiledOptimizer.compileGetChain();
                ca = compiledOptimizer.getRootNode();
                this.val = compiledOptimizer.getResultOptPass();
            }
            return ca;
        }
        Constructor<?> cns = Class.forName(new String(expression), true, Thread.currentThread().getContextClassLoader()).getConstructor(EMPTYCLS);
        AccessorNode ca = new ConstructorAccessor(cns, null);
        if (cnsRes.length > 1) {
            ReflectiveAccessorOptimizer compiledOptimizer = new ReflectiveAccessorOptimizer(ReflectiveAccessorOptimizer.getCurrentThreadParserContext(), cnsRes[1].toCharArray(), 0, cnsRes[1].length(), cns.newInstance(null), ctx, vars);
            compiledOptimizer.setRootNode(ca);
            compiledOptimizer.compileGetChain();
            ca = compiledOptimizer.getRootNode();
            this.val = compiledOptimizer.getResultOptPass();
        }
        return ca;
    }

    public Class getEgressType() {
        return this.returnType;
    }

    public boolean isLiteralOnly() {
        return this.literal;
    }

    private Object propHandler(String property, Object ctx, Class handler) {
        PropertyHandler ph = PropertyHandlerFactory.getPropertyHandler(handler);
        this.addAccessorNode(new PropertyHandlerAccessor(property, handler, ph));
        return ph.getProperty(property, ctx, this.variableFactory);
    }

    public void propHandlerSet(String property, Object ctx, Class handler, Object value) {
        PropertyHandler ph = PropertyHandlerFactory.getPropertyHandler(handler);
        this.addAccessorNode(new PropertyHandlerAccessor(property, handler, ph));
        ph.setProperty(property, ctx, this.variableFactory, value);
    }
}

