/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.optimizers.impl.refl.nodes;

import java.lang.reflect.Method;
import org.mvel2.DataConversion;
import org.mvel2.compiler.AccessorNode;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.impl.refl.nodes.GetterAccessor;
import org.mvel2.util.ParseTools;

public class MethodAccessor
implements AccessorNode {
    private AccessorNode nextNode;
    private Method method;
    private Class[] parameterTypes;
    private ExecutableStatement[] parms;
    private int length;
    private boolean coercionNeeded = false;
    private boolean augmented = false;

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory vars) {
        if (!this.coercionNeeded) {
            try {
                if (this.nextNode != null) {
                    return this.nextNode.getValue(this.method.invoke(ctx, this.executeAll(elCtx, vars, ctx, this.augmented)), elCtx, vars);
                }
                return this.method.invoke(ctx, this.executeAll(elCtx, vars, ctx, this.augmented));
            }
            catch (IllegalArgumentException e) {
                Method o;
                if (ctx != null && this.method.getDeclaringClass() != ctx.getClass() && (o = ParseTools.getBestCandidate(this.parameterTypes, this.method.getName(), ctx.getClass(), ctx.getClass().getMethods(), true)) != null) {
                    return this.executeOverrideTarget(ParseTools.getWidenedTarget(o), ctx, elCtx, vars);
                }
                this.coercionNeeded = true;
                return this.getValue(ctx, elCtx, vars);
            }
            catch (Exception e) {
                throw new RuntimeException("cannot invoke method: " + this.method.getName(), e);
            }
        }
        try {
            if (this.nextNode != null) {
                if (!this.augmented) {
                    return this.nextNode.getValue(this.method.invoke(ctx, this.executeAndCoerce(this.parameterTypes, elCtx, vars, ctx)), elCtx, vars);
                }
                return this.nextNode.getValue(this.method.invoke(ctx, this.executeAndCoerce(this.parameterTypes, elCtx, vars, ctx)), elCtx, vars);
            }
            return this.method.invoke(ctx, this.executeAndCoerce(this.parameterTypes, elCtx, vars, ctx));
        }
        catch (IllegalArgumentException e) {
            Object[] vs = this.executeAndCoerce(this.parameterTypes, elCtx, vars, ctx);
            Method newMeth = ParseTools.getWidenedTarget(ParseTools.getBestCandidate(vs, this.method.getName(), ctx.getClass(), ctx.getClass().getMethods(), false));
            if (newMeth != null) {
                return this.executeOverrideTarget(newMeth, ctx, elCtx, vars);
            }
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("cannot invoke method: " + this.method.getName(), e);
        }
    }

    private Object executeOverrideTarget(Method o, Object ctx, Object elCtx, VariableResolverFactory vars) {
        if (!this.coercionNeeded) {
            try {
                try {
                    if (this.nextNode != null) {
                        return this.nextNode.getValue(o.invoke(ctx, this.executeAll(elCtx, vars, ctx, this.augmented)), elCtx, vars);
                    }
                    return o.invoke(ctx, this.executeAll(elCtx, vars, ctx, this.augmented));
                }
                catch (IllegalArgumentException e) {
                    if (this.coercionNeeded) {
                        throw e;
                    }
                    this.coercionNeeded = true;
                    return this.executeOverrideTarget(o, ctx, elCtx, vars);
                }
            }
            catch (Exception e2) {
                throw new RuntimeException("unable to invoke method", e2);
            }
        }
        try {
            if (this.nextNode != null) {
                return this.nextNode.getValue(o.invoke(ctx, this.executeAndCoerce(o.getParameterTypes(), elCtx, vars, ctx)), elCtx, vars);
            }
            return o.invoke(ctx, this.executeAndCoerce(o.getParameterTypes(), elCtx, vars, ctx));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("unable to invoke method (expected target: " + this.method.getDeclaringClass().getName() + "::" + this.method.getName() + "; " + "actual target: " + ctx.getClass().getName() + "::" + this.method.getName() + "; coercionNeeded=" + (this.coercionNeeded ? "yes" : "no") + ")");
        }
        catch (Exception e2) {
            throw new RuntimeException("unable to invoke method (expected target: " + this.method.getDeclaringClass().getName() + "::" + this.method.getName() + "; " + "actual target: " + ctx.getClass().getName() + "::" + this.method.getName() + "; coercionNeeded=" + (this.coercionNeeded ? "yes" : "no") + ")");
        }
    }

    private Object[] executeAll(Object ctx, VariableResolverFactory vars, Object ctx2, boolean augmented) {
        if (this.length == 0) {
            return GetterAccessor.EMPTY;
        }
        Object[] vals = new Object[this.length];
        if (augmented) {
            vals[0] = ctx2;
            for (int i = 0; i < this.length - 1; ++i) {
                vals[i + 1] = this.parms[i].getValue(ctx, vars);
            }
        } else {
            for (int i = 0; i < this.length; ++i) {
                vals[i] = this.parms[i].getValue(ctx, vars);
            }
        }
        return vals;
    }

    private Object[] executeAndCoerce(Class[] target, Object elCtx, VariableResolverFactory vars, Object ctx2) {
        Object[] values = new Object[this.length];
        if (this.augmented) {
            values[0] = ctx2;
            for (int i = 0; i < this.length - 1; ++i) {
                values[i + 1] = DataConversion.convert(this.parms[i].getValue(elCtx, vars), target[i + 1]);
            }
        } else {
            for (int i = 0; i < this.length; ++i) {
                values[i] = DataConversion.convert(this.parms[i].getValue(elCtx, vars), target[i]);
            }
        }
        return values;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
        this.parameterTypes = this.method.getParameterTypes();
        this.length = this.parameterTypes.length;
    }

    public ExecutableStatement[] getParms() {
        return this.parms;
    }

    public void setParms(ExecutableStatement[] parms) {
        this.parms = parms;
    }

    public MethodAccessor() {
    }

    public MethodAccessor(Method method, ExecutableStatement[] parms, boolean augmented) {
        this.method = method;
        this.parameterTypes = this.method.getParameterTypes();
        this.length = this.parameterTypes.length;
        this.parms = parms;
        this.augmented = augmented;
    }

    public AccessorNode getNextNode() {
        return this.nextNode;
    }

    public AccessorNode setNextNode(AccessorNode nextNode) {
        this.nextNode = nextNode;
        return this.nextNode;
    }

    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
        try {
            return this.nextNode.setValue(this.method.invoke(ctx, this.executeAll(elCtx, variableFactory, ctx, this.augmented)), elCtx, variableFactory, value);
        }
        catch (IllegalArgumentException e) {
            Method o;
            if (ctx != null && this.method.getDeclaringClass() != ctx.getClass() && (o = ParseTools.getBestCandidate(this.parameterTypes, this.method.getName(), ctx.getClass(), ctx.getClass().getMethods(), true)) != null) {
                return this.nextNode.setValue(this.executeOverrideTarget(o, ctx, elCtx, variableFactory), elCtx, variableFactory, value);
            }
            this.coercionNeeded = true;
            return this.setValue(ctx, elCtx, variableFactory, value);
        }
        catch (Exception e) {
            throw new RuntimeException("cannot invoke method", e);
        }
    }

    public Class getKnownEgressType() {
        return this.method.getReturnType();
    }
}

