/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.compiler;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import org.mvel2.CompileException;
import org.mvel2.DataConversion;
import org.mvel2.ErrorDetail;
import org.mvel2.Operator;
import org.mvel2.ParserContext;
import org.mvel2.ast.ASTNode;
import org.mvel2.ast.AssertNode;
import org.mvel2.ast.AssignmentNode;
import org.mvel2.ast.BooleanNode;
import org.mvel2.ast.DeclProtoVarNode;
import org.mvel2.ast.DeclTypedVarNode;
import org.mvel2.ast.DeepAssignmentNode;
import org.mvel2.ast.DoNode;
import org.mvel2.ast.DoUntilNode;
import org.mvel2.ast.EndOfStatement;
import org.mvel2.ast.Fold;
import org.mvel2.ast.ForEachNode;
import org.mvel2.ast.ForNode;
import org.mvel2.ast.Function;
import org.mvel2.ast.IfNode;
import org.mvel2.ast.ImportNode;
import org.mvel2.ast.IndexedAssignmentNode;
import org.mvel2.ast.IndexedDeclTypedVarNode;
import org.mvel2.ast.IndexedOperativeAssign;
import org.mvel2.ast.IndexedPostFixDecNode;
import org.mvel2.ast.IndexedPostFixIncNode;
import org.mvel2.ast.IndexedPreFixDecNode;
import org.mvel2.ast.IndexedPreFixIncNode;
import org.mvel2.ast.InlineCollectionNode;
import org.mvel2.ast.InterceptorWrapper;
import org.mvel2.ast.Invert;
import org.mvel2.ast.IsDef;
import org.mvel2.ast.LineLabel;
import org.mvel2.ast.LiteralDeepPropertyNode;
import org.mvel2.ast.LiteralNode;
import org.mvel2.ast.Negation;
import org.mvel2.ast.NewObjectNode;
import org.mvel2.ast.NewPrototypeNode;
import org.mvel2.ast.OperativeAssign;
import org.mvel2.ast.OperatorNode;
import org.mvel2.ast.PostFixDecNode;
import org.mvel2.ast.PostFixIncNode;
import org.mvel2.ast.PreFixDecNode;
import org.mvel2.ast.PreFixIncNode;
import org.mvel2.ast.Proto;
import org.mvel2.ast.ProtoVarNode;
import org.mvel2.ast.RedundantCodeException;
import org.mvel2.ast.RegExMatch;
import org.mvel2.ast.ReturnNode;
import org.mvel2.ast.Sign;
import org.mvel2.ast.Stacklang;
import org.mvel2.ast.StaticImportNode;
import org.mvel2.ast.Substatement;
import org.mvel2.ast.ThisWithNode;
import org.mvel2.ast.TypeCast;
import org.mvel2.ast.TypeDescriptor;
import org.mvel2.ast.TypedVarNode;
import org.mvel2.ast.Union;
import org.mvel2.ast.UntilNode;
import org.mvel2.ast.WhileNode;
import org.mvel2.ast.WithNode;
import org.mvel2.compiler.BlankLiteral;
import org.mvel2.compiler.Parser;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.util.ArrayTools;
import org.mvel2.util.ErrorUtil;
import org.mvel2.util.ExecutionStack;
import org.mvel2.util.FunctionParser;
import org.mvel2.util.ParseTools;
import org.mvel2.util.PropertyTools;
import org.mvel2.util.ProtoParser;
import org.mvel2.util.Soundex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractParser
implements Parser,
Serializable {
    protected char[] expr;
    protected int cursor;
    protected int start;
    protected int length;
    protected int end;
    protected int st;
    protected int fields;
    protected static final int OP_OVERFLOW = -2;
    protected static final int OP_TERMINATE = -1;
    protected static final int OP_RESET_FRAME = 0;
    protected static final int OP_CONTINUE = 1;
    protected boolean greedy = true;
    protected boolean lastWasIdentifier = false;
    protected boolean lastWasLineLabel = false;
    protected boolean lastWasComment = false;
    protected boolean compileMode = false;
    protected int literalOnly = -1;
    protected int lastLineStart = 0;
    protected int line = 0;
    protected ASTNode lastNode;
    private static final WeakHashMap<String, char[]> EX_PRECACHE = new WeakHashMap(15);
    public static HashMap<String, Object> LITERALS;
    public static HashMap<String, Object> CLASS_LITERALS;
    public static HashMap<String, Integer> OPERATORS;
    protected ExecutionStack stk;
    protected ExecutionStack splitAccumulator = new ExecutionStack();
    protected static ThreadLocal<ParserContext> parserContext;
    protected ParserContext pCtx;
    protected ExecutionStack dStack;
    protected Object ctx;
    protected VariableResolverFactory variableFactory;
    protected boolean debugSymbols = false;
    protected static final int SET = 0;
    protected static final int REMOVE = 1;
    protected static final int GET = 2;
    protected static final int GET_OR_CREATE = 3;
    public static final int LEVEL_5_CONTROL_FLOW = 5;
    public static final int LEVEL_4_ASSIGNMENT = 4;
    public static final int LEVEL_3_ITERATION = 3;
    public static final int LEVEL_2_MULTI_STATEMENT = 2;
    public static final int LEVEL_1_BASIC_LANG = 1;
    public static final int LEVEL_0_PROPERTY_ONLY = 0;

    public static void setupParser() {
        if (LITERALS == null || LITERALS.isEmpty()) {
            LITERALS = new HashMap();
            CLASS_LITERALS = new HashMap();
            OPERATORS = new HashMap();
            CLASS_LITERALS.put("System", System.class);
            CLASS_LITERALS.put("String", String.class);
            CLASS_LITERALS.put("CharSequence", CharSequence.class);
            CLASS_LITERALS.put("Integer", Integer.class);
            CLASS_LITERALS.put("int", Integer.class);
            CLASS_LITERALS.put("Long", Long.class);
            CLASS_LITERALS.put("long", Long.class);
            CLASS_LITERALS.put("Boolean", Boolean.class);
            CLASS_LITERALS.put("boolean", Boolean.class);
            CLASS_LITERALS.put("Short", Short.class);
            CLASS_LITERALS.put("short", Short.class);
            CLASS_LITERALS.put("Character", Character.class);
            CLASS_LITERALS.put("char", Character.class);
            CLASS_LITERALS.put("Double", Double.class);
            CLASS_LITERALS.put("double", Double.class);
            CLASS_LITERALS.put("Float", Float.class);
            CLASS_LITERALS.put("float", Float.class);
            CLASS_LITERALS.put("Byte", Byte.class);
            CLASS_LITERALS.put("byte", Byte.class);
            CLASS_LITERALS.put("Math", Math.class);
            CLASS_LITERALS.put("Void", Void.class);
            CLASS_LITERALS.put("Object", Object.class);
            CLASS_LITERALS.put("Number", Number.class);
            CLASS_LITERALS.put("Class", Class.class);
            CLASS_LITERALS.put("ClassLoader", ClassLoader.class);
            CLASS_LITERALS.put("Runtime", Runtime.class);
            CLASS_LITERALS.put("Thread", Thread.class);
            CLASS_LITERALS.put("Compiler", Compiler.class);
            CLASS_LITERALS.put("StringBuffer", StringBuffer.class);
            CLASS_LITERALS.put("ThreadLocal", ThreadLocal.class);
            CLASS_LITERALS.put("SecurityManager", SecurityManager.class);
            CLASS_LITERALS.put("StrictMath", StrictMath.class);
            CLASS_LITERALS.put("Exception", Exception.class);
            CLASS_LITERALS.put("Array", Array.class);
            if (Double.parseDouble(System.getProperty("java.version").substring(0, 3)) >= 1.5) {
                try {
                    CLASS_LITERALS.put("StringBuilder", Thread.currentThread().getContextClassLoader().loadClass("java.lang.StringBuilder"));
                }
                catch (Exception e) {
                    throw new RuntimeException("cannot resolve a built-in literal", e);
                }
            }
            LITERALS.putAll(CLASS_LITERALS);
            LITERALS.put("true", Boolean.TRUE);
            LITERALS.put("false", Boolean.FALSE);
            LITERALS.put("null", null);
            LITERALS.put("nil", null);
            LITERALS.put("empty", BlankLiteral.INSTANCE);
            AbstractParser.setLanguageLevel(Boolean.getBoolean("mvel.future.lang.support") ? 6 : 5);
        }
    }

    protected ASTNode nextTokenSkipSymbols() {
        ASTNode n = this.nextToken();
        if (n != null && n.getFields() == -1) {
            n = this.nextToken();
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ASTNode nextToken() {
        try {
            if (!this.splitAccumulator.isEmpty()) {
                this.lastNode = (ASTNode)this.splitAccumulator.pop();
                if (this.cursor < this.end || !(this.lastNode instanceof EndOfStatement)) return this.lastNode;
                return this.nextToken();
            }
            if (this.cursor >= this.end) {
                return null;
            }
            boolean capture = false;
            boolean union = false;
            if ((this.fields & 0x10) != 0 && this.pCtx == null) {
                this.pCtx = this.getParserContext();
                this.debugSymbols = this.pCtx.isDebugSymbols();
            }
            if (this.debugSymbols) {
                if (!this.lastWasLineLabel) {
                    if (this.pCtx.getSourceFile() == null) {
                        throw new CompileException("unable to produce debugging symbols: source name must be provided.", this.expr, this.st);
                    }
                    if (!this.pCtx.isLineMapped(this.pCtx.getSourceFile())) {
                        this.pCtx.initLineMapping(this.pCtx.getSourceFile(), this.expr);
                    }
                    this.skipWhitespace();
                    if (this.cursor >= this.end) {
                        return null;
                    }
                    int line = this.pCtx.getLineFor(this.pCtx.getSourceFile(), this.cursor);
                    if (!this.pCtx.isVisitedLine(this.pCtx.getSourceFile(), this.pCtx.setLineCount(line)) && !this.pCtx.isBlockSymbols()) {
                        this.lastWasLineLabel = true;
                        this.pCtx.visitLine(this.pCtx.getSourceFile(), line);
                        this.lastNode = this.pCtx.setLastLineLabel(new LineLabel(this.pCtx.getSourceFile(), line));
                        return this.lastNode;
                    }
                } else {
                    this.lastWasLineLabel = false;
                    this.lastWasComment = false;
                }
            }
            this.skipWhitespace();
            this.st = this.cursor;
            block93: while (this.cursor != this.end) {
                int idx;
                String name;
                if (ParseTools.isIdentifierPart(this.expr[this.cursor])) {
                    capture = true;
                    ++this.cursor;
                    while (this.cursor != this.end && ParseTools.isIdentifierPart(this.expr[this.cursor])) {
                        ++this.cursor;
                    }
                }
                if (capture) {
                    String t = new String(this.expr, this.st, this.cursor - this.st);
                    if (OPERATORS.containsKey(t)) {
                        switch (OPERATORS.get(t)) {
                            case 34: {
                                this.st = this.cursor = this.trimRight(this.cursor);
                                if (!ParseTools.isIdentifierPart(this.expr[this.cursor])) {
                                    throw new CompileException("unexpected character (expected identifier): " + this.expr[this.cursor], this.expr, this.st);
                                }
                                do {
                                    this.captureToNextTokenJunction();
                                    this.skipWhitespace();
                                } while (this.cursor < this.end && this.expr[this.cursor] == '[');
                                if (this.cursor < this.end && !this.lastNonWhite(']')) {
                                    this.captureToEOT();
                                }
                                TypeDescriptor descr = new TypeDescriptor(this.expr, this.st, this.trimLeft(this.cursor) - this.st, this.fields);
                                if (this.pCtx == null) {
                                    this.pCtx = this.getParserContext();
                                }
                                if (this.pCtx.hasProtoImport(descr.getClassName())) {
                                    this.lastNode = new NewPrototypeNode(descr);
                                    return this.lastNode;
                                }
                                this.lastNode = new NewObjectNode(descr, this.fields, this.pCtx);
                                this.skipWhitespace();
                                if (this.cursor != this.end && this.expr[this.cursor] == '{') {
                                    if (!((NewObjectNode)this.lastNode).getTypeDescr().isUndimensionedArray()) {
                                        throw new CompileException("conflicting syntax: dimensioned array with initializer block", this.expr, this.st);
                                    }
                                    this.st = this.cursor;
                                    Class egressType = this.lastNode.getEgressType();
                                    if (egressType == null) {
                                        try {
                                            egressType = TypeDescriptor.getClassReference(this.pCtx, descr);
                                        }
                                        catch (ClassNotFoundException e) {
                                            throw new CompileException("could not instantiate class", this.expr, this.st, e);
                                        }
                                    }
                                    this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, this.st, this.end, this.expr[this.cursor], this.pCtx) + 1;
                                    if (this.tokenContinues()) {
                                        this.lastNode = new InlineCollectionNode(this.expr, this.st, this.cursor - this.st, this.fields, egressType, this.pCtx);
                                        this.st = this.cursor;
                                        this.captureToEOT();
                                        this.lastNode = new Union(this.expr, this.st + 1, this.cursor, this.fields, this.lastNode);
                                        return this.lastNode;
                                    }
                                    this.lastNode = new InlineCollectionNode(this.expr, this.st, this.cursor - this.st, this.fields, egressType, this.pCtx);
                                    return this.lastNode;
                                }
                                if (((NewObjectNode)this.lastNode).getTypeDescr().isUndimensionedArray()) {
                                    throw new CompileException("array initializer expected", this.expr, this.st);
                                }
                                this.st = this.cursor;
                                return this.lastNode;
                            }
                            case 97: {
                                this.st = this.cursor = this.trimRight(this.cursor);
                                this.captureToEOS();
                                this.lastNode = new AssertNode(this.expr, this.st, this.cursor-- - this.st, this.fields, this.pCtx);
                                return this.lastNode;
                            }
                            case 99: {
                                this.st = this.cursor = this.trimRight(this.cursor);
                                this.captureToEOS();
                                this.lastNode = new ReturnNode(this.expr, this.st, this.cursor - this.st, this.fields, this.pCtx);
                                return this.lastNode;
                            }
                            case 39: {
                                return this.captureCodeBlock(2048);
                            }
                            case 40: {
                                throw new CompileException("else without if", this.expr, this.st);
                            }
                            case 38: {
                                return this.captureCodeBlock(4096);
                            }
                            case 41: {
                                return this.captureCodeBlock(32768);
                            }
                            case 42: {
                                return this.captureCodeBlock(16384);
                            }
                            case 43: {
                                return this.captureCodeBlock(262144);
                            }
                            case 46: {
                                return this.captureCodeBlock(8192);
                            }
                            case 45: {
                                return this.captureCodeBlock(65536);
                            }
                            case 101: {
                                return this.captureCodeBlock(101);
                            }
                            case 48: {
                                return this.captureCodeBlock(48);
                            }
                            case 47: {
                                this.st = this.cursor = this.trimRight(this.cursor);
                                this.captureToNextTokenJunction();
                                this.lastNode = new IsDef(this.expr, this.st, this.cursor - this.st);
                                return this.lastNode;
                            }
                            case 96: {
                                this.st = this.cursor = this.trimRight(this.cursor);
                                this.captureToEOS();
                                ImportNode importNode = new ImportNode(this.expr, this.st, this.cursor - this.st);
                                if (this.pCtx == null) {
                                    this.pCtx = this.getParserContext();
                                }
                                if (importNode.isPackageImport()) {
                                    this.pCtx.addPackageImport(importNode.getPackageImport());
                                } else {
                                    this.pCtx.addImport(importNode.getImportClass().getSimpleName(), importNode.getImportClass());
                                }
                                this.lastNode = importNode;
                                return this.lastNode;
                            }
                            case 95: {
                                this.st = this.cursor = this.trimRight(this.cursor);
                                this.captureToEOS();
                                this.lastNode = new StaticImportNode(this.expr, this.st, this.trimLeft(this.cursor) - this.st);
                                return this.lastNode;
                            }
                            case 100: {
                                this.lastNode = this.captureCodeBlock(100);
                                this.st = this.cursor + 1;
                                return this.lastNode;
                            }
                            case 98: {
                                this.st = this.cursor + 1;
                                while (true) {
                                    this.captureToEOT();
                                    int end = this.cursor;
                                    this.skipWhitespace();
                                    if (this.cursor != end && this.expr[this.cursor] == '=') {
                                        this.cursor = this.st;
                                        if (end != this.cursor) continue block93;
                                        throw new CompileException("illegal use of reserved word: var", this.expr, this.st);
                                    }
                                    name = new String(this.expr, this.st, end - this.st);
                                    if (this.pCtx != null && (idx = this.pCtx.variableIndexOf(name)) != -1) {
                                        this.lastNode = new IndexedDeclTypedVarNode(idx, this.st, end - this.st, Object.class);
                                        this.splitAccumulator.add(this.lastNode);
                                    } else {
                                        this.lastNode = new DeclTypedVarNode(name, this.expr, this.st, end - this.st, Object.class, this.fields, this.pCtx);
                                        this.splitAccumulator.add(this.lastNode);
                                    }
                                    if (this.cursor == this.end || this.expr[this.cursor] != ',') return (ASTNode)this.splitAccumulator.pop();
                                    this.skipWhitespace();
                                    this.st = ++this.cursor;
                                }
                            }
                        }
                    }
                    this.skipWhitespace();
                    if (this.cursor != this.end && this.expr[this.cursor] == '(') {
                        this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, this.cursor, this.end, '(', this.pCtx) + 1;
                    }
                    block97: while (this.cursor != this.end) {
                        switch (this.expr[this.cursor]) {
                            case '.': {
                                union = true;
                                ++this.cursor;
                                this.skipWhitespace();
                                continue block97;
                            }
                            case '?': {
                                if (this.lookToLast() != '.') break block97;
                                union = true;
                                ++this.cursor;
                                continue block97;
                            }
                            case '+': {
                                switch (this.lookAhead()) {
                                    case '+': {
                                        name = new String(this.subArray(this.st, this.trimLeft(this.cursor)));
                                        this.lastNode = this.pCtx != null && (idx = this.pCtx.variableIndexOf(name)) != -1 ? new IndexedPostFixIncNode(idx, this.pCtx) : new PostFixIncNode(name, this.pCtx);
                                        this.cursor += 2;
                                        this.expectEOS();
                                        return this.lastNode;
                                    }
                                    case '=': {
                                        name = ParseTools.createStringTrimmed(this.expr, this.st, this.cursor - this.st);
                                        this.st = this.cursor += 2;
                                        this.captureToEOS();
                                        if (union) {
                                            this.st = this.trimRight(this.st);
                                            this.lastNode = new DeepAssignmentNode(this.expr, this.st, this.trimLeft(this.cursor) - this.st, this.fields, 0, name, this.pCtx);
                                            return this.lastNode;
                                        }
                                        if (this.pCtx != null && (idx = this.pCtx.variableIndexOf(name)) != -1) {
                                            this.lastNode = new IndexedAssignmentNode(this.expr, this.st, this.cursor - this.st, this.fields, 0, name, idx, this.pCtx);
                                            return this.lastNode;
                                        }
                                        this.st = this.trimRight(this.st);
                                        this.lastNode = new OperativeAssign(name, this.expr, this.st, this.trimLeft(this.cursor) - this.st, 0, this.fields, this.pCtx);
                                        return this.lastNode;
                                    }
                                }
                                if (!ParseTools.isDigit(this.lookAhead()) || this.cursor <= 1 || this.expr[this.cursor - 1] != 'E' && this.expr[this.cursor - 1] != 'e' || !ParseTools.isDigit(this.expr[this.cursor - 2])) break block97;
                                ++this.cursor;
                                continue block93;
                            }
                            case '-': {
                                switch (this.lookAhead()) {
                                    case '-': {
                                        name = new String(this.subArray(this.st, this.trimLeft(this.cursor)));
                                        this.lastNode = this.pCtx != null && (idx = this.pCtx.variableIndexOf(name)) != -1 ? new IndexedPostFixDecNode(idx, this.pCtx) : new PostFixDecNode(name, this.pCtx);
                                        this.cursor += 2;
                                        this.expectEOS();
                                        return this.lastNode;
                                    }
                                    case '=': {
                                        name = new String(this.expr, this.st, this.trimLeft(this.cursor) - this.st);
                                        this.st = this.cursor += 2;
                                        this.captureToEOS();
                                        if (union) {
                                            this.lastNode = new DeepAssignmentNode(this.expr, this.st, this.cursor - this.st, this.fields, 1, t, this.pCtx);
                                            return this.lastNode;
                                        }
                                        if (this.pCtx != null && (idx = this.pCtx.variableIndexOf(name)) != -1) {
                                            this.lastNode = new IndexedOperativeAssign(this.expr, this.st, this.cursor - this.st, 1, idx, this.fields, this.pCtx);
                                            return this.lastNode;
                                        }
                                        this.lastNode = new OperativeAssign(name, this.expr, this.st, this.cursor - this.st, 1, this.fields, this.pCtx);
                                        return this.lastNode;
                                    }
                                }
                                if (!ParseTools.isDigit(this.lookAhead()) || this.cursor <= 1 || this.expr[this.cursor - 1] != 'E' && this.expr[this.cursor - 1] != 'e' || !ParseTools.isDigit(this.expr[this.cursor - 2])) break block97;
                                ++this.cursor;
                                capture = true;
                                continue block93;
                            }
                            case '!': 
                            case '\"': 
                            case '\'': 
                            case ',': 
                            case ':': 
                            case ';': {
                                break block97;
                            }
                            case '%': 
                            case '&': 
                            case '*': 
                            case '/': 
                            case '^': 
                            case '|': 
                            case '\u00ab': 
                            case '\u00ac': 
                            case '\u00bb': {
                                char op = this.expr[this.cursor];
                                if (this.lookAhead() != '=') break block97;
                                name = new String(this.expr, this.st, this.trimLeft(this.cursor) - this.st);
                                this.st = this.cursor += 2;
                                this.captureToEOS();
                                if (union) {
                                    this.lastNode = new DeepAssignmentNode(this.expr, this.st, this.cursor - this.st, this.fields, ParseTools.opLookup(op), t, this.pCtx);
                                    return this.lastNode;
                                }
                                if (this.pCtx != null && (idx = this.pCtx.variableIndexOf(name)) != -1) {
                                    this.lastNode = new IndexedOperativeAssign(this.expr, this.st, this.cursor - this.st, ParseTools.opLookup(op), idx, this.fields, this.pCtx);
                                    return this.lastNode;
                                }
                                this.lastNode = new OperativeAssign(name, this.expr, this.st, this.cursor - this.st, ParseTools.opLookup(op), this.fields, this.pCtx);
                                return this.lastNode;
                            }
                            case '<': {
                                if (this.lookAhead() != '<' || this.lookAhead(2) != '=') break block97;
                                name = new String(this.expr, this.st, this.trimLeft(this.cursor) - this.st);
                                this.st = this.cursor += 3;
                                this.captureToEOS();
                                if (union) {
                                    this.lastNode = new DeepAssignmentNode(this.expr, this.st, this.cursor - this.st, this.fields, 10, t, this.pCtx);
                                    return this.lastNode;
                                }
                                if (this.pCtx != null && (idx = this.pCtx.variableIndexOf(name)) != -1) {
                                    this.lastNode = new IndexedOperativeAssign(this.expr, this.st, this.cursor - this.st, 10, idx, this.fields, this.pCtx);
                                    return this.lastNode;
                                }
                                this.lastNode = new OperativeAssign(name, this.expr, this.st, this.cursor - this.st, 10, this.fields, this.pCtx);
                                return this.lastNode;
                            }
                            case '>': {
                                if (this.lookAhead() != '>') break block97;
                                if (this.lookAhead(2) == '=') {
                                    name = new String(this.expr, this.st, this.trimLeft(this.cursor) - this.st);
                                    this.st = this.cursor += 3;
                                    this.captureToEOS();
                                    if (union) {
                                        this.lastNode = new DeepAssignmentNode(this.expr, this.st, this.cursor - this.st, this.fields, 9, t, this.pCtx);
                                        return this.lastNode;
                                    }
                                    if (this.pCtx != null && (idx = this.pCtx.variableIndexOf(name)) != -1) {
                                        this.lastNode = new IndexedOperativeAssign(this.expr, this.st, this.cursor - this.st, 9, idx, this.fields, this.pCtx);
                                        return this.lastNode;
                                    }
                                    this.lastNode = new OperativeAssign(name, this.expr, this.st, this.cursor - this.st, 9, this.fields, this.pCtx);
                                    return this.lastNode;
                                }
                                if (this.lookAhead(2) != '>' || this.lookAhead(3) != '=') break block97;
                                name = new String(this.expr, this.st, this.trimLeft(this.cursor) - this.st);
                                this.st = this.cursor += 4;
                                this.captureToEOS();
                                if (union) {
                                    this.lastNode = new DeepAssignmentNode(this.expr, this.st, this.cursor - this.st, this.fields, 11, t, this.pCtx);
                                    return this.lastNode;
                                }
                                if (this.pCtx != null && (idx = this.pCtx.variableIndexOf(name)) != -1) {
                                    this.lastNode = new IndexedOperativeAssign(this.expr, this.st, this.cursor - this.st, 11, idx, this.fields, this.pCtx);
                                    return this.lastNode;
                                }
                                this.lastNode = new OperativeAssign(name, this.expr, this.st, this.cursor - this.st, 11, this.fields, this.pCtx);
                                return this.lastNode;
                            }
                            case '(': {
                                this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, this.cursor, this.end, '(', this.pCtx) + 1;
                                continue block97;
                            }
                            case '[': {
                                this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, this.cursor, this.end, '[', this.pCtx) + 1;
                                continue block97;
                            }
                            case '{': {
                                if (!union) break block97;
                                this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, this.cursor, this.end, '{', this.pCtx) + 1;
                                continue block97;
                            }
                            case '~': {
                                if (this.lookAhead() != '=') break block97;
                                int tmpStart = this.st;
                                int tmpOffset = this.cursor - this.st;
                                this.st = this.cursor += 2;
                                this.captureToEOT();
                                this.lastNode = new RegExMatch(this.expr, tmpStart, tmpOffset, this.fields, this.st, this.cursor - this.st, this.pCtx);
                                return this.lastNode;
                            }
                            case '=': {
                                if (this.lookAhead() == '+') {
                                    name = new String(this.expr, this.st, this.trimLeft(this.cursor) - this.st);
                                    this.st = this.cursor += 2;
                                    if (!this.isNextIdentifierOrLiteral()) {
                                        throw new CompileException("unexpected symbol '" + this.expr[this.cursor] + "'", this.expr, this.st);
                                    }
                                    this.captureToEOS();
                                    if (this.pCtx != null && (idx = this.pCtx.variableIndexOf(name)) != -1) {
                                        this.lastNode = new IndexedOperativeAssign(this.expr, this.st, this.cursor - this.st, 0, idx, this.fields, this.pCtx);
                                        return this.lastNode;
                                    }
                                    this.lastNode = new OperativeAssign(name, this.expr, this.st, this.cursor - this.st, 0, this.fields, this.pCtx);
                                    return this.lastNode;
                                }
                                if (this.lookAhead() == '-') {
                                    name = new String(this.expr, this.st, this.trimLeft(this.cursor) - this.st);
                                    this.st = this.cursor += 2;
                                    if (!this.isNextIdentifierOrLiteral()) {
                                        throw new CompileException("unexpected symbol '" + this.expr[this.cursor] + "'", this.expr, this.st);
                                    }
                                    this.captureToEOS();
                                    if (this.pCtx != null && (idx = this.pCtx.variableIndexOf(name)) != -1) {
                                        this.lastNode = new IndexedOperativeAssign(this.expr, this.st, this.cursor - this.st, 1, idx, this.fields, this.pCtx);
                                        return this.lastNode;
                                    }
                                    this.lastNode = new OperativeAssign(name, this.expr, this.st, this.cursor - this.st, 1, this.fields, this.pCtx);
                                    return this.lastNode;
                                }
                                if (!this.greedy || this.lookAhead() == '=') break block97;
                                ++this.cursor;
                                if (union) {
                                    this.captureToEOS();
                                    this.lastNode = new DeepAssignmentNode(this.expr, this.st, this.cursor - this.st, this.fields | 0x80, this.pCtx);
                                    return this.lastNode;
                                }
                                if (this.lastWasIdentifier) {
                                    return this.procTypedNode(false);
                                }
                                if (this.pCtx != null && (idx = this.pCtx.variableIndexOf(t)) != -1 && this.pCtx.isIndexAllocation()) {
                                    this.captureToEOS();
                                    this.st = this.trimRight(this.st);
                                    IndexedAssignmentNode ian = new IndexedAssignmentNode(this.expr, this.st, this.trimLeft(this.cursor) - this.st, 128, idx, this.pCtx);
                                    if (idx == -1) {
                                        t = ian.getAssignmentVar();
                                        this.pCtx.addIndexedInput(t);
                                        ian.setRegister(this.pCtx.variableIndexOf(t));
                                    }
                                    this.lastNode = ian;
                                    return this.lastNode;
                                }
                                this.captureToEOS();
                                this.lastNode = new AssignmentNode(this.expr, this.st, this.cursor - this.st, this.fields | 0x80, this.pCtx);
                                return this.lastNode;
                            }
                            default: {
                                if (this.cursor == this.end) break block97;
                                if (ParseTools.isIdentifierPart(this.expr[this.cursor])) {
                                    if (!union) break block97;
                                    ++this.cursor;
                                    while (this.cursor != this.end && ParseTools.isIdentifierPart(this.expr[this.cursor])) {
                                        ++this.cursor;
                                    }
                                    continue block97;
                                }
                                if (this.cursor + 1 != this.end && ParseTools.isIdentifierPart(this.expr[this.cursor + 1])) break block97;
                                ++this.cursor;
                                continue block97;
                            }
                        }
                    }
                    this.trimWhitespace();
                    return this.createPropertyToken(this.st, this.cursor);
                }
                switch (this.expr[this.cursor]) {
                    case '.': {
                        ++this.cursor;
                        if (ParseTools.isDigit(this.expr[this.cursor])) {
                            capture = true;
                            continue block93;
                        }
                        this.expectNextChar_IW('{');
                        this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, this.cursor, this.end, '{', this.pCtx) + 1;
                        this.lastNode = new ThisWithNode(this.expr, this.st, this.cursor - this.st - 1, this.cursor + 1, this.cursor - 3, this.fields, this.pCtx);
                        return this.lastNode;
                    }
                    case '@': {
                        ++this.st;
                        this.captureToEOT();
                        if (this.pCtx == null || this.pCtx.getInterceptors() == null) throw new CompileException("reference to undefined interceptor: " + new String(this.expr, this.st, this.cursor - this.st), this.expr, this.st);
                        name = new String(this.expr, this.st, this.cursor - this.st);
                        if (!this.pCtx.getInterceptors().containsKey(name)) {
                            throw new CompileException("reference to undefined interceptor: " + new String(this.expr, this.st, this.cursor - this.st), this.expr, this.st);
                        }
                        this.lastNode = new InterceptorWrapper(this.pCtx.getInterceptors().get(name), this.nextToken());
                        return this.lastNode;
                    }
                    case '=': {
                        return this.createOperator(this.expr, this.st, this.cursor += 2);
                    }
                    case '-': {
                        if (this.lookAhead() == '-') {
                            this.cursor += 2;
                            this.skipWhitespace();
                            this.st = this.cursor;
                            this.captureIdentifier();
                            name = new String(this.subArray(this.st, this.cursor));
                            if (this.pCtx != null && (idx = this.pCtx.variableIndexOf(name)) != -1) {
                                this.lastNode = new IndexedPreFixDecNode(idx, this.pCtx);
                                return this.lastNode;
                            }
                            this.lastNode = new PreFixDecNode(name, this.pCtx);
                            return this.lastNode;
                        }
                        if ((this.cursor == this.start || this.lastNode != null && (this.lastNode instanceof BooleanNode || this.lastNode.isOperator())) && !ParseTools.isDigit(this.lookAhead())) {
                            this.captureToEOT();
                            return new Sign(this.expr, this.st, this.cursor - this.st, this.fields, this.pCtx);
                        }
                        if (this.cursor != this.start && !ParseTools.isWhitespace(this.expr[this.cursor - 1]) && (this.lastNode == null || !(this.lastNode instanceof BooleanNode) && !this.lastNode.isOperator()) || !ParseTools.isDigit(this.lookAhead())) {
                            return this.createOperator(this.expr, this.st, this.cursor++ + 1);
                        }
                        if (this.cursor - 1 == this.start && (ParseTools.isDigit(this.expr[this.cursor - 1]) || !ParseTools.isDigit(this.lookAhead()))) throw new CompileException("not a statement", this.expr, this.st);
                        ++this.cursor;
                        continue block93;
                    }
                    case '+': {
                        if (this.lookAhead() != '+') return this.createOperator(this.expr, this.st, this.cursor++ + 1);
                        this.cursor += 2;
                        this.skipWhitespace();
                        this.st = this.cursor;
                        this.captureIdentifier();
                        name = new String(this.subArray(this.st, this.cursor));
                        if (this.pCtx != null && (idx = this.pCtx.variableIndexOf(name)) != -1) {
                            this.lastNode = new IndexedPreFixIncNode(idx, this.pCtx);
                            return this.lastNode;
                        }
                        this.lastNode = new PreFixIncNode(name, this.pCtx);
                        return this.lastNode;
                    }
                    case '*': {
                        if (this.lookAhead() != '*') return this.createOperator(this.expr, this.st, this.cursor++ + 1);
                        ++this.cursor;
                        return this.createOperator(this.expr, this.st, this.cursor++ + 1);
                    }
                    case ';': {
                        ++this.cursor;
                        this.lastWasIdentifier = false;
                        this.lastNode = new EndOfStatement();
                        return this.lastNode;
                    }
                    case '#': 
                    case '%': 
                    case '/': 
                    case ':': 
                    case '?': 
                    case '^': {
                        return this.createOperator(this.expr, this.st, this.cursor++ + 1);
                    }
                    case '(': {
                        ++this.cursor;
                        boolean singleToken = true;
                        this.skipWhitespace();
                        int brace = 1;
                        while (this.cursor != this.end && brace != 0) {
                            block66 : switch (this.expr[this.cursor]) {
                                case '(': {
                                    ++brace;
                                    break;
                                }
                                case ')': {
                                    --brace;
                                    break;
                                }
                                case '\'': {
                                    this.cursor = ParseTools.captureStringLiteral('\'', this.expr, this.cursor, this.end);
                                    break;
                                }
                                case '\"': {
                                    this.cursor = ParseTools.captureStringLiteral('\"', this.expr, this.cursor, this.end);
                                    break;
                                }
                                case 'i': {
                                    if (brace != 1 || !ParseTools.isWhitespace(this.lookBehind()) || this.lookAhead() != 'n' || !ParseTools.isWhitespace(this.lookAhead(2))) break;
                                    int level = brace;
                                    while (this.cursor != this.end) {
                                        switch (this.expr[this.cursor]) {
                                            case '(': {
                                                ++brace;
                                                break;
                                            }
                                            case ')': {
                                                if (--brace >= level) break;
                                                ++this.cursor;
                                                if (this.tokenContinues()) {
                                                    this.lastNode = new Fold(this.expr, this.trimRight(this.st + 1), this.cursor - this.st - 2, this.fields, this.pCtx);
                                                    this.st = this.cursor;
                                                    if (this.expr[this.st] == '.') {
                                                        ++this.st;
                                                    }
                                                    this.captureToEOT();
                                                    this.st = this.trimRight(this.st);
                                                    this.lastNode = new Union(this.expr, this.st, this.cursor - this.st, this.fields, this.lastNode);
                                                    return this.lastNode;
                                                }
                                                this.lastNode = new Fold(this.expr, this.trimRight(this.st + 1), this.cursor - this.st - 2, this.fields, this.pCtx);
                                                return this.lastNode;
                                            }
                                            case '\'': {
                                                this.cursor = ParseTools.captureStringLiteral('\'', this.expr, this.cursor, this.end);
                                                break;
                                            }
                                            case '\"': {
                                                this.cursor = ParseTools.captureStringLiteral('\"', this.expr, this.cursor, this.end);
                                            }
                                        }
                                        ++this.cursor;
                                    }
                                    throw new CompileException("unterminated projection; closing parathesis required", this.expr, this.st);
                                }
                                default: {
                                    if (this.expr[this.cursor] == '.') break;
                                    switch (this.expr[this.cursor]) {
                                        case '[': 
                                        case ']': {
                                            break block66;
                                        }
                                    }
                                    if (ParseTools.isIdentifierPart(this.expr[this.cursor]) || this.expr[this.cursor] == '.') break;
                                    singleToken = false;
                                }
                            }
                            ++this.cursor;
                        }
                        if (brace != 0) {
                            throw new CompileException("unbalanced braces in expression: (" + brace + "):", this.expr, this.st);
                        }
                        int tmpStart = -1;
                        if (singleToken) {
                            int _st = this.trimRight(this.st + 1);
                            TypeDescriptor tDescr = new TypeDescriptor(this.expr, _st, this.trimLeft(this.cursor - 1) - _st, this.fields);
                            try {
                                Class cls;
                                if (tDescr.isClass() && (cls = TypeDescriptor.getClassReference(this.pCtx, tDescr)) != null) {
                                    boolean isCast = false;
                                    for (int i = this.cursor; i < this.expr.length; ++i) {
                                        if (this.expr[i] == ' ' || this.expr[i] == '\t') continue;
                                        isCast = ParseTools.isIdentifierPart(this.expr[i]) || this.expr[i] == '\'' || this.expr[i] == '\"' || this.expr[i] == '(';
                                        break;
                                    }
                                    if (isCast) {
                                        this.st = this.cursor;
                                        this.captureToEOS();
                                        this.lastNode = new TypeCast(this.expr, this.st, this.cursor - this.st, cls, this.fields, this.pCtx);
                                        return this.lastNode;
                                    }
                                }
                            }
                            catch (ClassNotFoundException e) {
                                // empty catch block
                            }
                        }
                        if (tmpStart != -1) {
                            return this.handleUnion(this.handleSubstatement(new Substatement(this.expr, tmpStart, this.cursor - tmpStart, this.fields, this.pCtx)));
                        }
                        this.st = this.trimRight(this.st + 1);
                        return this.handleUnion(this.handleSubstatement(new Substatement(this.expr, this.st, this.trimLeft(this.cursor - 1) - this.st, this.fields, this.pCtx)));
                    }
                    case ')': 
                    case ']': 
                    case '}': {
                        throw new CompileException("unbalanced braces", this.expr, this.st);
                    }
                    case '>': {
                        switch (this.expr[this.cursor + 1]) {
                            case '>': {
                                if (this.expr[this.cursor += 2] != '>') return this.createOperator(this.expr, this.st, this.cursor);
                                ++this.cursor;
                                return this.createOperator(this.expr, this.st, this.cursor);
                            }
                            case '=': {
                                return this.createOperator(this.expr, this.st, this.cursor += 2);
                            }
                        }
                        return this.createOperator(this.expr, this.st, ++this.cursor);
                    }
                    case '<': {
                        if (this.expr[++this.cursor] == '<') {
                            if (this.expr[++this.cursor] != '<') return this.createOperator(this.expr, this.st, this.cursor);
                            ++this.cursor;
                            return this.createOperator(this.expr, this.st, this.cursor);
                        }
                        if (this.expr[this.cursor] != '=') return this.createOperator(this.expr, this.st, this.cursor);
                        return this.createOperator(this.expr, this.st, ++this.cursor);
                    }
                    case '\"': 
                    case '\'': {
                        this.cursor = ParseTools.captureStringLiteral(this.expr[this.cursor], this.expr, this.cursor, this.end);
                        this.lastNode = new LiteralNode(ParseTools.handleStringEscapes(ParseTools.subset(this.expr, this.st + 1, this.cursor - this.st - 1)), String.class);
                        ++this.cursor;
                        if (!this.tokenContinues()) return this.lastNode;
                        this.lastNode = this.handleUnion(this.lastNode);
                        return this.lastNode;
                    }
                    case '&': {
                        if (this.expr[this.cursor++ + 1] != '&') return this.createOperator(this.expr, this.st, this.cursor);
                        return this.createOperator(this.expr, this.st, ++this.cursor);
                    }
                    case '|': {
                        if (this.expr[this.cursor++ + 1] != '|') return this.createOperator(this.expr, this.st, this.cursor);
                        return this.createOperator(this.expr, this.st, ++this.cursor);
                    }
                    case '~': {
                        if ((this.cursor++ - 1 != 0 || !ParseTools.isIdentifierPart(this.lookBehind())) && ParseTools.isDigit(this.expr[this.cursor])) {
                            this.st = this.cursor;
                            this.captureToEOT();
                            this.lastNode = new Invert(this.expr, this.st, this.cursor - this.st, this.fields, this.pCtx);
                            return this.lastNode;
                        }
                        if (this.expr[this.cursor] == '(') {
                            this.st = this.cursor--;
                            this.captureToEOT();
                            this.lastNode = new Invert(this.expr, this.st, this.cursor - this.st, this.fields, this.pCtx);
                            return this.lastNode;
                        }
                        if (this.expr[this.cursor] != '=') return this.createOperator(this.expr, this.st, this.cursor);
                        ++this.cursor;
                        return this.createOperator(this.expr, this.st, this.cursor);
                    }
                    case '!': {
                        ++this.cursor;
                        if (this.isNextIdentifier()) {
                            if (this.lastNode != null && !this.lastNode.isOperator()) {
                                throw new CompileException("unexpected operator '!'", this.expr, this.st);
                            }
                            this.st = this.cursor;
                            this.captureToEOT();
                            name = new String(this.expr, this.st, this.cursor - this.st);
                            if ("new".equals(name) || "isdef".equals(name)) {
                                this.captureToEOT();
                                this.lastNode = new Negation(this.expr, this.st, this.cursor - this.st, this.fields, this.pCtx);
                                return this.lastNode;
                            }
                            this.lastNode = new Negation(this.expr, this.st, this.cursor - this.st, this.fields, this.pCtx);
                            return this.lastNode;
                        }
                        if (this.expr[this.cursor] == '(') {
                            this.st = this.cursor--;
                            this.captureToEOT();
                            this.lastNode = new Negation(this.expr, this.st, this.cursor - this.st, this.fields, this.pCtx);
                            return this.lastNode;
                        }
                        if (this.expr[this.cursor] == '=') return this.createOperator(this.expr, this.st, ++this.cursor);
                        throw new CompileException("unexpected operator '!'", this.expr, this.st, null);
                    }
                    case '[': 
                    case '{': {
                        this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, this.cursor, this.end, this.expr[this.cursor], this.pCtx) + 1;
                        if (this.tokenContinues()) {
                            this.lastNode = new InlineCollectionNode(this.expr, this.st, this.cursor - this.st, this.fields, this.pCtx);
                            this.st = this.cursor;
                            this.captureToEOT();
                            if (this.expr[this.st] == '.') {
                                ++this.st;
                            }
                            this.lastNode = new Union(this.expr, this.st, this.cursor - this.st, this.fields, this.lastNode);
                            return this.lastNode;
                        }
                        this.lastNode = new InlineCollectionNode(this.expr, this.st, this.cursor - this.st, this.fields, this.pCtx);
                        return this.lastNode;
                    }
                }
                ++this.cursor;
            }
            if (this.st != this.cursor) return this.createPropertyToken(this.st, this.cursor);
            return null;
        }
        catch (RedundantCodeException e) {
            return this.nextToken();
        }
        catch (NumberFormatException e) {
            throw new CompileException("badly formatted number: " + e.getMessage(), this.expr, this.st, e);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new CompileException("unexpected end of statement", this.expr, this.cursor, e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new CompileException("unexpected end of statement", this.expr, this.cursor, e);
        }
        catch (CompileException e) {
            throw ErrorUtil.rewriteIfNeeded(e, this.expr, this.cursor);
        }
    }

    public ASTNode handleSubstatement(Substatement stmt) {
        if (stmt.getStatement() != null && stmt.getStatement().isLiteralOnly()) {
            return new LiteralNode(stmt.getStatement().getValue(null, null, null));
        }
        return stmt;
    }

    protected ASTNode handleUnion(ASTNode node) {
        if (this.cursor != this.end) {
            this.skipWhitespace();
            int union = -1;
            if (this.cursor < this.end) {
                switch (this.expr[this.cursor]) {
                    case '.': {
                        union = this.cursor + 1;
                        break;
                    }
                    case '[': {
                        union = this.cursor;
                    }
                }
            }
            if (union != -1) {
                this.captureToEOT();
                this.lastNode = new Union(this.expr, union, this.cursor - union, this.fields, node);
                return this.lastNode;
            }
        }
        this.lastNode = node;
        return this.lastNode;
    }

    private ASTNode createOperator(char[] expr, int start, int end) {
        this.lastWasIdentifier = false;
        this.lastNode = new OperatorNode(OPERATORS.get(new String(expr, start, end - start)), expr, start);
        return this.lastNode;
    }

    private char[] subArray(int start, int end) {
        if (start >= end) {
            return new char[0];
        }
        char[] newA = new char[end - start];
        for (int i = 0; i != newA.length; ++i) {
            newA[i] = this.expr[i + start];
        }
        return newA;
    }

    private ASTNode createPropertyToken(int st, int end) {
        if (ParseTools.isPropertyOnly(this.expr, st, end)) {
            String tmp;
            if (this.pCtx != null && this.pCtx.hasImports()) {
                int find = ArrayTools.findFirst('.', st, end - st, this.expr);
                if (find != -1) {
                    String iStr = new String(this.expr, st, find - st);
                    if (this.pCtx.hasImport(iStr)) {
                        this.lastWasIdentifier = true;
                        this.lastNode = new LiteralDeepPropertyNode(this.expr, find + 1, end - find - 1, this.fields, this.pCtx.getImport(iStr));
                        return this.lastNode;
                    }
                } else {
                    tmp = new String(this.expr, st, this.cursor - st);
                    if (this.pCtx.hasImport(tmp)) {
                        this.lastWasIdentifier = true;
                        this.lastNode = new LiteralNode(this.pCtx.getStaticOrClassImport(tmp));
                        return this.lastNode;
                    }
                }
            }
            if (LITERALS.containsKey(tmp = new String(this.expr, st, end - st))) {
                this.lastWasIdentifier = true;
                this.lastNode = new LiteralNode(LITERALS.get(tmp));
                return this.lastNode;
            }
            if (OPERATORS.containsKey(tmp)) {
                this.lastWasIdentifier = false;
                this.lastNode = new OperatorNode(OPERATORS.get(tmp), this.expr, st);
                return this.lastNode;
            }
            if (this.lastWasIdentifier) {
                return this.procTypedNode(true);
            }
        }
        this.lastWasIdentifier = true;
        this.lastNode = new ASTNode(this.expr, this.trimRight(st), this.trimLeft(end) - st, this.fields);
        return this.lastNode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ASTNode procTypedNode(boolean decl) {
        while (true) {
            if (this.lastNode.getLiteralValue() instanceof String) {
                char[] tmp = ((String)this.lastNode.getLiteralValue()).toCharArray();
                TypeDescriptor tDescr = new TypeDescriptor(tmp, 0, tmp.length, 0);
                try {
                    this.lastNode.setLiteralValue(TypeDescriptor.getClassReference(this.pCtx, tDescr));
                    this.lastNode.discard();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.lastNode.isLiteral() && this.lastNode.getLiteralValue() instanceof Class) {
                this.lastNode.discard();
                this.captureToEOS();
                if (decl) {
                    this.splitAccumulator.add(new DeclTypedVarNode(new String(this.expr, this.st, this.cursor - this.st), this.expr, this.st, this.cursor - this.st, (Class)this.lastNode.getLiteralValue(), this.fields | 0x80, this.pCtx));
                } else {
                    this.captureToEOS();
                    this.splitAccumulator.add(new TypedVarNode(this.expr, this.st, this.cursor - this.st - 1, this.fields | 0x80, (Class)this.lastNode.getLiteralValue(), this.pCtx));
                }
            } else if (this.lastNode instanceof Proto) {
                this.captureToEOS();
                if (decl) {
                    this.splitAccumulator.add(new DeclProtoVarNode(new String(this.expr, this.st, this.cursor - this.st), (Proto)this.lastNode, this.fields | 0x80, this.pCtx));
                } else {
                    this.splitAccumulator.add(new ProtoVarNode(this.expr, this.st, this.cursor - this.st, this.fields | 0x80, (Proto)this.lastNode, this.pCtx));
                }
            } else {
                if ((this.fields & 0x10) != 0) throw new CompileException("unknown class or illegal statement: " + this.lastNode.getLiteralValue(), this.expr, this.cursor);
                if (this.stk.peek() instanceof Class) {
                    this.captureToEOS();
                    if (decl) {
                        this.splitAccumulator.add(new DeclTypedVarNode(new String(this.expr, this.st, this.cursor - this.st), this.expr, this.st, this.cursor - this.st, (Class)this.stk.pop(), this.fields | 0x80, this.pCtx));
                    } else {
                        this.splitAccumulator.add(new TypedVarNode(this.expr, this.st, this.cursor - this.st, this.fields | 0x80, (Class)this.stk.pop(), this.pCtx));
                    }
                } else {
                    if (!(this.stk.peek() instanceof Proto)) throw new CompileException("unknown class or illegal statement: " + this.lastNode.getLiteralValue(), this.expr, this.cursor);
                    this.captureToEOS();
                    if (decl) {
                        this.splitAccumulator.add(new DeclProtoVarNode(new String(this.expr, this.st, this.cursor - this.st), (Proto)this.stk.pop(), this.fields | 0x80, this.pCtx));
                    } else {
                        this.splitAccumulator.add(new ProtoVarNode(this.expr, this.st, this.cursor - this.st, this.fields | 0x80, (Proto)this.stk.pop(), this.pCtx));
                    }
                }
            }
            this.skipWhitespace();
            if (this.cursor >= this.end || this.expr[this.cursor] != ',') return (ASTNode)this.splitAccumulator.pop();
            this.st = ++this.cursor;
            this.splitAccumulator.add(new EndOfStatement());
        }
    }

    private ASTNode createBlockToken(int condStart, int condEnd, int blockStart, int blockEnd, int type) {
        this.lastWasIdentifier = false;
        ++this.cursor;
        if (this.isStatementNotManuallyTerminated()) {
            this.splitAccumulator.add(new EndOfStatement());
        }
        int condOffset = condEnd - condStart;
        int blockOffset = blockEnd - blockStart;
        if (blockOffset < 0) {
            blockOffset = 0;
        }
        switch (type) {
            case 2048: {
                return new IfNode(this.expr, condStart, condOffset, blockStart, blockOffset, this.fields, this.pCtx);
            }
            case 262144: {
                for (int i = condStart; i < condEnd; ++i) {
                    if (this.expr[i] == ';') {
                        return new ForNode(this.expr, condStart, condOffset, blockStart, blockOffset, this.fields, this.pCtx);
                    }
                    if (this.expr[i] == ':') break;
                }
            }
            case 4096: {
                return new ForEachNode(this.expr, condStart, condOffset, blockStart, blockOffset, this.fields, this.pCtx);
            }
            case 32768: {
                return new WhileNode(this.expr, condStart, condOffset, blockStart, blockOffset, this.fields, this.pCtx);
            }
            case 16384: {
                return new UntilNode(this.expr, condStart, condOffset, blockStart, blockOffset, this.fields, this.pCtx);
            }
            case 65536: {
                return new DoNode(this.expr, condStart, condOffset, blockStart, blockOffset, this.fields, this.pCtx);
            }
            case 131072: {
                return new DoUntilNode(this.expr, condStart, condOffset, blockStart, blockOffset, this.pCtx);
            }
        }
        return new WithNode(this.expr, condStart, condOffset, blockStart, blockOffset, this.fields, this.pCtx);
    }

    private ASTNode captureCodeBlock(int type) {
        boolean cond = true;
        ASTNode first = null;
        ASTNode tk = null;
        switch (type) {
            case 2048: {
                do {
                    if (tk != null) {
                        this.captureToNextTokenJunction();
                        this.skipWhitespace();
                        boolean bl = cond = this.expr[this.cursor] != '{' && this.expr[this.cursor] == 'i' && this.expr[++this.cursor] == 'f' && this.expr[this.cursor = this.incNextNonBlank()] == '(';
                    }
                    if (((IfNode)(tk = this._captureBlock(tk, this.expr, cond, type))).getElseBlock() != null) {
                        ++this.cursor;
                        return first;
                    }
                    if (first == null) {
                        first = tk;
                    }
                    if (this.cursor == this.end || this.expr[this.cursor] == ';') continue;
                    ++this.cursor;
                } while (this.ifThenElseBlockContinues());
                return first;
            }
            case 65536: {
                this.skipWhitespace();
                return this._captureBlock(null, this.expr, false, type);
            }
        }
        this.captureToNextTokenJunction();
        this.skipWhitespace();
        return this._captureBlock(null, this.expr, true, type);
    }

    private ASTNode _captureBlock(ASTNode node, char[] expr, boolean cond, int type) {
        int blockEnd;
        int blockStart;
        this.skipWhitespace();
        int startCond = 0;
        int endCond = 0;
        switch (type) {
            case 100: {
                int st = this.cursor;
                this.captureToNextTokenJunction();
                if (this.cursor == this.end) {
                    throw new CompileException("unexpected end of statement", expr, st);
                }
                String name = ParseTools.createStringTrimmed(expr, st, this.cursor - st);
                if (ParseTools.isReservedWord(name) || ParseTools.isNotValidNameorLabel(name)) {
                    throw new CompileException("illegal function name or use of reserved word", expr, this.cursor);
                }
                if (this.pCtx == null) {
                    this.pCtx = this.getParserContext();
                }
                FunctionParser parser = new FunctionParser(name, this.cursor, this.end - this.cursor, expr, this.fields, this.pCtx, this.splitAccumulator);
                Function function = parser.parse();
                this.cursor = parser.getCursor();
                this.lastNode = function;
                return this.lastNode;
            }
            case 48: {
                if (ProtoParser.isUnresolvedWaiting()) {
                    if (this.pCtx == null) {
                        this.pCtx = this.getParserContext();
                    }
                    ProtoParser.checkForPossibleUnresolvedViolations(expr, this.cursor, this.pCtx);
                }
                int st = this.cursor;
                this.captureToNextTokenJunction();
                String name = ParseTools.createStringTrimmed(expr, st, this.cursor - st);
                if (ParseTools.isReservedWord(name) || ParseTools.isNotValidNameorLabel(name)) {
                    throw new CompileException("illegal prototype name or use of reserved word", expr, this.cursor);
                }
                this.cursor = this.nextNonBlank();
                if (expr[this.cursor] != '{') {
                    throw new CompileException("expected '{' but found: " + expr[this.cursor], expr, this.cursor);
                }
                st = this.cursor + 1;
                this.cursor = ParseTools.balancedCaptureWithLineAccounting(expr, st, this.end, '{', this.pCtx);
                if (this.pCtx == null) {
                    this.pCtx = this.getParserContext();
                }
                ProtoParser parser = new ProtoParser(expr, st, this.cursor, name, this.pCtx, this.fields, this.splitAccumulator);
                Proto proto = parser.parse();
                if (this.pCtx == null) {
                    this.pCtx = this.getParserContext();
                }
                this.pCtx.addImport(proto);
                proto.setCursorPosition(st, this.cursor);
                this.cursor = parser.getCursor();
                ProtoParser.notifyForLateResolution(proto);
                this.lastNode = proto;
                return this.lastNode;
            }
            case 101: {
                this.cursor = this.nextNonBlank();
                if (expr[this.cursor] != '{') {
                    throw new CompileException("expected '{' but found: " + expr[this.cursor], expr, this.cursor);
                }
                int st = this.cursor + 1;
                this.cursor = ParseTools.balancedCaptureWithLineAccounting(expr, st, this.end, '{', this.pCtx);
                if (this.pCtx == null) {
                    this.pCtx = this.getParserContext();
                }
                Stacklang stacklang = new Stacklang(expr, st, this.cursor - st, this.fields, this.pCtx);
                ++this.cursor;
                this.lastNode = stacklang;
                return this.lastNode;
            }
        }
        if (cond) {
            if (expr[this.cursor] != '(') {
                throw new CompileException("expected '(' but encountered: " + expr[this.cursor], expr, this.cursor);
            }
            startCond = this.cursor;
            this.cursor = ParseTools.balancedCaptureWithLineAccounting(expr, startCond, this.end, '(', this.pCtx);
            endCond = this.cursor++;
            ++startCond;
        }
        this.skipWhitespace();
        if (this.cursor >= this.end) {
            throw new CompileException("unexpected end of statement", expr, this.end);
        }
        if (expr[this.cursor] == '{') {
            blockStart = this.cursor;
            blockEnd = this.cursor = ParseTools.balancedCaptureWithLineAccounting(expr, blockStart, this.end, '{', this.pCtx);
        } else {
            blockStart = this.cursor - 1;
            this.captureToEOSorEOL();
            blockEnd = this.cursor + 1;
        }
        if (type == 2048) {
            IfNode ifNode = (IfNode)node;
            if (node != null) {
                if (!cond) {
                    this.st = this.trimRight(blockStart + 1);
                    return ifNode.setElseBlock(expr, this.st, this.trimLeft(blockEnd) - this.st, this.pCtx);
                }
                return ifNode.setElseIf((IfNode)this.createBlockToken(startCond, endCond, this.trimRight(blockStart + 1), this.trimLeft(blockEnd), type));
            }
            return this.createBlockToken(startCond, endCond, blockStart + 1, blockEnd, type);
        }
        if (type == 65536) {
            ++this.cursor;
            this.skipWhitespace();
            this.st = this.cursor;
            this.captureToNextTokenJunction();
            String name = new String(expr, this.st, this.cursor - this.st);
            if ("while".equals(name)) {
                this.skipWhitespace();
                startCond = this.cursor + 1;
                endCond = this.cursor = ParseTools.balancedCaptureWithLineAccounting(expr, this.cursor, this.end, '(', this.pCtx);
                return this.createBlockToken(startCond, endCond, this.trimRight(blockStart + 1), this.trimLeft(blockEnd), type);
            }
            if ("until".equals(name)) {
                this.skipWhitespace();
                startCond = this.cursor + 1;
                endCond = this.cursor = ParseTools.balancedCaptureWithLineAccounting(expr, this.cursor, this.end, '(', this.pCtx);
                return this.createBlockToken(startCond, endCond, this.trimRight(blockStart + 1), this.trimLeft(blockEnd), 131072);
            }
            throw new CompileException("expected 'while' or 'until' but encountered: " + name, expr, this.cursor);
        }
        return this.createBlockToken(startCond, endCond, this.trimRight(blockStart + 1), this.trimLeft(blockEnd), type);
    }

    protected boolean ifThenElseBlockContinues() {
        if (this.cursor + 4 < this.end) {
            if (this.expr[this.cursor] != ';') {
                --this.cursor;
            }
            this.skipWhitespace();
            return this.expr[this.cursor] == 'e' && this.expr[this.cursor + 1] == 'l' && this.expr[this.cursor + 2] == 's' && this.expr[this.cursor + 3] == 'e' && (ParseTools.isWhitespace(this.expr[this.cursor + 4]) || this.expr[this.cursor + 4] == '{');
        }
        return false;
    }

    protected boolean tokenContinues() {
        if (this.cursor == this.end) {
            return false;
        }
        if (this.expr[this.cursor] == '.' || this.expr[this.cursor] == '[') {
            return true;
        }
        if (ParseTools.isWhitespace(this.expr[this.cursor])) {
            int markCurrent = this.cursor;
            this.skipWhitespace();
            if (this.cursor != this.end && (this.expr[this.cursor] == '.' || this.expr[this.cursor] == '[')) {
                return true;
            }
            this.cursor = markCurrent;
        }
        return false;
    }

    protected void expectEOS() {
        this.skipWhitespace();
        if (this.cursor != this.end && this.expr[this.cursor] != ';') {
            switch (this.expr[this.cursor]) {
                case '&': {
                    if (this.lookAhead() != '&') break;
                    return;
                }
                case '|': {
                    if (this.lookAhead() != '|') break;
                    return;
                }
                case '!': {
                    if (this.lookAhead() != '=') break;
                    return;
                }
                case '<': 
                case '>': {
                    return;
                }
                case '=': {
                    switch (this.lookAhead()) {
                        case '*': 
                        case '+': 
                        case '-': 
                        case '=': {
                            return;
                        }
                    }
                    break;
                }
                case '*': 
                case '+': 
                case '-': 
                case '/': {
                    if (this.lookAhead() != '=') break;
                    return;
                }
            }
            throw new CompileException("expected end of statement but encountered: " + (this.cursor == this.end ? "<end of stream>" : Character.valueOf(this.expr[this.cursor])), this.expr, this.cursor);
        }
    }

    protected boolean isNextIdentifier() {
        while (this.cursor != this.end && ParseTools.isWhitespace(this.expr[this.cursor])) {
            ++this.cursor;
        }
        return this.cursor != this.end && ParseTools.isIdentifierPart(this.expr[this.cursor]);
    }

    protected void captureToEOS() {
        while (this.cursor != this.end) {
            switch (this.expr[this.cursor]) {
                case '(': 
                case '[': 
                case '{': {
                    this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, this.cursor, this.end, this.expr[this.cursor], this.pCtx);
                    if (this.cursor < this.end) break;
                    return;
                }
                case '\"': 
                case '\'': {
                    this.cursor = ParseTools.captureStringLiteral(this.expr[this.cursor], this.expr, this.cursor, this.end);
                    break;
                }
                case ',': 
                case ';': 
                case '}': {
                    return;
                }
            }
            ++this.cursor;
        }
    }

    protected void captureToEOSorEOL() {
        while (this.cursor != this.end && this.expr[this.cursor] != '\n' && this.expr[this.cursor] != '\r' && this.expr[this.cursor] != ';') {
            ++this.cursor;
        }
    }

    protected void captureIdentifier() {
        boolean captured = false;
        if (this.cursor == this.end) {
            throw new CompileException("unexpected end of statement: EOF", this.expr, this.cursor);
        }
        while (this.cursor != this.end) {
            switch (this.expr[this.cursor]) {
                case ';': {
                    return;
                }
            }
            if (!ParseTools.isIdentifierPart(this.expr[this.cursor])) {
                if (captured) {
                    return;
                }
                throw new CompileException("unexpected symbol (was expecting an identifier): " + this.expr[this.cursor], this.expr, this.cursor);
            }
            captured = true;
            ++this.cursor;
        }
    }

    protected void captureToEOT() {
        this.skipWhitespace();
        block7: do {
            switch (this.expr[this.cursor]) {
                case '(': 
                case '[': 
                case '{': {
                    this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, this.cursor, this.end, this.expr[this.cursor], this.pCtx);
                    if (this.cursor != -1) continue block7;
                    throw new CompileException("unbalanced braces", this.expr, this.cursor);
                }
                case '&': 
                case ',': 
                case ';': 
                case '=': 
                case '|': {
                    return;
                }
                case '.': {
                    this.skipWhitespace();
                    break;
                }
                case '\'': {
                    this.cursor = ParseTools.captureStringLiteral('\'', this.expr, this.cursor, this.end);
                    break;
                }
                case '\"': {
                    this.cursor = ParseTools.captureStringLiteral('\"', this.expr, this.cursor, this.end);
                    break;
                }
                default: {
                    if (!ParseTools.isWhitespace(this.expr[this.cursor])) continue block7;
                    this.skipWhitespace();
                    if (this.cursor < this.end && this.expr[this.cursor] == '.') {
                        if (this.cursor != this.end) {
                            ++this.cursor;
                        }
                        this.skipWhitespace();
                        break;
                    }
                    this.trimWhitespace();
                    return;
                }
            }
        } while (++this.cursor < this.end);
    }

    protected boolean lastNonWhite(char c) {
        int i = this.cursor - 1;
        while (ParseTools.isWhitespace(this.expr[i])) {
            --i;
        }
        return c == this.expr[i];
    }

    protected int trimLeft(int pos) {
        if (pos > this.end) {
            pos = this.end;
        }
        while (pos > 0 && pos >= this.st && (ParseTools.isWhitespace(this.expr[pos - 1]) || this.expr[pos - 1] == ';')) {
            --pos;
        }
        return pos;
    }

    protected int trimRight(int pos) {
        while (pos != this.end && ParseTools.isWhitespace(this.expr[pos])) {
            ++pos;
        }
        return pos;
    }

    protected void skipWhitespace() {
        block9: while (this.cursor != this.end) {
            switch (this.expr[this.cursor]) {
                case '\n': {
                    ++this.line;
                    this.lastLineStart = this.cursor;
                }
                case '\r': {
                    ++this.cursor;
                    continue block9;
                }
                case '/': {
                    if (this.cursor + 1 != this.end) {
                        switch (this.expr[this.cursor + 1]) {
                            case '/': {
                                ++this.cursor;
                                while (this.cursor != this.end && this.expr[this.cursor] != '\n') {
                                    ++this.cursor;
                                }
                                if (this.cursor != this.end) {
                                    // empty if block
                                }
                                ++this.line;
                                this.lastLineStart = ++this.cursor;
                                continue block9;
                            }
                            case '*': {
                                int len = this.end - 1;
                                int st = this.cursor++;
                                while (this.cursor != len && (this.expr[this.cursor] != '*' || this.expr[this.cursor + 1] != '/')) {
                                    ++this.cursor;
                                }
                                if (this.cursor != len) {
                                    this.cursor += 2;
                                }
                                for (int i = st; i < this.cursor; ++i) {
                                    this.expr[i] = 32;
                                }
                                continue block9;
                            }
                        }
                        break block9;
                    }
                }
                default: {
                    if (!ParseTools.isWhitespace(this.expr[this.cursor])) break block9;
                    ++this.cursor;
                    continue block9;
                }
            }
        }
    }

    protected void captureToNextTokenJunction() {
        block5: while (this.cursor != this.end) {
            switch (this.expr[this.cursor]) {
                case '(': 
                case '{': {
                    return;
                }
                case '/': {
                    if (this.expr[this.cursor + 1] == '*') {
                        return;
                    }
                }
                case '[': {
                    this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, this.cursor, this.end, '[', this.pCtx) + 1;
                    continue block5;
                }
            }
            if (ParseTools.isWhitespace(this.expr[this.cursor])) {
                return;
            }
            ++this.cursor;
        }
    }

    protected void trimWhitespace() {
        while (this.cursor != 0 && ParseTools.isWhitespace(this.expr[this.cursor - 1])) {
            --this.cursor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setExpression(String expression) {
        if (expression != null && expression.length() != 0) {
            WeakHashMap<String, char[]> weakHashMap = EX_PRECACHE;
            synchronized (weakHashMap) {
                this.expr = EX_PRECACHE.get(expression);
                if (this.expr == null) {
                    this.expr = expression.toCharArray();
                    this.end = this.length = this.expr.length;
                    while (this.length != 0 && ParseTools.isWhitespace(this.expr[this.length - 1])) {
                        --this.length;
                    }
                    char[] e = new char[this.length];
                    for (int i = 0; i != e.length; ++i) {
                        e[i] = this.expr[i];
                    }
                    EX_PRECACHE.put(expression, e);
                } else {
                    this.end = this.length = this.expr.length;
                }
            }
        }
    }

    protected void setExpression(char[] expression) {
        this.expr = expression;
        this.end = this.length = expression.length;
        while (this.length != 0 && ParseTools.isWhitespace(this.expr[this.length - 1])) {
            --this.length;
        }
    }

    protected char lookToLast() {
        if (this.cursor == this.start) {
            return '\u0000';
        }
        int temp = this.cursor;
        while (temp != this.start && ParseTools.isWhitespace(this.expr[--temp])) {
        }
        return this.expr[temp];
    }

    protected char lookBehind() {
        if (this.cursor == this.start) {
            return '\u0000';
        }
        return this.expr[this.cursor - 1];
    }

    protected char lookAhead() {
        if (this.cursor + 1 != this.end) {
            return this.expr[this.cursor + 1];
        }
        return '\u0000';
    }

    protected char lookAhead(int range) {
        if (this.cursor + range >= this.end) {
            return '\u0000';
        }
        return this.expr[this.cursor + range];
    }

    protected boolean isNextIdentifierOrLiteral() {
        int tmp = this.cursor;
        if (tmp == this.end) {
            return false;
        }
        while (tmp != this.end && ParseTools.isWhitespace(this.expr[tmp])) {
            ++tmp;
        }
        if (tmp == this.end) {
            return false;
        }
        char n = this.expr[tmp];
        return ParseTools.isIdentifierPart(n) || ParseTools.isDigit(n) || n == '\'' || n == '\"';
    }

    public int incNextNonBlank() {
        ++this.cursor;
        return this.nextNonBlank();
    }

    public int nextNonBlank() {
        int i;
        if (this.cursor + 1 >= this.end) {
            throw new CompileException("unexpected end of statement", this.expr, this.st);
        }
        for (i = this.cursor; i != this.end && ParseTools.isWhitespace(this.expr[i]); ++i) {
        }
        return i;
    }

    public void expectNextChar_IW(char c) {
        this.nextNonBlank();
        if (this.cursor == this.end) {
            throw new CompileException("unexpected end of statement", this.expr, this.st);
        }
        if (this.expr[this.cursor] != c) {
            throw new CompileException("unexpected character ('" + this.expr[this.cursor] + "'); was expecting: " + c, this.expr, this.st);
        }
    }

    protected boolean isStatementNotManuallyTerminated() {
        int c;
        if (this.cursor >= this.end) {
            return false;
        }
        for (c = this.cursor; c != this.end && ParseTools.isWhitespace(this.expr[c]); ++c) {
        }
        return c == this.end || this.expr[c] != ';';
    }

    protected ParserContext getParserContext() {
        if (parserContext == null || parserContext.get() == null) {
            this.newContext();
        }
        return parserContext.get();
    }

    public static ParserContext getCurrentThreadParserContext() {
        return AbstractParser.contextControl(3, null, null);
    }

    public static void setCurrentThreadParserContext(ParserContext pCtx) {
        AbstractParser.contextControl(0, pCtx, null);
    }

    public void newContext() {
        AbstractParser.contextControl(0, new ParserContext(), this);
    }

    public void newContext(ParserContext pCtx) {
        this.pCtx = pCtx;
        AbstractParser.contextControl(0, this.pCtx, this);
    }

    public void removeContext() {
        AbstractParser.contextControl(1, null, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParserContext contextControl(int operation, ParserContext pCtx, AbstractParser parser) {
        Runtime runtime = Runtime.getRuntime();
        synchronized (runtime) {
            if (parserContext == null) {
                parserContext = new ThreadLocal();
            }
            switch (operation) {
                case 0: {
                    pCtx.setRootParser(parser);
                    parserContext.set(pCtx);
                    return pCtx;
                }
                case 1: {
                    parserContext.set(null);
                    return null;
                }
                case 3: {
                    if (parserContext.get() == null) {
                        parserContext.set(new ParserContext(parser));
                    }
                }
                case 2: {
                    return parserContext.get();
                }
            }
        }
        return null;
    }

    protected void addFatalError(String message) {
        this.pCtx.addError(new ErrorDetail(this.expr, this.st, true, message));
    }

    protected void addFatalError(String message, int start) {
        this.pCtx.addError(new ErrorDetail(this.expr, start, true, message));
    }

    public static void setLanguageLevel(int level) {
        OPERATORS.clear();
        OPERATORS.putAll(AbstractParser.loadLanguageFeaturesByLevel(level));
    }

    public static HashMap<String, Integer> loadLanguageFeaturesByLevel(int languageLevel) {
        HashMap<String, Integer> operatorsTable = new HashMap<String, Integer>();
        switch (languageLevel) {
            case 6: {
                operatorsTable.put("proto", 48);
            }
            case 5: {
                operatorsTable.put("if", 39);
                operatorsTable.put("else", 40);
                operatorsTable.put("?", 29);
                operatorsTable.put("switch", 44);
                operatorsTable.put("function", 100);
                operatorsTable.put("def", 100);
                operatorsTable.put("stacklang", 101);
            }
            case 4: {
                operatorsTable.put("=", 31);
                operatorsTable.put("var", 98);
                operatorsTable.put("+=", 52);
                operatorsTable.put("-=", 53);
                operatorsTable.put("/=", 55);
                operatorsTable.put("%=", 56);
            }
            case 3: {
                operatorsTable.put("foreach", 38);
                operatorsTable.put("while", 41);
                operatorsTable.put("until", 42);
                operatorsTable.put("for", 43);
                operatorsTable.put("do", 45);
            }
            case 2: {
                operatorsTable.put("return", 99);
                operatorsTable.put(";", 37);
            }
            case 1: {
                operatorsTable.put("+", 0);
                operatorsTable.put("-", 1);
                operatorsTable.put("*", 2);
                operatorsTable.put("**", 5);
                operatorsTable.put("/", 3);
                operatorsTable.put("%", 4);
                operatorsTable.put("==", 18);
                operatorsTable.put("!=", 19);
                operatorsTable.put(">", 15);
                operatorsTable.put(">=", 17);
                operatorsTable.put("<", 14);
                operatorsTable.put("<=", 16);
                operatorsTable.put("&&", 21);
                operatorsTable.put("and", 21);
                operatorsTable.put("||", 22);
                operatorsTable.put("or", 23);
                operatorsTable.put("~=", 24);
                operatorsTable.put("instanceof", 25);
                operatorsTable.put("is", 25);
                operatorsTable.put("contains", 26);
                operatorsTable.put("soundslike", 27);
                operatorsTable.put("strsim", 28);
                operatorsTable.put("convertable_to", 36);
                operatorsTable.put("isdef", 47);
                operatorsTable.put("#", 20);
                operatorsTable.put("&", 6);
                operatorsTable.put("|", 7);
                operatorsTable.put("^", 8);
                operatorsTable.put("<<", 10);
                operatorsTable.put("<<<", 12);
                operatorsTable.put(">>", 9);
                operatorsTable.put(">>>", 11);
                operatorsTable.put("new", 34);
                operatorsTable.put("in", 35);
                operatorsTable.put("with", 46);
                operatorsTable.put("assert", 97);
                operatorsTable.put("import", 96);
                operatorsTable.put("import_static", 95);
                operatorsTable.put("++", 50);
                operatorsTable.put("--", 51);
            }
            case 0: {
                operatorsTable.put(":", 30);
            }
        }
        return operatorsTable;
    }

    public static void resetParserContext() {
        AbstractParser.contextControl(1, null, null);
    }

    protected static boolean isArithmeticOperator(int operator) {
        return operator != -1 && operator < 6;
    }

    protected int arithmeticFunctionReduction(int operator) {
        block25: {
            ASTNode tk = this.nextToken();
            if (tk != null) {
                int operator2 = tk.getOperator();
                if (AbstractParser.isArithmeticOperator(operator2) && Operator.PTABLE[operator2] > Operator.PTABLE[operator]) {
                    this.stk.xswap();
                    tk = this.nextToken();
                    if (this.compileMode && !tk.isLiteral()) {
                        this.splitAccumulator.push(tk, new OperatorNode(operator2, this.expr, this.st));
                        return -2;
                    }
                    operator = operator2;
                    this.dStack.push(operator, tk.getReducedValue(this.ctx, this.ctx, this.variableFactory));
                    while (true) {
                        if ((tk = this.nextToken()) != null && (operator2 = tk.getOperator().intValue()) != -1 && operator2 != 37 && Operator.PTABLE[operator2] > Operator.PTABLE[operator]) {
                            if (this.dStack.isReduceable()) {
                                this.stk.copyx2(this.dStack);
                            }
                            operator = operator2;
                            this.dStack.push(operator, this.nextToken().getReducedValue(this.ctx, this.ctx, this.variableFactory));
                            continue;
                        }
                        if (tk != null && operator2 != -1 && operator2 != 37) {
                            if (Operator.PTABLE[operator2] == Operator.PTABLE[operator]) {
                                if (!this.dStack.isEmpty()) {
                                    this.dreduce();
                                } else {
                                    while (this.stk.isReduceable()) {
                                        this.stk.xswap_op();
                                    }
                                }
                                operator = operator2;
                                this.dStack.push(operator, this.nextToken().getReducedValue(this.ctx, this.ctx, this.variableFactory));
                                continue;
                            }
                            while (this.dStack.size() > 1) {
                                this.dreduce();
                            }
                            operator = tk.getOperator();
                            while (this.stk.size() != 1 && this.stk.peek2() instanceof Integer && (operator2 = ((Integer)this.stk.peek2()).intValue()) < Operator.PTABLE.length && Operator.PTABLE[operator2] >= Operator.PTABLE[operator]) {
                                this.stk.xswap_op();
                            }
                        } else {
                            if (this.dStack.size() > 1) {
                                this.dreduce();
                            }
                            if (this.stk.isReduceable()) {
                                this.stk.xswap();
                            }
                            break block25;
                        }
                        tk = this.nextToken();
                        if (tk == null) continue;
                        switch (operator) {
                            case 21: {
                                if (!this.stk.peekBoolean().booleanValue()) {
                                    return -1;
                                }
                                this.splitAccumulator.add(tk);
                                return 21;
                            }
                            case 22: {
                                if (this.stk.peekBoolean().booleanValue()) {
                                    return -1;
                                }
                                this.splitAccumulator.add(tk);
                                return 22;
                            }
                        }
                        this.stk.push(operator, tk.getReducedValue(this.ctx, this.ctx, this.variableFactory));
                    }
                }
                if (!tk.isOperator()) {
                    throw new CompileException("unexpected token: " + tk.getName(), this.expr, this.st);
                }
                this.reduce();
                this.splitAccumulator.push(tk);
            }
        }
        if (this.stk.isReduceable()) {
            while (true) {
                this.reduce();
                if (!this.stk.isReduceable()) break;
                this.stk.xswap();
            }
        }
        return 0;
    }

    private void dreduce() {
        this.stk.copy2(this.dStack);
        this.stk.op();
    }

    protected void reduce() {
        try {
            int operator = (Integer)this.stk.pop();
            switch (operator) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    this.stk.op(operator);
                    break;
                }
                case 21: {
                    Object v1 = this.stk.pop();
                    this.stk.push((Boolean)this.stk.pop() != false && (Boolean)v1 != false);
                    break;
                }
                case 22: {
                    Object v1 = this.stk.pop();
                    this.stk.push((Boolean)this.stk.pop() != false || (Boolean)v1 != false);
                    break;
                }
                case 23: {
                    Object v1 = this.stk.pop();
                    Object v2 = this.stk.pop();
                    if (!PropertyTools.isEmpty(v2) || !PropertyTools.isEmpty(v1)) {
                        this.stk.clear();
                        this.stk.push(!PropertyTools.isEmpty(v2) ? v2 : v1);
                        return;
                    }
                    this.stk.push(null);
                    break;
                }
                case 24: {
                    this.stk.push(Pattern.compile(String.valueOf(this.stk.pop())).matcher(String.valueOf(this.stk.pop())).matches());
                    break;
                }
                case 25: {
                    this.stk.push(((Class)this.stk.pop()).isInstance(this.stk.pop()));
                    break;
                }
                case 36: {
                    this.stk.push(DataConversion.canConvert(this.stk.peek2().getClass(), (Class)this.stk.pop2()));
                    break;
                }
                case 26: {
                    this.stk.push(ParseTools.containsCheck(this.stk.peek2(), this.stk.pop2()));
                    break;
                }
                case 6: {
                    this.stk.push(AbstractParser.asInt(this.stk.peek2()) & AbstractParser.asInt(this.stk.pop2()));
                    break;
                }
                case 7: {
                    this.stk.push(AbstractParser.asInt(this.stk.peek2()) | AbstractParser.asInt(this.stk.pop2()));
                    break;
                }
                case 8: {
                    this.stk.push(AbstractParser.asInt(this.stk.peek2()) ^ AbstractParser.asInt(this.stk.pop2()));
                    break;
                }
                case 10: {
                    this.stk.push(AbstractParser.asInt(this.stk.peek2()) << AbstractParser.asInt(this.stk.pop2()));
                    break;
                }
                case 12: {
                    int iv2 = AbstractParser.asInt(this.stk.peek2());
                    if (iv2 < 0) {
                        iv2 *= -1;
                    }
                    this.stk.push(iv2 << AbstractParser.asInt(this.stk.pop2()));
                    break;
                }
                case 9: {
                    this.stk.push(AbstractParser.asInt(this.stk.peek2()) >> AbstractParser.asInt(this.stk.pop2()));
                    break;
                }
                case 11: {
                    this.stk.push(AbstractParser.asInt(this.stk.peek2()) >>> AbstractParser.asInt(this.stk.pop2()));
                    break;
                }
                case 27: {
                    this.stk.push(Soundex.soundex(String.valueOf(this.stk.pop())).equals(Soundex.soundex(String.valueOf(this.stk.pop()))));
                    break;
                }
                case 28: {
                    this.stk.push(Float.valueOf(ParseTools.similarity(String.valueOf(this.stk.pop()), String.valueOf(this.stk.pop()))));
                }
            }
        }
        catch (ClassCastException e) {
            throw new CompileException("syntax error or incompatable types", this.expr, this.st, e);
        }
        catch (ArithmeticException e) {
            throw new CompileException("arithmetic error: " + e.getMessage(), this.expr, this.st, e);
        }
        catch (Exception e) {
            throw new CompileException("failed to subEval expression", this.expr, this.st, e);
        }
    }

    @Override
    public int getCursor() {
        return this.cursor;
    }

    @Override
    public char[] getExpression() {
        return this.expr;
    }

    private static int asInt(Object o) {
        return (Integer)o;
    }

    public void setPCtx(ParserContext pCtx) {
        this.pCtx = pCtx;
        this.debugSymbols = this.pCtx.isDebugSymbols();
    }

    static {
        AbstractParser.setupParser();
    }
}

