/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.core;

import java.io.Serializable;
import java.util.HashMap;
import junit.framework.TestCase;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.util.SharedVariableSpaceModel;
import org.mvel2.util.SimpleVariableSpaceModel;
import org.mvel2.util.VariableSpaceCompiler;

public class IndexedVariablesTests
extends TestCase {
    public void testVariableInjection1() {
        String[] varNames = new String[]{"x", "y", "z"};
        Object[] values = new Object[]{10, 20, 30};
        String expr = "foo = -1; res = x + y + z;\nif (x > 9) {\n   res = z - y - x;\n   int k = 5;\n   foo = k;}; \nfor (i = 0; i < 5000; i++) { foo++; }; foo;";
        ParserContext ctx = ParserContext.create();
        ctx.addIndexedInput(varNames);
        ctx.setIndexAllocation(true);
        SharedVariableSpaceModel model = VariableSpaceCompiler.compileShared((String)expr, (ParserContext)ctx, (Object[])values);
        Serializable indexCompile = MVEL.compileExpression((String)expr, (ParserContext)ctx);
        Serializable dynamicCompile = MVEL.compileExpression((String)expr, (ParserContext)ParserContext.create());
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("x", 10);
        map.put("y", 20);
        map.put("z", 30);
        IndexedVariablesTests.assertEquals((Object)MVEL.executeExpression((Object)dynamicCompile, map), (Object)MVEL.executeExpression((Object)indexCompile, (VariableResolverFactory)model.createFactory()));
    }

    public void testVariableInjection2() {
        String[] varNames = new String[]{"x", "y", "z"};
        Object[] values = new Object[]{10, 20, 30};
        String expr = "foo = -1; res = x + y + z;\nif (x > 9) {\n   res = z - y - x;\n   int k = 5;\n   foo = k;}; \nfor (i = 0; i < 100000; i++) { foo++; }; foo;";
        ParserContext ctx = ParserContext.create();
        ctx.addIndexedInput(varNames);
        ctx.setIndexAllocation(true);
        SimpleVariableSpaceModel model = VariableSpaceCompiler.compile((String)expr, (ParserContext)ctx);
        Serializable indexCompile = MVEL.compileExpression((String)expr, (ParserContext)ctx);
        Serializable dynamicCompile = MVEL.compileExpression((String)expr, (ParserContext)ParserContext.create());
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("x", 10);
        map.put("y", 20);
        map.put("z", 30);
        IndexedVariablesTests.assertEquals((Object)MVEL.executeExpression((Object)dynamicCompile, map), (Object)MVEL.executeExpression((Object)indexCompile, (VariableResolverFactory)model.createFactory(values)));
    }

    public void testVariableInjection3() {
        String[] varNames = new String[]{"x", "y", "z"};
        Object[] values = new Object[]{10, 20, 30};
        String expr = "def add(a,b) { a + b }; foo = -1; res = x + y + z;\nif (x > 9) {\n   res = z - y - x;\n   int k = 5;\n   foo = add(5,10);}; \nfor (i = 0; i < 100000; i++) { foo++; }; foo;";
        ParserContext ctx = ParserContext.create();
        ctx.addIndexedInput(varNames);
        ctx.setIndexAllocation(true);
        SimpleVariableSpaceModel model = VariableSpaceCompiler.compile((String)expr, (ParserContext)ctx);
        Serializable indexCompile = MVEL.compileExpression((String)expr, (ParserContext)ctx);
        Serializable dynamicCompile = MVEL.compileExpression((String)expr, (ParserContext)ParserContext.create());
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("x", 10);
        map.put("y", 20);
        map.put("z", 30);
        IndexedVariablesTests.assertEquals((Object)MVEL.executeExpression((Object)dynamicCompile, map), (Object)MVEL.executeExpression((Object)indexCompile, (VariableResolverFactory)model.createFactory(values)));
    }
}

