/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.core;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.mvel2.MVEL;
import org.mvel2.PropertyAccessor;
import org.mvel2.asm.MethodVisitor;
import org.mvel2.integration.GlobalListenerFactory;
import org.mvel2.integration.Listener;
import org.mvel2.integration.PropertyHandler;
import org.mvel2.integration.PropertyHandlerFactory;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.optimizers.impl.asm.ProducesBytecode;
import org.mvel2.tests.core.res.Bar;
import org.mvel2.tests.core.res.Base;
import org.mvel2.tests.core.res.Foo;

public class PropertyHandlerTests
extends TestCase {
    Base base = new Base();

    protected void setUp() throws Exception {
        PropertyHandlerFactory.registerPropertyHandler(List.class, (PropertyHandler)new TestPropertyHandler());
    }

    protected void tearDown() throws Exception {
        GlobalListenerFactory.disposeAll();
        PropertyHandlerFactory.disposeAll();
    }

    public void testListPropertyHandler() {
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
        PropertyHandlerTests.assertEquals((Object)"gotcalled", (Object)PropertyAccessor.get((String)"list[0]", (Object)this.base));
        PropertyAccessor.set((Object)this.base, (String)"list[0]", (Object)"hey you");
        PropertyHandlerTests.assertEquals((String)"set", (String)this.base.list.get(0));
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = false;
    }

    public void testListPropertyHandler2() {
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
        Serializable s = MVEL.compileSetExpression((String)"list[0]");
        MVEL.executeSetExpression((Serializable)s, (Object)new Base(), (Object)"hey you");
        Base b = new Base();
        MVEL.executeSetExpression((Serializable)s, (Object)b, (Object)"hey you");
        PropertyHandlerTests.assertEquals((String)"set", (String)b.list.get(0));
    }

    public void testListPropertyHandler3() {
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        Serializable s = MVEL.compileSetExpression((String)"list[0]");
        MVEL.executeSetExpression((Serializable)s, (Object)new Base(), (Object)"hey you");
        Base b = new Base();
        MVEL.executeSetExpression((Serializable)s, (Object)b, (Object)"hey you");
        PropertyHandlerTests.assertEquals((String)"set", (String)b.list.get(0));
    }

    public void testListPropertyHandler4() {
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        final String[] res = new String[1];
        GlobalListenerFactory.registerGetListener((Listener)new Listener(){

            public void onEvent(Object context, String contextName, VariableResolverFactory variableFactory, Object value) {
                System.out.println("Listener Fired:" + contextName);
                res[0] = contextName;
            }
        });
        Serializable s = MVEL.compileSetExpression((String)"list[0]");
        MVEL.executeSetExpression((Serializable)s, (Object)new Base(), (Object)"hey you");
        res[0] = null;
        Base b = new Base();
        MVEL.executeSetExpression((Serializable)s, (Object)b, (Object)"hey you");
        PropertyHandlerTests.assertEquals((String)"set", (String)b.list.get(0));
        PropertyHandlerTests.assertEquals((String)"list", (String)res[0]);
    }

    public void testNullPropertyHandler() {
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        PropertyHandlerFactory.setNullPropertyHandler((PropertyHandler)new PropertyHandler(){

            public Object getProperty(String name, Object contextObj, VariableResolverFactory variableFactory) {
                return "NULL";
            }

            public Object setProperty(String name, Object contextObj, VariableResolverFactory variableFactory, Object value) {
                return "NULL";
            }
        });
        Foo foo = new Foo();
        Bar bar = foo.getBar();
        foo.setBar(null);
        HashMap<String, Foo> map = new HashMap<String, Foo>();
        map.put("foo", foo);
        Serializable s = MVEL.compileExpression((String)"foo.bar");
        PropertyHandlerTests.assertEquals((Object)"NULL", (Object)MVEL.executeExpression((Object)s, map));
        PropertyHandlerTests.assertEquals((Object)"NULL", (Object)MVEL.executeExpression((Object)s, map));
        foo.setBar(bar);
        PropertyHandlerTests.assertEquals((Object)bar, (Object)MVEL.executeExpression((Object)s, map));
    }

    public void testNullPropertyHandler2() {
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        PropertyHandlerFactory.setNullPropertyHandler((PropertyHandler)new PropertyHandler(){

            public Object getProperty(String name, Object contextObj, VariableResolverFactory variableFactory) {
                return "NULL";
            }

            public Object setProperty(String name, Object contextObj, VariableResolverFactory variableFactory, Object value) {
                return "NULL";
            }
        });
        Foo foo = new Foo();
        Bar bar = foo.getBar();
        foo.setBar(null);
        HashMap<String, Foo> map = new HashMap<String, Foo>();
        map.put("foo", foo);
        Serializable s = MVEL.compileExpression((String)"foo.bar");
        PropertyHandlerTests.assertEquals((Object)"NULL", (Object)MVEL.executeExpression((Object)s, map));
        PropertyHandlerTests.assertEquals((Object)"NULL", (Object)MVEL.executeExpression((Object)s, map));
        foo.setBar(bar);
        PropertyHandlerTests.assertEquals((Object)bar, (Object)MVEL.executeExpression((Object)s, map));
    }

    public void testMapPropertyHandler() {
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
        PropertyHandlerFactory.registerPropertyHandler(Map.class, (PropertyHandler)new PropertyHandler(){

            public Object getProperty(String name, Object contextObj, VariableResolverFactory variableFactory) {
                Assert.assertNotNull((Object)contextObj);
                Assert.assertEquals((String)"'key'", (String)name);
                Assert.assertTrue((boolean)(contextObj instanceof Map));
                return "gotcalled";
            }

            public Object setProperty(String name, Object contextObj, VariableResolverFactory variableFactory, Object value) {
                Assert.assertNotNull((Object)contextObj);
                Assert.assertEquals((String)"'key'", (String)name);
                Assert.assertTrue((boolean)(contextObj instanceof Map));
                ((Map)contextObj).put("key", "set");
                return null;
            }
        });
        PropertyHandlerTests.assertEquals((Object)"gotcalled", (Object)PropertyAccessor.get((String)"funMap['key']", (Object)this.base));
        PropertyAccessor.set((Object)this.base, (String)"funMap['key']", (Object)"hey you");
        PropertyHandlerTests.assertEquals((Object)"set", this.base.funMap.get("key"));
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = false;
    }

    public void testArrayPropertyHandler() {
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
        PropertyHandlerFactory.registerPropertyHandler(Array.class, (PropertyHandler)new PropertyHandler(){

            public Object getProperty(String name, Object contextObj, VariableResolverFactory variableFactory) {
                Assert.assertNotNull((Object)contextObj);
                Assert.assertEquals((String)"0", (String)name);
                Assert.assertTrue((boolean)contextObj.getClass().isArray());
                return "gotcalled";
            }

            public Object setProperty(String name, Object contextObj, VariableResolverFactory variableFactory, Object value) {
                Assert.assertNotNull((Object)contextObj);
                Assert.assertEquals((String)"0", (String)name);
                Assert.assertTrue((boolean)contextObj.getClass().isArray());
                Array.set(contextObj, 0, "set");
                return null;
            }
        });
        PropertyHandlerTests.assertEquals((Object)"gotcalled", (Object)PropertyAccessor.get((String)"stringArray[0]", (Object)this.base));
        PropertyAccessor.set((Object)this.base, (String)"stringArray[0]", (Object)"hey you");
        PropertyHandlerTests.assertEquals((String)"set", (String)this.base.stringArray[0]);
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = false;
    }

    public void testSetListListener() {
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
        class MyListener
        implements Listener {
            public int counter;

            MyListener() {
            }

            public void onEvent(Object context, String contextName, VariableResolverFactory variableFactory, Object value) {
                ++this.counter;
            }
        }
        MyListener listener = new MyListener();
        GlobalListenerFactory.registerGetListener((Listener)listener);
        class MyBean {
            private List someList;

            MyBean() {
            }

            public List getSomeList() {
                return this.someList;
            }
        }
        MVEL.getProperty((String)"someList", (Object)new MyBean());
        MVEL.getProperty((String)"someList", (Object)new MyBean());
        PropertyHandlerTests.assertEquals((int)2, (int)listener.counter);
    }

    public void _testListener() {
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
        class MyListener
        implements Listener {
            public int count;

            MyListener() {
            }

            public void onEvent(Object context, String contextName, VariableResolverFactory variableFactory, Object value) {
                ++this.count;
            }
        }
        MyListener listener = new MyListener();
        GlobalListenerFactory.registerGetListener((Listener)listener);
        PropertyHandlerFactory.setNullPropertyHandler((PropertyHandler)new PropertyHandler(){

            public Object getProperty(String name, Object contextObj, VariableResolverFactory variableFactory) {
                ArrayList<Foo> someList = new ArrayList<Foo>();
                someList.add(new Foo());
                return someList;
            }

            public Object setProperty(String name, Object contextObj, VariableResolverFactory variableFactory, Object value) {
                return null;
            }
        });
        PropertyHandlerFactory.registerPropertyHandler(List.class, (PropertyHandler)new PropertyHandler(){

            public Object getProperty(String name, Object contextObj, VariableResolverFactory variableFactory) {
                List list = (List)contextObj;
                int index = Integer.valueOf(name);
                while (index >= list.size()) {
                    list.add(new Foo());
                }
                return list.get(index);
            }

            public Object setProperty(String name, Object contextObj, VariableResolverFactory variableFactory, Object value) {
                return null;
            }
        });
        Foo foo = new Foo();
        Serializable fooExpr0 = MVEL.compileSetExpression((String)"collectionTest[0].name");
        Serializable fooExpr1 = MVEL.compileSetExpression((String)"collectionTest[1].name");
        MVEL.executeSetExpression((Serializable)fooExpr0, (Object)foo, (Object)"John Galt");
        MVEL.executeSetExpression((Serializable)fooExpr1, (Object)foo, (Object)"The Joker");
        PropertyHandlerTests.assertEquals((int)2, (int)listener.count);
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = false;
    }

    public void testPropertyHandlerSetting() {
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
        PropertyHandlerFactory.registerPropertyHandler(WorkObject.class, (PropertyHandler)new WebPropertyHandler());
        HashMap<String, WorkObject> vars = new HashMap<String, WorkObject>();
        WorkObject wo = new WorkObject();
        vars.put("wobj", wo);
        MVEL.setProperty(vars, (String)"wobj.foo", (Object)"foobie");
        PropertyHandlerTests.assertEquals((Object)"foobie", (Object)wo.getFieldValue("foo"));
    }

    public class WebPropertyHandler
    implements PropertyHandler {
        public Object getProperty(String arg0, Object arg1, VariableResolverFactory arg2) {
            WorkObject wob = (WorkObject)arg1;
            if (wob.hasFieldName(arg0)) {
                return wob.getFieldValue(arg0);
            }
            return null;
        }

        public Object setProperty(String arg0, Object arg1, VariableResolverFactory arg2, Object arg3) {
            WorkObject wob = (WorkObject)arg1;
            wob.setFieldValue(arg0, arg3, true);
            return arg3;
        }
    }

    public class WorkObject {
        Map<String, Object> map = new HashMap<String, Object>();

        public boolean hasFieldName(String name) {
            return this.map.containsKey(name);
        }

        public Object getFieldValue(String name) {
            return this.map.get(name);
        }

        public void setFieldValue(String name, Object value, boolean bool) {
            this.map.put(name, value);
        }
    }

    public class TestPropertyHandler
    implements PropertyHandler,
    ProducesBytecode {
        public Object getProperty(String name, Object contextObj, VariableResolverFactory variableFactory) {
            Assert.assertNotNull((Object)contextObj);
            Assert.assertEquals((String)"0", (String)name);
            Assert.assertTrue((boolean)(contextObj instanceof List));
            return "gotcalled";
        }

        public Object setProperty(String name, Object contextObj, VariableResolverFactory variableFactory, Object value) {
            Assert.assertNotNull((Object)contextObj);
            Assert.assertEquals((String)"0", (String)name);
            Assert.assertTrue((boolean)(contextObj instanceof List));
            ((List)contextObj).set(0, "set");
            return null;
        }

        public void produceBytecodeGet(MethodVisitor mv, String propertyName, VariableResolverFactory factory) {
            mv.visitLdcInsn((Object)"gotcalled");
        }

        public void produceBytecodePut(MethodVisitor mv, String propertyName, VariableResolverFactory factory) {
            mv.visitTypeInsn(192, "java/util/List");
            mv.visitInsn(3);
            mv.visitLdcInsn((Object)"set");
            mv.visitMethodInsn(185, "java/util/List", "set", "(ILjava/lang/Object;)Ljava/lang/Object;");
            mv.visitInsn(87);
            mv.visitInsn(1);
        }
    }
}

