/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.perftests;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.HashMap;
import org.mvel2.MVEL;
import org.mvel2.optimizers.dynamic.DynamicOptimizer;
import org.mvel2.util.ParseTools;
import org.mvel2.util.QuickSort;

public class SimpleTests {
    private static final double COUNT = 30000.0;
    private static int tg = 0;

    public static void main(String[] args) throws IOException {
        PrintStream ps = System.out;
        try {
            for (int i = 0; i < 10000; ++i) {
                SimpleTests.testQuickSortMVEL(ps);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.setOut(ps);
    }

    private static void testQuickSortMVEL(PrintStream ps) throws IOException {
        double time = System.currentTimeMillis();
        char[] sourceFile = ParseTools.loadFromFile((File)new File("samples/scripts/quicksort.mvel"));
        Serializable c = MVEL.compileExpression((char[])sourceFile);
        HashMap vars = new HashMap();
        DecimalFormat dc = new DecimalFormat("#.##");
        for (int a = 0; a < 10000; ++a) {
            vars.clear();
            MVEL.executeExpression((Object)c, vars);
        }
        time = (double)System.currentTimeMillis() - time;
        ps.println("Result: " + time);
        ps.println("Rate  : " + 30000.0 / (time / 1000.0) + " per second.");
        ps.println("FreeMem: " + dc.format((double)Runtime.getRuntime().freeMemory() / 1048576.0) + "MB / TotalMem: " + dc.format((double)Runtime.getRuntime().totalMemory() / 1048576.0) + "MB");
        ps.println("TotalGarbaged: " + DynamicOptimizer.totalRecycled);
    }

    private static void testQuickSortNative(PrintStream ps) {
        double time = System.currentTimeMillis();
        int i = 0;
        while ((double)i < 30000.0) {
            QuickSort.quickSort(new int[]{50, 20, 21, 209, 10, 77, 8, 9, 55, 73, 41, 99});
            ++i;
        }
        time = (double)System.currentTimeMillis() - time;
        ps.println("Result: " + time);
        ps.println("Rate  : " + 30000.0 / (time / 1000.0) + " per second.");
    }
}

