/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.perftests;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.junit.Test;
import org.mvel2.MVEL;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.tests.core.res.PojoStatic;

public class SetterAccessorConcurrencyTest
extends TestCase {
    private static final Serializable EXPRESSION = MVEL.compileExpression((String)"pojo.value = 2");

    @Test(timeout=10000L)
    public void testDynamic() throws Exception {
        OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.DYNAMIC);
        MVEL.executeExpression((Object)EXPRESSION, SetterAccessorConcurrencyTest.prepareContext());
        this.internalConcurrentEvaluation();
    }

    private void internalConcurrentEvaluation() throws Exception {
        int N = 20;
        final CountDownLatch start = new CountDownLatch(1);
        final CountDownLatch end = new CountDownLatch(20);
        final AtomicInteger errors = new AtomicInteger(0);
        for (int i = 0; i < 20; ++i) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        HashMap vars = SetterAccessorConcurrencyTest.prepareContext();
                        start.await();
                        MVEL.executeExpression((Object)EXPRESSION, (Map)vars);
                    }
                    catch (Exception e) {
                        errors.incrementAndGet();
                    }
                    finally {
                        end.countDown();
                    }
                }
            }, "thread-eval-" + i).start();
        }
        start.countDown();
        SetterAccessorConcurrencyTest.assertEquals((String)"Test did not complete withing 10s", (boolean)true, (boolean)end.await(10L, TimeUnit.SECONDS));
        if (errors.get() > 0) {
            SetterAccessorConcurrencyTest.fail();
        }
    }

    private static HashMap<Object, Object> prepareContext() {
        HashMap<Object, Object> vars = new HashMap<Object, Object>();
        vars.put("pojo", new PojoStatic("1"));
        return vars;
    }
}

