import { WasmLibrary } from "./wasm-library.js";
/**
 * Base 91 WASM library, similar to Base 64 but uses more characters resulting in smaller strings.
 *
 * See [Base91](https://base91.sourceforge.net/) for more details.
 *
 * ```ts
 * import { Base91 } from "@hpcc-js/wasm/base91";
 *
 * const base91 = await Base91.load();
 *
 * const encoded_data = await base91.encode(data);
 * const decoded_data = await base91.decode(encoded_data);
 * ```
 */
export declare class Base91 extends WasmLibrary {
    private constructor();
    /**
     * Compiles and instantiates the raw wasm.
     *
     * ::: info
     * In general WebAssembly compilation is disallowed on the main thread if the buffer size is larger than 4KB, hence forcing `load` to be asynchronous;
     * :::
     *
     * @returns A promise to an instance of the Base91 class.
     */
    static load(): Promise<Base91>;
    /**
     * Unloades the compiled wasm instance.
     */
    static unload(): void;
    /**
     * @returns The Base91 c++ version
     */
    version(): string;
    /**
     * @param data Data to encode.
     * @returns string containing the Base 91 encoded data
     */
    encode(data: Uint8Array): string;
    /**
     *
     * @param base91Str encoded string
     * @returns origonal data
     */
    decode(base91Str: string): Uint8Array;
}
//# sourceMappingURL=base91.d.ts.map