export type PTR = number;
export interface HeapU8 {
    ptr: PTR;
    size: number;
}
/**
 * Base class to simplify moving data into and out of Wasm memory.
 */
export declare class WasmLibrary {
    protected _module: any;
    protected _exports: any;
    protected constructor(_module: any, _export: any);
    protected malloc_heapu8(size: number): HeapU8;
    protected free_heapu8(data: HeapU8): void;
    protected uint8_heapu8(data: Uint8Array): HeapU8;
    protected heapu8_view(data: HeapU8): Uint8Array;
    protected heapu8_uint8(data: HeapU8): Uint8Array;
    protected string_heapu8(str: string): HeapU8;
    protected heapu8_string(data: HeapU8): string;
}
//# sourceMappingURL=wasm-library.d.ts.map