# @vaadin/icon

A web component for displaying SVG icons.

[Documentation + Live Demo ↗](https://vaadin.com/docs/latest/ds/foundation/icons)

[![npm version](https://badgen.net/npm/v/@vaadin/icon)](https://www.npmjs.com/package/@vaadin/icon)
[![Discord](https://img.shields.io/discord/732335336448852018?label=discord)](https://discord.gg/PHmkCKC)

```html
<vaadin-icon name="vaadin:user"></vaadin-icon>
```

## Installation

Install the component:

```sh
npm i @vaadin/icon
```

Once installed, import the component in your application:

```js
import '@vaadin/icon';
```

## Themes

Vaadin components come with two built-in [themes](https://vaadin.com/docs/latest/styling), Lumo and Material.
The [main entrypoint](https://github.com/vaadin/web-components/blob/master/packages/icon/vaadin-icon.js) of the package uses the Lumo theme.

To use the Material theme, import the component from the `theme/material` folder:

```js
import '@vaadin/icon/theme/material/vaadin-icon.js';
```

You can also import the Lumo version of the component explicitly:

```js
import '@vaadin/icon/theme/lumo/vaadin-icon.js';
```

Finally, you can import the un-themed component from the `src` folder to get a minimal starting point:

```js
import '@vaadin/icon/src/vaadin-icon.js';
```

## Contributing

Read the [contributing guide](https://vaadin.com/docs/latest/contributing/overview) to learn about our development process, how to propose bugfixes and improvements, and how to test your changes to Vaadin components.

## License

Apache License 2.0

Vaadin collects usage statistics at development time to improve this product.
For details and to opt-out, see https://github.com/vaadin/vaadin-usage-statistics.
