/**
 * Register a CSS custom property if it’s not already registered.
 * @param {string} property - Property name.
 * @param {Object} [meta] - Property definition.
 * @param {string} [meta.syntax] - Property syntax.
 * @param {boolean} [meta.inherits] - Whether the property inherits.
 * @param {*} [meta.initialValue] - Initial value.
 */
export default function gentleRegisterProperty(property: string, meta?: {
    syntax?: string;
    inherits?: boolean;
    initialValue?: any;
}, window?: typeof globalThis): void;
