/**
 * Check if a CSS custom property is registered.
 * This function will return `false` for custom properties that behave identically to non-registered properties (e.g., registered inherited properties with syntax "*").
 * @param {string} property - The property to check.
 * @param {Window} [window] - The window to check in.
 * @returns {boolean}
 */
export default function isRegisteredProperty(property: string, window?: Window): boolean;
