/*
 * Decompiled with CFR 0.152.
 */
package org.mvnsearch.chatgpt.model.completion.chat;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mvnsearch.chatgpt.model.completion.chat.ChatFunction;
import org.mvnsearch.chatgpt.model.completion.chat.ChatMessage;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ChatCompletionRequest {
    private String model;
    private List<ChatMessage> messages;
    private Double temperature;
    private Integer n;
    @JsonProperty(value="top_p")
    private Double topP;
    private Boolean stream;
    private List<String> stop;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="presence_penalty")
    private Double presencePenalty;
    @JsonProperty(value="frequency_penalty")
    private Double frequencyPenalty;
    @JsonProperty(value="logit_bias")
    private Map<String, Integer> logitBias;
    private String user;
    private List<ChatFunction> functions;
    @JsonIgnore
    private List<String> functionNames;
    @JsonProperty(value="function_call")
    private Object functionCall;

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Integer getN() {
        return this.n;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public List<ChatMessage> getMessages() {
        return this.messages;
    }

    public void setMessages(List<ChatMessage> messages) {
        this.messages = messages;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public void setStream(Boolean stream) {
        this.stream = stream;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public void setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public void setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    public Map<String, Integer> getLogitBias() {
        return this.logitBias;
    }

    public void setLogitBias(Map<String, Integer> logitBias) {
        this.logitBias = logitBias;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public List<ChatFunction> getFunctions() {
        return this.functions;
    }

    public void setFunctions(List<ChatFunction> functions) {
        this.functions = functions;
    }

    public Object getFunctionCall() {
        return this.functionCall;
    }

    public void setFunctionCall(Object functionCall) {
        this.functionCall = functionCall.equals("auto") || functionCall.equals("none") ? functionCall : (functionCall instanceof String ? Map.of("name", functionCall) : functionCall);
    }

    public List<String> getFunctionNames() {
        return this.functionNames;
    }

    public void setFunctionNames(List<String> functionNames) {
        this.functionNames = functionNames;
    }

    public void addFunction(String functionName) {
        if (this.functionNames == null) {
            this.functionNames = new ArrayList<String>();
        }
        this.functionNames.add(functionName);
    }

    public void addFunction(ChatFunction function) {
        if (this.functions == null) {
            this.functions = new ArrayList<ChatFunction>();
        }
        this.functions.add(function);
    }

    public void updateModelWithFunctionSupport() {
        if (!(this.functionNames == null && this.functions == null || this.model.endsWith("-0613"))) {
            this.model = this.model + "-0613";
        }
    }

    public static ChatCompletionRequest of(@Nonnull String userMessage) {
        return ChatCompletionRequest.of(null, userMessage, null);
    }

    public static ChatCompletionRequest functions(@Nonnull String userMessage, List<String> functionNames) {
        ChatCompletionRequest request = new ChatCompletionRequest();
        request.setFunctionNames(functionNames);
        request.addMessage(ChatMessage.userMessage(userMessage));
        return request;
    }

    public static ChatCompletionRequest of(String systemMessage, @Nonnull String userMessage, String assistantMessage) {
        ChatCompletionRequest request = new ChatCompletionRequest();
        if (systemMessage != null && !systemMessage.isEmpty()) {
            request.addMessage(ChatMessage.systemMessage(systemMessage));
        }
        request.addMessage(ChatMessage.userMessage(userMessage));
        if (assistantMessage != null && !assistantMessage.isEmpty()) {
            request.addMessage(ChatMessage.assistantMessage(assistantMessage));
        }
        return request;
    }

    public void addMessage(ChatMessage message) {
        if (this.messages == null) {
            this.messages = new ArrayList<ChatMessage>();
        }
        this.messages.add(message);
    }
}

