/*
 * Decompiled with CFR 0.152.
 */
package org.mvnsearch.chatgpt.model.completion.chat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mvnsearch.chatgpt.model.completion.chat.ChatCompletionRequest;
import org.mvnsearch.chatgpt.model.completion.chat.ChatFunction;
import org.mvnsearch.chatgpt.model.completion.chat.ChatMessage;

public class ChatRequestBuilder {
    private final ChatCompletionRequest request = new ChatCompletionRequest();

    public static ChatRequestBuilder of(String userMessage) {
        return new ChatRequestBuilder().userMessage(userMessage);
    }

    public static ChatRequestBuilder of(String systemMessage, String userMessage) {
        return new ChatRequestBuilder().systemMessage(systemMessage).userMessage(userMessage);
    }

    public ChatRequestBuilder model(String model) {
        this.request.setModel(model);
        return this;
    }

    public ChatRequestBuilder gpt4() {
        this.request.setModel("gpt-4");
        return this;
    }

    public ChatRequestBuilder temperature(Double temperature) {
        this.request.setTemperature(temperature);
        return this;
    }

    public ChatRequestBuilder n(Integer n) {
        this.request.setN(n);
        return this;
    }

    public ChatRequestBuilder maxTokens(Integer maxTokens) {
        this.request.setMaxTokens(maxTokens);
        return this;
    }

    public ChatRequestBuilder topP(Double topP) {
        this.request.setTopP(topP);
        return this;
    }

    public ChatRequestBuilder stream(Boolean stream) {
        this.request.setStream(stream);
        return this;
    }

    public ChatRequestBuilder stop(String stop) {
        if (this.request.getStop() == null) {
            this.request.setStop(new ArrayList<String>());
        }
        this.request.getStop().add(stop);
        return this;
    }

    public ChatRequestBuilder stop(List<String> stop) {
        this.request.setStop(stop);
        return this;
    }

    public ChatRequestBuilder presencePenalty(Double presencePenalty) {
        this.request.setPresencePenalty(presencePenalty);
        return this;
    }

    public ChatRequestBuilder frequencyPenalty(Double frequencyPenalty) {
        this.request.setFrequencyPenalty(frequencyPenalty);
        return this;
    }

    public ChatRequestBuilder logitBias(String name, Integer bias) {
        if (this.request.getLogitBias() == null) {
            this.request.setLogitBias(new HashMap<String, Integer>());
        }
        this.request.getLogitBias().put(name, bias);
        return this;
    }

    public ChatRequestBuilder logitBias(Map<String, Integer> logitBias) {
        this.request.setLogitBias(logitBias);
        return this;
    }

    public ChatRequestBuilder endUser(String userId) {
        this.request.setUser(userId);
        return this;
    }

    public ChatRequestBuilder systemMessage(String content) {
        this.request.addMessage(ChatMessage.assistantMessage(content));
        return this;
    }

    public ChatRequestBuilder userMessage(String content) {
        this.request.addMessage(ChatMessage.userMessage(content));
        return this;
    }

    public ChatRequestBuilder assistantMessage(String content) {
        this.request.addMessage(ChatMessage.assistantMessage(content));
        return this;
    }

    public ChatRequestBuilder messages(List<ChatMessage> messages) {
        this.request.setMessages(messages);
        return this;
    }

    public ChatRequestBuilder function(String functionName) {
        this.request.addFunction(functionName);
        return this;
    }

    public ChatRequestBuilder function(ChatFunction function) {
        this.request.addFunction(function);
        return this;
    }

    public ChatRequestBuilder functionCall(String name) {
        this.request.setFunctionCall(name);
        return this;
    }

    public ChatCompletionRequest build() {
        return this.request;
    }
}

