/*
 * Decompiled with CFR 0.152.
 */
package org.mvnsearch.chatgpt.spring.client;

import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.mvnsearch.chatgpt.model.ChatCompletion;
import org.mvnsearch.chatgpt.model.Completion;
import org.mvnsearch.chatgpt.model.GPTExchange;
import org.mvnsearch.chatgpt.model.completion.chat.ChatCompletionRequest;
import org.mvnsearch.chatgpt.model.completion.chat.ChatCompletionResponse;
import org.mvnsearch.chatgpt.model.completion.chat.ChatMessage;
import org.mvnsearch.chatgpt.model.completion.completion.CompletionRequest;
import org.mvnsearch.chatgpt.model.completion.completion.CompletionResponse;
import org.mvnsearch.chatgpt.model.function.GPTFunctionUtils;
import org.mvnsearch.chatgpt.spring.service.ChatGPTService;
import org.mvnsearch.chatgpt.spring.service.PromptManager;

class GPTExchangeMethodInterceptor
implements MethodInterceptor {
    private final ChatGPTService chatGPTService;
    private final PromptManager promptManager;
    private final GPTExchange gptExchangeAnnotation;

    GPTExchangeMethodInterceptor(ChatGPTService chatGPTService, PromptManager promptManager, Class<?> interfaceClass) {
        this.chatGPTService = chatGPTService;
        this.promptManager = promptManager;
        this.gptExchangeAnnotation = interfaceClass.getAnnotation(GPTExchange.class);
    }

    public String formatChatMessage(String role, String content, Object[] args) {
        if (args != null && args.length > 0) {
            if (content.contains("{") && content.contains("}")) {
                content = args.length == 1 && args[0].getClass().isRecord() ? MessageFormat.format(content, GPTFunctionUtils.convertRecordToArray(args[0])) : MessageFormat.format(content, args);
            } else if (Objects.equals(role, "user")) {
                StringBuilder sb = new StringBuilder(content);
                for (Object arg : args) {
                    if (arg == null) continue;
                    sb.append(" ").append(arg);
                }
                content = sb.toString();
            }
        }
        return content;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        Object[] args = invocation.getArguments();
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
        String[] functions = null;
        ChatCompletion chatCompletionAnnotation = method.getAnnotation(ChatCompletion.class);
        Completion completionAnnotation = method.getAnnotation(Completion.class);
        if (completionAnnotation != null) {
            CompletionRequest request = new CompletionRequest();
            request.setModel(completionAnnotation.model());
            Object prompt = (String)args[0];
            if (!completionAnnotation.value().isEmpty()) {
                prompt = completionAnnotation.value() + (String)prompt;
            }
            request.setPrompt((String)prompt);
            return this.chatGPTService.complete(request).map(CompletionResponse::getReplyText);
        }
        if (chatCompletionAnnotation != null) {
            String assistantMessage;
            functions = chatCompletionAnnotation.functions();
            userMessage = chatCompletionAnnotation.value();
            userMessage = userMessage.isEmpty() && !chatCompletionAnnotation.userTemplate().isEmpty() ? this.promptManager.prompt(chatCompletionAnnotation.userTemplate(), args) : this.formatChatMessage("user", userMessage, args);
            messages.add(ChatMessage.userMessage(userMessage));
            String systemMessage = chatCompletionAnnotation.system();
            if (systemMessage.isEmpty() && !chatCompletionAnnotation.systemTemplate().isEmpty()) {
                systemMessage = this.promptManager.prompt(chatCompletionAnnotation.systemTemplate(), args);
            } else if (!systemMessage.isEmpty()) {
                systemMessage = this.formatChatMessage("system", systemMessage, args);
            }
            if (!systemMessage.isEmpty()) {
                messages.add(ChatMessage.systemMessage(systemMessage));
            }
            if ((assistantMessage = chatCompletionAnnotation.assistant()).isEmpty() && !chatCompletionAnnotation.assistantTemplate().isEmpty()) {
                assistantMessage = this.promptManager.prompt(chatCompletionAnnotation.assistantTemplate(), args);
            } else if (!assistantMessage.isEmpty()) {
                assistantMessage = this.formatChatMessage("assistant", assistantMessage, args);
            }
            if (!assistantMessage.isEmpty()) {
                messages.add(ChatMessage.assistantMessage(assistantMessage));
            }
        } else {
            userMessage = method.getName();
            userMessage = userMessage.replaceAll("([A-Z])", " $1").trim();
            messages.add(ChatMessage.userMessage(userMessage));
        }
        ChatCompletionRequest request = new ChatCompletionRequest();
        request.setMessages(messages);
        if (this.gptExchangeAnnotation != null) {
            if (functions == null || functions.length == 0) {
                functions = this.gptExchangeAnnotation.functions();
            }
            if (!this.gptExchangeAnnotation.value().isEmpty()) {
                request.setModel(this.gptExchangeAnnotation.value());
            }
            if (this.gptExchangeAnnotation.temperature() >= 0.0) {
                request.setTemperature(this.gptExchangeAnnotation.temperature());
            }
            if (this.gptExchangeAnnotation.maxTokens() > 0) {
                request.setMaxTokens(this.gptExchangeAnnotation.maxTokens());
            }
            if (this.gptExchangeAnnotation.value() != null && !this.gptExchangeAnnotation.value().isEmpty()) {
                request.setModel(this.gptExchangeAnnotation.value());
            }
            if (functions == null || functions.length == 0) {
                functions = this.gptExchangeAnnotation.functions();
            }
        }
        if (functions != null && functions.length > 0) {
            request.setFunctionNames(Arrays.stream(functions).toList());
            return this.chatGPTService.chat(request).flatMap(ChatCompletionResponse::getReplyCombinedText);
        }
        return this.chatGPTService.chat(request).map(ChatCompletionResponse::getReplyText);
    }
}

