/*
 * Decompiled with CFR 0.152.
 */
package org.mvnsearch.chatgpt.spring.service;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.mvnsearch.chatgpt.model.function.GPTFunctionUtils;
import org.mvnsearch.chatgpt.spring.service.PromptManager;
import org.mvnsearch.chatgpt.spring.service.PromptStore;

class PromptManagerImpl
implements PromptManager {
    private final Map<String, String> allPrompts = new HashMap<String, String>();

    PromptManagerImpl(List<PromptStore> promptStores) throws Exception {
        for (PromptStore promptStore : promptStores) {
            this.allPrompts.putAll(promptStore.readAll());
        }
    }

    @Override
    public String prompt(@PropertyKey(resourceBundle="prompts") @PropertyKey(resourceBundle="prompts") String key, Object ... params) {
        if (this.allPrompts.containsKey(key)) {
            String prompt = this.allPrompts.get(key);
            if (params != null && params.length > 0 && prompt.indexOf(123) >= 0) {
                if (params.length == 1) {
                    Object obj = params[0];
                    if (obj instanceof List) {
                        List list = (List)obj;
                        prompt = MessageFormat.format(prompt, list.toArray());
                    } else {
                        prompt = obj.getClass().isRecord() ? MessageFormat.format(prompt, GPTFunctionUtils.convertRecordToArray(obj)) : MessageFormat.format(prompt, obj);
                    }
                } else {
                    prompt = MessageFormat.format(prompt, params);
                }
            }
            return prompt;
        }
        return "!!!" + key + "!!!";
    }

    @Override
    public Map<String, String> getAllPrompts() {
        return this.allPrompts;
    }

    @Override
    @Nullable
    public String getRawPrompt(String key) {
        return this.allPrompts.get(key);
    }

    @Override
    public boolean containsPrompt(String key) {
        return this.allPrompts.containsKey(key);
    }
}

