/*
 * Decompiled with CFR 0.152.
 */
package org.mvnsearch.chatgpt.spring.service;

import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.mvnsearch.chatgpt.spring.service.PromptStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.UrlResource;

class PromptPropertiesStoreImpl
implements PromptStore {
    private static final Logger log = LoggerFactory.getLogger(PromptPropertiesStoreImpl.class);

    PromptPropertiesStoreImpl() {
    }

    @Override
    public Map<String, String> readAll() {
        HashMap<String, String> prompts = new HashMap<String, String>();
        try {
            Properties properties = new Properties();
            Enumeration<URL> promptURLs = this.getClass().getClassLoader().getResources("prompts.properties");
            while (promptURLs.hasMoreElements()) {
                InputStream stream = promptURLs.nextElement().openStream();
                try {
                    properties.load(stream);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                String promptText = value.toString();
                try {
                    prompts.put(key.toString(), this.resolvePromptText(promptText));
                }
                catch (Exception e) {
                    log.error("Failed to resolve prompt text: " + promptText, (Throwable)e);
                }
            }));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return prompts;
    }

    public String resolvePromptText(String value) throws Exception {
        if (value.startsWith("classpath://")) {
            ClassPathResource resource = new ClassPathResource(value.substring(12));
            return new String(resource.getContentAsByteArray(), StandardCharsets.UTF_8);
        }
        if (value.startsWith("http://") || value.startsWith("https://")) {
            UrlResource resource = new UrlResource(value);
            return new String(resource.getContentAsByteArray(), StandardCharsets.UTF_8);
        }
        return value;
    }
}

