/*
 * Decompiled with CFR 0.152.
 */
package org.mvnsearch.h2.mysql;

import java.util.Arrays;
import java.util.zip.CRC32;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.RandomUtils;

public class EncryptionFunctions {
    public static String hex(byte[] text) {
        return Hex.encodeHexString((byte[])text);
    }

    public static byte[] unhex(String text) throws Exception {
        return Hex.decodeHex((String)text);
    }

    public static String password(byte[] text) throws Exception {
        return "*" + EncryptionFunctions.sha1(EncryptionFunctions.unhex(EncryptionFunctions.sha1(text)));
    }

    public static String base64(String text) throws Exception {
        return Base64.encodeBase64String((byte[])text.getBytes());
    }

    public static String unbase64(String text) throws Exception {
        return new String(Base64.decodeBase64((byte[])text.getBytes()));
    }

    public static String md5(String text) {
        return DigestUtils.md5Hex((String)text);
    }

    public static String sha1(byte[] text) {
        return DigestUtils.sha1Hex((byte[])text);
    }

    public static String sha(byte[] text) {
        return EncryptionFunctions.sha1(text);
    }

    public static String sha2(byte[] text, Integer hashLength) throws Exception {
        if (hashLength == 0 || hashLength == 256) {
            return DigestUtils.sha256Hex((byte[])text);
        }
        if (hashLength == 224) {
            return new DigestUtils("SHA-224").digestAsHex(text);
        }
        if (hashLength == 384) {
            return DigestUtils.sha384Hex((byte[])text);
        }
        if (hashLength == 512) {
            return DigestUtils.sha512Hex((byte[])text);
        }
        return null;
    }

    public static byte[] randomBytes(Integer length) {
        if (length > 0 && length < 1024) {
            return RandomUtils.nextBytes((int)length);
        }
        return null;
    }

    public static byte[] aesEncrypt(byte[] text, byte[] password) throws Exception {
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, EncryptionFunctions.generateSecretKey(password));
        return cipher.doFinal(text);
    }

    public static Long crc32(String text) {
        if (text == null) {
            return null;
        }
        byte[] bytes = text.getBytes();
        CRC32 checksum = new CRC32();
        checksum.update(bytes, 0, bytes.length);
        return checksum.getValue();
    }

    public static byte[] createDigest(String digestType, String text) {
        return new DigestUtils(digestType.replace("SHA", "SHA-")).digest(text);
    }

    public static String aesDecrypt(byte[] content, byte[] password) throws Exception {
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, EncryptionFunctions.generateSecretKey(password));
        return new String(cipher.doFinal(content));
    }

    private static SecretKey generateSecretKey(byte[] password) {
        return new SecretKeySpec(Arrays.copyOfRange(DigestUtils.sha1((byte[])password), 0, 16), "AES");
    }
}

