/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.toolchain;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.toolchain.FoojayService;
import org.apache.maven.plugins.toolchain.ToolchainsRequirement;
import org.apache.maven.toolchain.MisconfiguredToolchainException;
import org.apache.maven.toolchain.ToolchainManagerPrivate;
import org.apache.maven.toolchain.ToolchainPrivate;
import org.apache.maven.toolchain.java.DefaultJavaToolChain;
import org.apache.maven.toolchain.model.ToolchainModel;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;

@Mojo(name="toolchain", defaultPhase=LifecyclePhase.VALIDATE, configurator="toolchains-requirement-configurator", threadSafe=true)
public class ToolchainMojo
extends AbstractMojo {
    private static final Object LOCK = new Object();
    @Component
    private ToolchainManagerPrivate toolchainManagerPrivate;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(required=true)
    private ToolchainsRequirement toolchains;
    @Parameter(property="skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String toolchainsSkip = System.getProperty("toolchain.skip");
        if (toolchainsSkip != null) {
            this.skip = Boolean.parseBoolean(toolchainsSkip);
        }
        if (this.skip) {
            this.getLog().info((CharSequence)"toolchain plugin skipped.");
            return;
        }
        if (this.toolchains == null) {
            this.getLog().warn((CharSequence)"No toolchains requirements configured.");
            return;
        }
        ArrayList<String> nonMatchedTypes = new ArrayList<String>();
        for (Map.Entry<String, Map<String, String>> entry : this.toolchains.getToolchains().entrySet()) {
            String type = entry.getKey();
            if (this.selectToolchain(type, entry.getValue())) continue;
            nonMatchedTypes.add(type);
        }
        if (!nonMatchedTypes.isEmpty()) {
            StringBuilder buff = new StringBuilder();
            buff.append("Cannot find matching toolchain definitions for the following toolchain types:");
            for (String type : nonMatchedTypes) {
                buff.append(System.lineSeparator());
                buff.append(this.getToolchainRequirementAsString(type, this.toolchains.getParams(type)));
            }
            this.getLog().error((CharSequence)buff.toString());
            throw new MojoFailureException(buff.toString() + System.lineSeparator() + "Please make sure you define the required toolchains in your ~/.m2/toolchains.xml file.");
        }
    }

    protected String getToolchainRequirementAsString(String type, Map<String, String> params) {
        StringBuilder buff = new StringBuilder();
        buff.append(type).append(" [");
        if (params.size() == 0) {
            buff.append(" any");
        } else {
            for (Map.Entry<String, String> param : params.entrySet()) {
                buff.append(" ").append(param.getKey()).append("='").append(param.getValue());
                buff.append("'");
            }
        }
        buff.append(" ]");
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean selectToolchain(String type, Map<String, String> params) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Required toolchain: " + this.getToolchainRequirementAsString(type, params)));
        int typeFound = 0;
        ToolchainPrivate toolchain = null;
        try {
            ToolchainPrivate[] tcs;
            for (ToolchainPrivate tc : tcs = this.getToolchains(type)) {
                if (!type.equals(tc.getType())) continue;
                ++typeFound;
                if (!tc.matchesRequirements(params)) continue;
                this.getLog().info((CharSequence)("Found matching toolchain for type " + type + ": " + tc));
                Object object = LOCK;
                synchronized (object) {
                    this.toolchainManagerPrivate.storeToolchainToBuildContext(tc, this.session);
                }
                toolchain = tc;
                break;
            }
        }
        catch (MisconfiguredToolchainException ex) {
            throw new MojoExecutionException("Misconfigured toolchains.", (Exception)((Object)ex));
        }
        if (toolchain == null && type.equalsIgnoreCase("jdk")) {
            Path userHome;
            Path jbangHome;
            String version = params.get("version");
            String vendor = params.get("vendor");
            if (vendor == null || vendor.isEmpty()) {
                vendor = "oracle_open_jdk";
            }
            if (vendor.equalsIgnoreCase("oracle_open_jdk") && (jbangHome = (userHome = Paths.get(System.getProperty("user.home"), new String[0])).resolve(".jbang")).toFile().exists()) {
                toolchain = this.findJdkFromJbang(jbangHome, version, vendor);
            }
            if (toolchain == null) {
                toolchain = this.autoInstallJdk(version, vendor);
            }
        }
        if (toolchain != null) {
            this.toolchainManagerPrivate.storeToolchainToBuildContext(toolchain, this.session);
            return true;
        }
        this.getLog().error((CharSequence)("No toolchain " + (typeFound == 0 ? "found" : "matched from " + typeFound + " found") + " for type " + type));
        return false;
    }

    private ToolchainPrivate[] getToolchains(String type) throws MojoExecutionException, MisconfiguredToolchainException {
        return this.toolchainManagerPrivate.getToolchainsForType(type, this.session);
    }

    private ToolchainPrivate autoInstallJdk(String version, String vendor) {
        FoojayService foojayService = new FoojayService(this.getLog(), this.session.getSettings().getActiveProxy());
        try {
            Path jdkHome = foojayService.downloadAndExtractJdk(version, vendor);
            if (jdkHome != null) {
                return this.addJDKToToolchains(jdkHome, version, vendor);
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Failed to download and install JDK", (Throwable)e);
        }
        return null;
    }

    private ToolchainPrivate findJdkFromJbang(Path jbangHome, String version, String vendor) {
        try {
            Path jdkHome;
            String majorVersion = version;
            if (majorVersion.contains(".")) {
                majorVersion = version.startsWith("1.") ? "8" : version.substring(0, version.indexOf("."));
            }
            if (!(jdkHome = jbangHome.resolve("cache").resolve("jdks").resolve(majorVersion)).toFile().exists()) {
                System.out.println("jbang install " + majorVersion);
                String jbangCmd = jbangHome.resolve("bin").resolve("jbang").toAbsolutePath().toString();
                if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                    jbangCmd = jbangHome.resolve("bin").resolve("jbang.cmd").toAbsolutePath().toString();
                }
                Process process = new ProcessBuilder(jbangCmd, "jdk", "install", majorVersion).start();
                process.waitFor();
            }
            return this.addJDKToToolchains(jdkHome, version, vendor);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Failed to find JDK from jbang", (Throwable)e);
            return null;
        }
    }

    private ToolchainPrivate addJDKToToolchains(Path jdkHome, String version, String vendor) throws Exception {
        ToolchainPrivate javaToolChain = this.buildJdkToolchain(version, vendor, jdkHome.toAbsolutePath().toString());
        File toolchainsXml = new File(new File(System.getProperty("user.home")), ".m2/toolchains.xml");
        Xpp3Dom toolchainsDom = toolchainsXml.exists() ? Xpp3DomBuilder.build((Reader)new FileReader(toolchainsXml)) : new Xpp3Dom("toolchains");
        toolchainsDom.addChild(this.jdkToolchainDom(version, vendor, jdkHome.toAbsolutePath().toString()));
        FileWriter writer = new FileWriter(toolchainsXml);
        Xpp3DomWriter.write((Writer)writer, (Xpp3Dom)toolchainsDom);
        writer.close();
        return javaToolChain;
    }

    private ToolchainPrivate buildJdkToolchain(String version, String vendor, String jdkHome) {
        ToolchainModel toolchainModel = new ToolchainModel();
        toolchainModel.setType("jdk");
        Properties provides = new Properties();
        provides.setProperty("version", version);
        provides.setProperty("vendor", vendor);
        toolchainModel.setProvides(provides);
        Xpp3Dom configuration = new Xpp3Dom("configuration");
        configuration.addChild(this.createElement("jdkHome", jdkHome));
        toolchainModel.setConfiguration((Object)configuration);
        DefaultJavaToolChain javaToolChain = new DefaultJavaToolChain(toolchainModel, (Logger)new ConsoleLogger());
        javaToolChain.setJavaHome(jdkHome);
        return javaToolChain;
    }

    private Xpp3Dom jdkToolchainDom(String version, String vendor, String jdkHome) {
        Xpp3Dom toolchainDom = new Xpp3Dom("toolchain");
        toolchainDom.addChild(this.createElement("type", "jdk"));
        Xpp3Dom providesDom = new Xpp3Dom("provides");
        providesDom.addChild(this.createElement("version", version));
        providesDom.addChild(this.createElement("vendor", vendor));
        Xpp3Dom configurationDom = new Xpp3Dom("configuration");
        configurationDom.addChild(this.createElement("jdkHome", jdkHome));
        toolchainDom.addChild(providesDom);
        toolchainDom.addChild(configurationDom);
        return toolchainDom;
    }

    private Xpp3Dom createElement(String name, String value) {
        Xpp3Dom dom = new Xpp3Dom(name);
        dom.setValue(value);
        return dom;
    }
}

