/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.caches.ehcache;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.cache.CacheException;

public final class EhcacheCache
implements Cache {
    private static final CacheManager CACHE_MANAGER = CacheManager.create();
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final String id;

    public EhcacheCache(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Cache instances require an ID");
        }
        this.id = id;
        if (!CACHE_MANAGER.cacheExists(this.id)) {
            CACHE_MANAGER.addCache(this.id);
        }
    }

    public void clear() {
        this.getCache().removeAll();
    }

    public String getId() {
        return this.id;
    }

    public Object getObject(Object key) {
        try {
            Element cachedElement = this.getCache().get(key);
            if (cachedElement == null) {
                return null;
            }
            return cachedElement.getObjectValue();
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    public int getSize() {
        try {
            return this.getCache().getSize();
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public void putObject(Object key, Object value) {
        try {
            this.getCache().put(new Element(key, value));
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public Object removeObject(Object key) {
        try {
            Object obj = this.getObject(key);
            this.getCache().remove(key);
            return obj;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    private Ehcache getCache() {
        return CACHE_MANAGER.getCache(this.id);
    }

    private CacheConfiguration getCacheConfiguration() {
        return this.getCache().getCacheConfiguration();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cache)) {
            return false;
        }
        Cache otherCache = (Cache)obj;
        return this.id.equals(otherCache.getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "EHCache {" + this.id + "}";
    }

    public void setTimeToIdleSeconds(long timeToIdleSeconds) {
        this.getCacheConfiguration().setTimeToIdleSeconds(timeToIdleSeconds);
    }

    public void setTimeToLiveSeconds(long timeToLiveSeconds) {
        this.getCacheConfiguration().setTimeToLiveSeconds(timeToLiveSeconds);
    }

    public void setMaxEntriesLocalHeap(long maxEntriesLocalHeap) {
        this.getCacheConfiguration().setMaxEntriesLocalHeap(maxEntriesLocalHeap);
    }

    public void setMaxEntriesLocalDisk(long maxEntriesLocalDisk) {
        this.getCacheConfiguration().setMaxEntriesLocalDisk(maxEntriesLocalDisk);
    }

    public void setMemoryStoreEvictionPolicy(String memoryStoreEvictionPolicy) {
        this.getCacheConfiguration().setMemoryStoreEvictionPolicy(memoryStoreEvictionPolicy);
    }
}

