/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.cdi;

import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.interceptor.Interceptor;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.mybatis.cdi.LocalTransactionInterceptor;
import org.mybatis.cdi.Transactional;

@Transactional
@Interceptor
public class JtaTransactionInterceptor
extends LocalTransactionInterceptor {
    private static final long serialVersionUID = 1L;
    @Inject
    private transient Instance<UserTransaction> userTransaction;

    @Override
    protected boolean isTransactionActive() throws SystemException {
        return ((UserTransaction)this.userTransaction.get()).getStatus() != 6;
    }

    @Override
    protected void beginJta() throws NotSupportedException, SystemException {
        ((UserTransaction)this.userTransaction.get()).begin();
    }

    @Override
    protected void endJta(boolean isExternaTransaction, boolean needsRollback) throws SystemException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
        if (isExternaTransaction) {
            if (needsRollback) {
                ((UserTransaction)this.userTransaction.get()).setRollbackOnly();
            }
        } else if (needsRollback) {
            ((UserTransaction)this.userTransaction.get()).rollback();
        } else {
            ((UserTransaction)this.userTransaction.get()).commit();
        }
    }
}

