/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.ibatis.io.ResolverUtil;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionManager;
import org.mybatis.guice.Preconditions;
import org.mybatis.guice.mappers.MapperProvider;
import org.mybatis.guice.session.SqlSessionManagerProvider;
import org.mybatis.guice.transactional.Transactional;
import org.mybatis.guice.transactional.TransactionalMethodInterceptor;

abstract class AbstractMyBatisModule
extends AbstractModule {
    protected static final AbstractMatcher<Method> DECLARED_BY_OBJECT = new AbstractMatcher<Method>(){

        public boolean matches(Method method) {
            return method.getDeclaringClass() == Object.class;
        }
    };
    protected static final AbstractMatcher<Method> SYNTHETIC = new AbstractMatcher<Method>(){

        public boolean matches(Method method) {
            return method.isSynthetic();
        }
    };
    private ClassLoader resourcesClassLoader = this.getDefaultClassLoader();
    private ClassLoader driverClassLoader = this.getDefaultClassLoader();

    AbstractMyBatisModule() {
    }

    protected static Set<Class<?>> getClasses(String packageName) {
        return AbstractMyBatisModule.getClasses((ResolverUtil.Test)new ResolverUtil.IsA(Object.class), packageName);
    }

    protected static Set<Class<?>> getClasses(ResolverUtil.Test test, String packageName) {
        Preconditions.checkArgument(test != null, "Parameter 'test' must not be null");
        Preconditions.checkArgument(packageName != null, "Parameter 'packageName' must not be null");
        return new ResolverUtil().find(test, packageName).getClasses();
    }

    protected final void configure() {
        try {
            this.bind(SqlSessionManager.class).toProvider(SqlSessionManagerProvider.class).in(Scopes.SINGLETON);
            this.bind(SqlSession.class).to(SqlSessionManager.class).in(Scopes.SINGLETON);
            this.internalConfigure();
            this.bindTransactionInterceptors();
            this.bind(ClassLoader.class).annotatedWith((Annotation)Names.named((String)"JDBC.driverClassLoader")).toInstance((Object)this.driverClassLoader);
        }
        finally {
            this.resourcesClassLoader = this.getDefaultClassLoader();
            this.driverClassLoader = this.getDefaultClassLoader();
        }
    }

    protected void bindTransactionInterceptors() {
        TransactionalMethodInterceptor interceptor = new TransactionalMethodInterceptor();
        this.requestInjection(interceptor);
        this.bindInterceptor(Matchers.any(), Matchers.not(SYNTHETIC).and(Matchers.not(DECLARED_BY_OBJECT)).and(Matchers.annotatedWith(Transactional.class)), new MethodInterceptor[]{interceptor});
        this.bindInterceptor(Matchers.annotatedWith(Transactional.class), Matchers.not(SYNTHETIC).and(Matchers.not(DECLARED_BY_OBJECT)).and(Matchers.not((Matcher)Matchers.annotatedWith(Transactional.class))), new MethodInterceptor[]{interceptor});
    }

    final <T> void bindMapper(Class<T> mapperType) {
        this.bind(mapperType).toProvider(Providers.guicify(new MapperProvider<T>(mapperType))).in(Scopes.SINGLETON);
    }

    public void useResourceClassLoader(ClassLoader resourceClassLoader) {
        this.resourcesClassLoader = resourceClassLoader;
    }

    protected final ClassLoader getResourceClassLoader() {
        return this.resourcesClassLoader;
    }

    public void useJdbcDriverClassLoader(ClassLoader driverClassLoader) {
        this.driverClassLoader = driverClassLoader;
    }

    private ClassLoader getDefaultClassLoader() {
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    abstract void internalConfigure();

    protected abstract void initialize();
}

