/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice.configuration.settings;

import com.google.inject.Injector;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.session.Configuration;
import org.mybatis.guice.configuration.settings.ConfigurationSetting;

public class ObjectFactoryConfigurationSetting
implements Provider<ConfigurationSetting> {
    @Inject
    private Injector injector;
    private final Class<? extends ObjectFactory> objectFactoryType;

    public ObjectFactoryConfigurationSetting(Class<? extends ObjectFactory> objectFactoryType) {
        this.objectFactoryType = objectFactoryType;
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    public ConfigurationSetting get() {
        final ObjectFactory objectFactory = (ObjectFactory)this.injector.getInstance(this.objectFactoryType);
        return new ConfigurationSetting(){

            @Override
            public void applyConfigurationSetting(Configuration configuration) {
                configuration.setObjectFactory(objectFactory);
            }
        };
    }
}

