/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice.configuration.settings;

import com.google.inject.Injector;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.session.Configuration;
import org.mybatis.guice.configuration.settings.ConfigurationSetting;

public class ObjectWrapperFactoryConfigurationSetting
implements Provider<ConfigurationSetting> {
    @Inject
    private Injector injector;
    private final Class<? extends ObjectWrapperFactory> objectWrapperFactoryType;

    public ObjectWrapperFactoryConfigurationSetting(Class<? extends ObjectWrapperFactory> objectWrapperFactoryType) {
        this.objectWrapperFactoryType = objectWrapperFactoryType;
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    public ConfigurationSetting get() {
        final ObjectWrapperFactory objectWrapperFactory = (ObjectWrapperFactory)this.injector.getInstance(this.objectWrapperFactoryType);
        return new ConfigurationSetting(){

            @Override
            public void applyConfigurationSetting(Configuration configuration) {
                configuration.setObjectWrapperFactory(objectWrapperFactory);
            }
        };
    }
}

