/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice.datasource.dbcp;

import com.google.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;

public final class BasicDataSourceProvider
implements Provider<DataSource> {
    private final BasicDataSource dataSource = new BasicDataSource();

    @jakarta.inject.Inject
    public BasicDataSourceProvider(@Named(value="JDBC.driver") String driver, @Named(value="JDBC.url") String url, @Named(value="JDBC.driverClassLoader") ClassLoader driverClassLoader) {
        this.dataSource.setDriverClassLoader(driverClassLoader);
        this.dataSource.setDriverClassName(driver);
        this.dataSource.setUrl(url);
    }

    @Inject(optional=true)
    public void setUser(@Named(value="JDBC.username") String username) {
        this.dataSource.setUsername(username);
    }

    @Inject(optional=true)
    public void setPassword(@Named(value="JDBC.password") String password) {
        this.dataSource.setPassword(password);
    }

    @Inject(optional=true)
    public void setAutoCommit(@Named(value="JDBC.autoCommit") boolean autoCommit) {
        this.dataSource.setDefaultAutoCommit(Boolean.valueOf(autoCommit));
    }

    @Inject(optional=true)
    public void setDriverProperties(@Named(value="JDBC.driverProperties") Properties driverProperties) {
        for (Map.Entry<Object, Object> property : driverProperties.entrySet()) {
            String name = property.getKey().toString();
            String value = property.getValue().toString();
            this.dataSource.addConnectionProperty(name, value);
        }
    }

    @Inject(optional=true)
    public void setAccessToUnderlyingConnectionAllowed(@Named(value="DBCP.accessToUnderlyingConnectionAllowed") boolean allow) {
        this.dataSource.setAccessToUnderlyingConnectionAllowed(allow);
    }

    @Inject(optional=true)
    public void setDefaultCatalog(@Named(value="DBCP.defaultCatalog") String defaultCatalog) {
        this.dataSource.setDefaultCatalog(defaultCatalog);
    }

    @Inject(optional=true)
    public void setDefaultReadOnly(@Named(value="DBCP.defaultReadOnly") boolean defaultReadOnly) {
        this.dataSource.setDefaultReadOnly(Boolean.valueOf(defaultReadOnly));
    }

    @Inject(optional=true)
    public void setDefaultTransactionIsolation(@Named(value="DBCP.defaultTransactionIsolation") int defaultTransactionIsolation) {
        this.dataSource.setDefaultTransactionIsolation(defaultTransactionIsolation);
    }

    @Inject(optional=true)
    public void setInitialSize(@Named(value="DBCP.initialSize") int initialSize) {
        this.dataSource.setInitialSize(initialSize);
    }

    @Inject(optional=true)
    public void setMaxTotal(@Named(value="DBCP.maxTotal") int maxTotal) {
        this.dataSource.setMaxTotal(maxTotal);
    }

    @Inject(optional=true)
    public void setMaxIdle(@Named(value="DBCP.maxIdle") int maxIdle) {
        this.dataSource.setMaxIdle(maxIdle);
    }

    @Inject(optional=true)
    public void setMaxOpenPreparedStatements(@Named(value="DBCP.maxOpenPreparedStatements") int maxOpenPreparedStatements) {
        this.dataSource.setMaxOpenPreparedStatements(maxOpenPreparedStatements);
    }

    @Inject(optional=true)
    public void setMaxWaitMillis(@Named(value="DBCP.maxWaitMillis") long maxWaitMillis) {
        this.dataSource.setMaxWaitMillis(maxWaitMillis);
    }

    @Inject(optional=true)
    public void setMinEvictableIdleTimeMillis(@Named(value="DBCP.minEvictableIdleTimeMillis") long minEvictableIdleTimeMillis) {
        this.dataSource.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
    }

    @Inject(optional=true)
    public void setMinIdle(@Named(value="DBCP.minIdle") int minIdle) {
        this.dataSource.setMinIdle(minIdle);
    }

    @Inject(optional=true)
    public void setNumTestsPerEvictionRun(@Named(value="DBCP.numTestsPerEvictionRun") int numTestsPerEvictionRun) {
        this.dataSource.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
    }

    @Inject(optional=true)
    public void setPoolPreparedStatements(@Named(value="DBCP.poolPreparedStatements") boolean poolPreparedStatements) {
        this.dataSource.setPoolPreparedStatements(poolPreparedStatements);
    }

    @Inject(optional=true)
    public void setTestOnBorrow(@Named(value="DBCP.testOnBorrow") boolean testOnBorrow) {
        this.dataSource.setTestOnBorrow(testOnBorrow);
    }

    @Inject(optional=true)
    public void setTestOnReturn(@Named(value="DBCP.testOnReturn") boolean testOnReturn) {
        this.dataSource.setTestOnReturn(testOnReturn);
    }

    @Inject(optional=true)
    public void setTestWhileIdle(@Named(value="DBCP.testWhileIdle") boolean testWhileIdle) {
        this.dataSource.setTestWhileIdle(testWhileIdle);
    }

    @Inject(optional=true)
    public void setTimeBetweenEvictionRunsMillis(@Named(value="DBCP.timeBetweenEvictionRunsMillis") int timeBetweenEvictionRunsMillis) {
        this.dataSource.setTimeBetweenEvictionRunsMillis((long)timeBetweenEvictionRunsMillis);
    }

    @Inject(optional=true)
    public void setValidationQuery(@Named(value="DBCP.validationQuery") String validationQuery) {
        this.dataSource.setValidationQuery(validationQuery);
    }

    public DataSource get() {
        return this.dataSource;
    }
}

