/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice.datasource.dbcp;

import com.google.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import javax.sql.ConnectionPoolDataSource;
import org.apache.commons.dbcp2.cpdsadapter.DriverAdapterCPDS;

public final class DriverAdapterCPDSProvider
implements Provider<ConnectionPoolDataSource> {
    private final DriverAdapterCPDS adapter = new DriverAdapterCPDS();

    @jakarta.inject.Inject
    public DriverAdapterCPDSProvider(@Named(value="JDBC.driver") String driver, @Named(value="JDBC.url") String url) {
        try {
            this.adapter.setDriver(driver);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Driver '" + driver + "' not found in the classpath", e);
        }
        this.adapter.setUrl(url);
    }

    @Inject(optional=true)
    public void setUser(@Named(value="JDBC.username") String username) {
        this.adapter.setUser(username);
    }

    @Inject(optional=true)
    public void setPassword(@Named(value="JDBC.password") String password) {
        this.adapter.setPassword(password);
    }

    @Inject(optional=true)
    public void setDescription(@Named(value="DBCP.description") String description) {
        this.adapter.setDescription(description);
    }

    @Inject(optional=true)
    public void setLoginTimeout(@Named(value="JDBC.loginTimeout") int seconds) {
        this.adapter.setLoginTimeout(seconds);
    }

    @Inject(optional=true)
    public void setMaxIdle(@Named(value="DBCP.maxIdle") int maxIdle) {
        this.adapter.setMaxIdle(maxIdle);
    }

    @Inject(optional=true)
    public void setMaxPreparedStatements(@Named(value="DBCP.maxOpenPreparedStatements") int maxPreparedStatements) {
        this.adapter.setMaxPreparedStatements(maxPreparedStatements);
    }

    @Inject(optional=true)
    public void setMinEvictableIdleTimeMillis(@Named(value="DBCP.minEvictableIdleTimeMillis") int minEvictableIdleTimeMillis) {
        this.adapter.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
    }

    @Inject(optional=true)
    public void setNumTestsPerEvictionRun(@Named(value="DBCP.numTestsPerEvictionRun") int numTestsPerEvictionRun) {
        this.adapter.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
    }

    @Inject(optional=true)
    public void setPoolPreparedStatements(@Named(value="DBCP.poolPreparedStatements") boolean poolPreparedStatements) {
        this.adapter.setPoolPreparedStatements(poolPreparedStatements);
    }

    @Inject(optional=true)
    public void setTimeBetweenEvictionRunsMillis(@Named(value="DBCP.timeBetweenEvictionRunsMillis") int timeBetweenEvictionRunsMillis) {
        this.adapter.setTimeBetweenEvictionRunsMillis((long)timeBetweenEvictionRunsMillis);
    }

    public ConnectionPoolDataSource get() {
        return this.adapter;
    }
}

