/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice.transactional;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import org.mybatis.guice.transactional.TransactionToken;

public enum TransactionAttribute {
    MANDATORY{

        @Override
        public TransactionToken begin(TransactionManager man) throws SystemException {
            if (man.getStatus() == 6) {
                throw new IllegalStateException("A call is being made on a method that mandates a transaction but there is no current transaction.");
            }
            return new TransactionToken(man.getTransaction(), null, MANDATORY);
        }
    }
    ,
    NEVER{

        @Override
        public TransactionToken begin(TransactionManager man) throws SystemException {
            if (man.getStatus() == 0) {
                throw new IllegalStateException("A call is being made on a method that forbids a transaction but there is a current transaction.");
            }
            return new TransactionToken(null, null, NEVER);
        }
    }
    ,
    NOTSUPPORTED{

        @Override
        public TransactionToken begin(TransactionManager man) throws SystemException {
            if (man.getStatus() == 0) {
                return new TransactionToken(null, man.suspend(), this);
            }
            return new TransactionToken(null, null, NOTSUPPORTED);
        }

        @Override
        public void finish(TransactionManager man, TransactionToken tranToken) throws SystemException, InvalidTransactionException, IllegalStateException {
            Transaction tran = tranToken.getSuspendedTransaction();
            if (tran != null) {
                man.resume(tran);
            }
        }
    }
    ,
    REQUIRED{

        @Override
        public TransactionToken begin(TransactionManager man) throws SystemException, NotSupportedException {
            if (man.getStatus() == 6) {
                man.begin();
                return new TransactionToken(man.getTransaction(), null, REQUIRED, true);
            }
            return new TransactionToken(man.getTransaction(), null, REQUIRED);
        }

        @Override
        public void finish(TransactionManager man, TransactionToken tranToken) throws SystemException, InvalidTransactionException, IllegalStateException, SecurityException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
            if (tranToken.isCompletionAllowed()) {
                if (man.getStatus() == 1) {
                    man.rollback();
                } else {
                    man.commit();
                }
            }
        }
    }
    ,
    REQUIRESNEW{

        @Override
        public TransactionToken begin(TransactionManager man) throws SystemException, NotSupportedException, InvalidTransactionException, IllegalStateException {
            TransactionToken tranToken = man.getStatus() == 0 ? new TransactionToken(null, man.suspend(), REQUIRESNEW) : new TransactionToken(null, null, REQUIRESNEW);
            try {
                man.begin();
            }
            catch (NotSupportedException | SystemException e) {
                man.resume(tranToken.getSuspendedTransaction());
                throw e;
            }
            tranToken.setActiveTransaction(man.getTransaction());
            tranToken.setCompletionAllowed(true);
            return tranToken;
        }

        @Override
        public void finish(TransactionManager man, TransactionToken tranToken) throws SystemException, InvalidTransactionException, IllegalStateException, SecurityException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
            Transaction tran;
            if (tranToken.isCompletionAllowed()) {
                if (man.getStatus() == 1) {
                    man.rollback();
                } else {
                    man.commit();
                }
            }
            if ((tran = tranToken.getSuspendedTransaction()) != null) {
                man.resume(tran);
            }
        }
    }
    ,
    SUPPORTS{

        @Override
        public TransactionToken begin(TransactionManager man) throws SystemException, NotSupportedException, InvalidTransactionException, IllegalStateException {
            if (man.getStatus() == 0) {
                return new TransactionToken(man.getTransaction(), null, SUPPORTS);
            }
            return new TransactionToken(null, null, SUPPORTS);
        }
    };


    public static TransactionAttribute fromValue(String value) {
        return TransactionAttribute.valueOf(value.toUpperCase());
    }

    public TransactionToken begin(TransactionManager man) throws SystemException, NotSupportedException, InvalidTransactionException, IllegalStateException {
        return null;
    }

    public void finish(TransactionManager man, TransactionToken tranToken) throws SystemException, InvalidTransactionException, IllegalStateException, SecurityException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
    }
}

