/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice.transactional;

import jakarta.ejb.ApplicationException;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.transaction.TransactionManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.XAResource;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.mybatis.guice.transactional.MandatoryTransactionAttributeStrategy;
import org.mybatis.guice.transactional.NeverTransactionAttributeStrategy;
import org.mybatis.guice.transactional.RequiredTransactionAttributeStrategy;
import org.mybatis.guice.transactional.RequiresNewTransactionAttributeStrategy;
import org.mybatis.guice.transactional.SupportsTransactionAttributeStrategy;
import org.mybatis.guice.transactional.TransactionAttribute;
import org.mybatis.guice.transactional.TransactionAttributeStrategy;
import org.mybatis.guice.transactional.TransactionToken;
import org.mybatis.guice.transactional.Transactional;

public class TxTransactionalMethodInterceptor
implements MethodInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());
    @Inject
    private TransactionManager manager;
    @Inject
    private Provider<XAResource> xaResourceProvider;
    private Map<Transactional.TxType, TransactionAttributeStrategy> strategies = new HashMap<Transactional.TxType, TransactionAttributeStrategy>();

    public TxTransactionalMethodInterceptor() {
        this.strategies.put(Transactional.TxType.REQUIRED, new RequiredTransactionAttributeStrategy());
        this.strategies.put(Transactional.TxType.REQUIRES_NEW, new RequiresNewTransactionAttributeStrategy());
        this.strategies.put(Transactional.TxType.MANDATORY, new MandatoryTransactionAttributeStrategy());
        this.strategies.put(Transactional.TxType.SUPPORTS, new SupportsTransactionAttributeStrategy());
        this.strategies.put(Transactional.TxType.NEVER, new NeverTransactionAttributeStrategy());
    }

    private boolean isApplicationExceptionAvailable() {
        try {
            Class.forName("jakarta.ejb.ApplicationException");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private <A extends Annotation> A findAnnotation(Class<?> clazz, Class<A> annotationClass) {
        A annotation = null;
        for (Class<?> current = clazz; annotation == null && current != null; current = current.getSuperclass()) {
            annotation = current.getAnnotation(annotationClass);
        }
        return annotation;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        TransactionToken tranToken;
        TransactionAttribute attribute;
        Object object;
        String debugPrefix;
        block20: {
            Transactional.TxType txType;
            TransactionAttributeStrategy strategy;
            Method interceptedMethod = invocation.getMethod();
            Transactional transactional = interceptedMethod.getAnnotation(Transactional.class);
            if (transactional == null) {
                transactional = interceptedMethod.getDeclaringClass().getAnnotation(Transactional.class);
            }
            debugPrefix = null;
            if (this.log.isDebugEnabled()) {
                debugPrefix = String.format("[Intercepted method: %s]", interceptedMethod.toGenericString());
            }
            boolean needsRollback = transactional.rollbackOnly();
            object = null;
            attribute = null;
            if (this.manager != null && (strategy = this.strategies.get((Object)(txType = transactional.value()))) != null) {
                attribute = strategy.getTransactionAttribute();
            }
            if (attribute == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(String.format("%s - skip Tx Transaction", debugPrefix));
                }
                object = invocation.proceed();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("%s - Tx Transaction %s begin", debugPrefix, attribute.name()));
            }
            tranToken = attribute.begin(this.manager);
            this.log.debug("enlistResource XASqlSessionManager");
            XAResource xaRes = (XAResource)this.xaResourceProvider.get();
            tranToken.getActiveTransaction().enlistResource(xaRes);
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(String.format("%s - Tx Transaction %s (CompletionAllowed %s) call method", debugPrefix, attribute.name(), tranToken.isCompletionAllowed()));
                }
                object = invocation.proceed();
                if (!needsRollback) break block20;
                this.manager.setRollbackOnly();
            }
            catch (Throwable t) {
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(String.format("%s - Tx Transaction %s (CompletionAllowed %s) rolling back", debugPrefix, attribute.name(), tranToken.isCompletionAllowed()));
                    }
                    if (this.isApplicationExceptionAvailable()) {
                        boolean shouldTriggerRollback;
                        ApplicationException ae = t.getClass().getAnnotation(ApplicationException.class);
                        ApplicationException parentAe = this.findAnnotation(t.getClass().getSuperclass(), ApplicationException.class);
                        boolean bothAEsNull = ae == null && parentAe == null;
                        boolean aeNotNullAndRollback = ae != null && ae.rollback();
                        boolean parentAeRollbackConditions = false;
                        if (parentAe != null) {
                            parentAeRollbackConditions = !parentAe.inherited() || parentAe.rollback();
                        }
                        boolean bl = shouldTriggerRollback = bothAEsNull || aeNotNullAndRollback || parentAeRollbackConditions;
                        if (shouldTriggerRollback) {
                            this.manager.setRollbackOnly();
                        }
                    } else {
                        this.manager.setRollbackOnly();
                    }
                    throw t;
                }
                catch (Throwable throwable) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(String.format("%s - Tx Transaction %s (CompletionAllowed %s) finish", debugPrefix, attribute.name(), tranToken.isCompletionAllowed()));
                    }
                    attribute.finish(this.manager, tranToken);
                    throw throwable;
                }
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.format("%s - Tx Transaction %s (CompletionAllowed %s) finish", debugPrefix, attribute.name(), tranToken.isCompletionAllowed()));
        }
        attribute.finish(this.manager, tranToken);
        return object;
    }
}

