/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.migration.MigrationException;
import org.apache.ibatis.migration.VariableReplacer;

public class Environment {
    public static final String CHANGELOG = "changelog";
    private static final List<String> SETTING_KEYS;
    private final String timeZone;
    private final String delimiter;
    private final String scriptCharset;
    private final boolean fullLineDelimiter;
    private final boolean sendFullScript;
    private final boolean autoCommit;
    private final boolean removeCrs;
    private final boolean ignoreWarnings;
    private final String driverPath;
    private final String driver;
    private final String url;
    private final String username;
    private final String password;
    private final String hookBeforeUp;
    private final String hookBeforeEachUp;
    private final String hookAfterEachUp;
    private final String hookAfterUp;
    private final String hookBeforeDown;
    private final String hookBeforeEachDown;
    private final String hookAfterEachDown;
    private final String hookAfterDown;
    private final String hookBeforeNew;
    private final String hookAfterNew;
    private final String hookBeforeScript;
    private final String hookBeforeEachScript;
    private final String hookAfterEachScript;
    private final String hookAfterScript;
    private static final String PREFIX = "MIGRATIONS_";
    private final Map<String, String> envVars = System.getenv();
    private final Properties sysProps = System.getProperties();
    private final Properties variables = new Properties();
    private final VariableReplacer parser = new VariableReplacer(Arrays.asList(this.sysProps, this.envVars));

    public Environment(File file) {
        Properties prop = this.mergeProperties(file);
        this.timeZone = this.readProperty(prop, SETTING_KEY.time_zone.name(), "GMT+0:00");
        this.delimiter = this.readProperty(prop, SETTING_KEY.delimiter.name(), ";");
        this.scriptCharset = this.readProperty(prop, SETTING_KEY.script_char_set.name(), Charset.defaultCharset().name());
        this.fullLineDelimiter = Boolean.valueOf(this.readProperty(prop, SETTING_KEY.full_line_delimiter.name()));
        this.sendFullScript = Boolean.valueOf(this.readProperty(prop, SETTING_KEY.send_full_script.name()));
        this.autoCommit = Boolean.valueOf(this.readProperty(prop, SETTING_KEY.auto_commit.name()));
        this.removeCrs = Boolean.valueOf(this.readProperty(prop, SETTING_KEY.remove_crs.name()));
        this.ignoreWarnings = Boolean.valueOf(this.readProperty(prop, SETTING_KEY.ignore_warnings.name(), "true"));
        this.driverPath = this.readProperty(prop, SETTING_KEY.driver_path.name());
        this.driver = this.readProperty(prop, SETTING_KEY.driver.name());
        this.url = this.readProperty(prop, SETTING_KEY.url.name());
        this.username = this.readProperty(prop, SETTING_KEY.username.name());
        this.password = this.readProperty(prop, SETTING_KEY.password.name());
        this.hookBeforeUp = this.readProperty(prop, SETTING_KEY.hook_before_up.name());
        this.hookBeforeEachUp = this.readProperty(prop, SETTING_KEY.hook_before_each_up.name());
        this.hookAfterEachUp = this.readProperty(prop, SETTING_KEY.hook_after_each_up.name());
        this.hookAfterUp = this.readProperty(prop, SETTING_KEY.hook_after_up.name());
        this.hookBeforeDown = this.readProperty(prop, SETTING_KEY.hook_before_down.name());
        this.hookBeforeEachDown = this.readProperty(prop, SETTING_KEY.hook_before_each_down.name());
        this.hookAfterEachDown = this.readProperty(prop, SETTING_KEY.hook_after_each_down.name());
        this.hookAfterDown = this.readProperty(prop, SETTING_KEY.hook_after_down.name());
        this.hookBeforeNew = this.readProperty(prop, SETTING_KEY.hook_before_new.name());
        this.hookAfterNew = this.readProperty(prop, SETTING_KEY.hook_after_new.name());
        this.hookBeforeScript = this.readProperty(prop, SETTING_KEY.hook_before_script.name());
        this.hookBeforeEachScript = this.readProperty(prop, SETTING_KEY.hook_before_each_script.name());
        this.hookAfterEachScript = this.readProperty(prop, SETTING_KEY.hook_after_each_script.name());
        this.hookAfterScript = this.readProperty(prop, SETTING_KEY.hook_after_script.name());
        prop.entrySet().stream().filter(e -> !SETTING_KEYS.contains(e.getKey())).forEach(e -> this.variables.put(e.getKey(), this.parser.replace((String)e.getValue())));
    }

    private Properties mergeProperties(File file) {
        Properties prop = this.loadPropertiesFromFile(file);
        this.envVars.entrySet().stream().filter(e -> this.isMigrationsKey((String)e.getKey())).forEach(e -> prop.put(this.normalizeKey((String)e.getKey()), e.getValue()));
        this.sysProps.entrySet().stream().filter(e -> this.isMigrationsKey((String)e.getKey())).forEach(e -> prop.put(this.normalizeKey((String)e.getKey()), e.getValue()));
        return prop;
    }

    private String normalizeKey(String key) {
        return key.substring(PREFIX.length()).toLowerCase(Locale.ENGLISH);
    }

    private boolean isMigrationsKey(String key) {
        return key.length() > PREFIX.length() && key.toUpperCase(Locale.ENGLISH).startsWith(PREFIX);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadPropertiesFromFile(File file) {
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(file);){
            properties.load(inputStream);
            Properties properties2 = properties;
            return properties2;
        }
        catch (FileNotFoundException e) {
            throw new MigrationException("Environment file missing: " + file.getAbsolutePath());
        }
        catch (IOException e) {
            throw new MigrationException("Error loading environment properties.  Cause: " + e, e);
        }
    }

    private String readProperty(Properties properties, String propertyKey) {
        return this.readProperty(properties, propertyKey, null);
    }

    private String readProperty(Properties properties, String propertyKey, String defaultValue) {
        String property = properties.getProperty(propertyKey, defaultValue);
        return property == null ? null : this.parser.replace(property);
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getScriptCharset() {
        return this.scriptCharset;
    }

    public boolean isFullLineDelimiter() {
        return this.fullLineDelimiter;
    }

    public boolean isSendFullScript() {
        return this.sendFullScript;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public boolean isRemoveCrs() {
        return this.removeCrs;
    }

    public boolean isIgnoreWarnings() {
        return this.ignoreWarnings;
    }

    public String getDriverPath() {
        return this.driverPath;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHookBeforeUp() {
        return this.hookBeforeUp;
    }

    public String getHookBeforeEachUp() {
        return this.hookBeforeEachUp;
    }

    public String getHookAfterEachUp() {
        return this.hookAfterEachUp;
    }

    public String getHookAfterUp() {
        return this.hookAfterUp;
    }

    public String getHookBeforeDown() {
        return this.hookBeforeDown;
    }

    public String getHookBeforeEachDown() {
        return this.hookBeforeEachDown;
    }

    public String getHookAfterEachDown() {
        return this.hookAfterEachDown;
    }

    public String getHookAfterDown() {
        return this.hookAfterDown;
    }

    public String getHookBeforeNew() {
        return this.hookBeforeNew;
    }

    public String getHookAfterNew() {
        return this.hookAfterNew;
    }

    public String getHookBeforeScript() {
        return this.hookBeforeScript;
    }

    public String getHookBeforeEachScript() {
        return this.hookBeforeEachScript;
    }

    public String getHookAfterEachScript() {
        return this.hookAfterEachScript;
    }

    public String getHookAfterScript() {
        return this.hookAfterScript;
    }

    public Properties getVariables() {
        return this.variables;
    }

    static {
        SETTING_KEY[] keys;
        ArrayList<String> list = new ArrayList<String>();
        for (SETTING_KEY key : keys = SETTING_KEY.values()) {
            list.add(key.name());
        }
        SETTING_KEYS = Collections.unmodifiableList(list);
    }

    private static enum SETTING_KEY {
        time_zone,
        delimiter,
        script_char_set,
        full_line_delimiter,
        send_full_script,
        auto_commit,
        remove_crs,
        ignore_warnings,
        driver_path,
        driver,
        url,
        username,
        password,
        hook_before_up,
        hook_before_each_up,
        hook_after_each_up,
        hook_after_up,
        hook_before_down,
        hook_before_each_down,
        hook_after_each_down,
        hook_after_down,
        hook_before_new,
        hook_after_new,
        hook_before_script,
        hook_before_each_script,
        hook_after_each_script,
        hook_after_script;

    }
}

