/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Properties;
import org.apache.ibatis.migration.VariableReplacer;

public class MigrationReader
extends FilterReader {
    private final String lineSeparator = System.getProperty("line.separator", "\n");
    private static final String UNDO_TAG = "@UNDO";
    private boolean undo;
    private Properties variables;
    private Part part = Part.NEW_LINE;
    private VariableStatus variableStatus = VariableStatus.NOTHING;
    private char previousChar;
    private int undoIndex = 0;
    private int afterCommentPrefixIndex;
    private int afterDoubleSlashIndex;
    private boolean inUndo;
    private final StringBuilder buffer = new StringBuilder();
    private final StringBuilder lineBuffer = new StringBuilder();
    private final VariableReplacer replacer;

    public MigrationReader(File file, String charset, boolean undo, Properties variables) throws IOException {
        this(new FileInputStream(file), charset, undo, variables);
    }

    public MigrationReader(InputStream inputStream, String charset, boolean undo, Properties variables) throws IOException {
        super(MigrationReader.scriptFileReader(inputStream, charset));
        this.undo = undo;
        this.variables = variables;
        this.replacer = new VariableReplacer(this.variables);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (!this.undo && this.inUndo) {
            if (this.buffer.length() > 0) {
                return this.readFromBuffer(cbuf, off, len);
            }
            return -1;
        }
        while (this.buffer.length() == 0) {
            int result = this.in.read(cbuf, off, len);
            if (result == -1) {
                if (this.lineBuffer.length() > 0 && (!this.undo || this.inUndo)) {
                    this.addToBuffer(this.lineBuffer);
                }
                if (this.buffer.length() > 0) break;
                return -1;
            }
            for (int i = off; i < off + result; ++i) {
                char c = cbuf[i];
                this.determinePart(c);
                this.searchVariable(c);
                if (c == '\r' || c == '\n' && this.previousChar != '\r') {
                    switch (this.part) {
                        case AFTER_UNDO_TAG: {
                            if (this.undo) {
                                this.addToBuffer(this.lineBuffer.delete(this.afterCommentPrefixIndex, this.afterDoubleSlashIndex).insert(this.afterCommentPrefixIndex, ' '));
                                this.inUndo = true;
                                break;
                            }
                            this.lineBuffer.setLength(0);
                            int bufferLen = this.buffer.length();
                            if (bufferLen == 0) {
                                return -1;
                            }
                            return this.readFromBuffer(cbuf, off, len);
                        }
                        case NOT_UNDO_LINE: {
                            if (!this.undo || this.inUndo) {
                                this.addToBuffer(this.lineBuffer);
                                break;
                            }
                            this.lineBuffer.setLength(0);
                            break;
                        }
                    }
                    this.part = Part.NEW_LINE;
                } else if (c == '\n') {
                    this.part = Part.NEW_LINE;
                } else {
                    this.lineBuffer.append(c);
                }
                this.previousChar = c;
            }
        }
        return this.readFromBuffer(cbuf, off, len);
    }

    private void addToBuffer(StringBuilder line) {
        this.replaceVariables(line);
        this.buffer.append((CharSequence)line).append(this.lineSeparator);
        this.lineBuffer.setLength(0);
    }

    private void replaceVariables(StringBuilder line) {
        String processed;
        String lineBufferStr;
        if (this.variableStatus == VariableStatus.FOUND_POSSIBLE_VARIABLE && !(lineBufferStr = line.toString()).equals(processed = this.replacer.replace(lineBufferStr))) {
            line.setLength(0);
            line.append(processed);
        }
        this.variableStatus = VariableStatus.NOTHING;
    }

    private int readFromBuffer(char[] cbuf, int off, int len) {
        int bufferLen = this.buffer.length();
        int read = bufferLen > len ? len : bufferLen;
        this.buffer.getChars(0, read, cbuf, off);
        this.buffer.delete(0, read);
        return read;
    }

    private void determinePart(char c) {
        switch (this.part) {
            case NEW_LINE: {
                if (this.inUndo) {
                    this.part = Part.NOT_UNDO_LINE;
                    break;
                }
                if (c == '\t' || c == ' ') break;
                if (c == '/' || c == '-') {
                    this.part = Part.COMMENT_PREFIX;
                    break;
                }
                this.part = Part.NOT_UNDO_LINE;
                break;
            }
            case COMMENT_PREFIX: {
                if ((c == '/' || c == '-') && c == this.previousChar) {
                    this.part = Part.AFTER_COMMENT_PREFIX;
                    this.afterCommentPrefixIndex = this.lineBuffer.length() + 1;
                    break;
                }
                this.part = Part.NOT_UNDO_LINE;
                break;
            }
            case AFTER_COMMENT_PREFIX: {
                if (c == '\t' || c == ' ') break;
                if (c == '/') {
                    this.part = Part.DOUBLE_SLASH;
                    break;
                }
                this.part = Part.NOT_UNDO_LINE;
                break;
            }
            case DOUBLE_SLASH: {
                if (c == '/' && c == this.previousChar) {
                    this.part = Part.AFTER_DOUBLE_SLASH;
                    this.afterDoubleSlashIndex = this.lineBuffer.length() + 1;
                    this.undoIndex = 0;
                    break;
                }
                this.part = Part.NOT_UNDO_LINE;
                break;
            }
            case AFTER_DOUBLE_SLASH: {
                if (c == '\t' || c == ' ') break;
                if (c == UNDO_TAG.charAt(this.undoIndex)) {
                    this.part = Part.UNDO_TAG;
                    this.undoIndex = 1;
                    break;
                }
                this.part = Part.NOT_UNDO_LINE;
                break;
            }
            case UNDO_TAG: {
                if (c != UNDO_TAG.charAt(this.undoIndex)) {
                    this.part = Part.NOT_UNDO_LINE;
                    break;
                }
                if (++this.undoIndex < UNDO_TAG.length()) break;
                this.part = Part.AFTER_UNDO_TAG;
                break;
            }
        }
    }

    private void searchVariable(char c) {
        switch (this.variableStatus) {
            case NOTHING: {
                if (this.part != Part.NOT_UNDO_LINE && this.part != Part.AFTER_UNDO_TAG || c != '$') break;
                this.variableStatus = VariableStatus.FOUND_DOLLAR;
                break;
            }
            case FOUND_DOLLAR: {
                this.variableStatus = c == '{' ? VariableStatus.FOUND_OPEN_BRACE : VariableStatus.NOTHING;
                break;
            }
            case FOUND_OPEN_BRACE: {
                if (c != '}') break;
                this.variableStatus = VariableStatus.FOUND_POSSIBLE_VARIABLE;
                break;
            }
        }
    }

    @Override
    public int read() throws IOException {
        char[] buf = new char[1];
        int result = this.read(buf, 0, 1);
        return result == -1 ? -1 : buf[0];
    }

    protected static Reader scriptFileReader(InputStream inputStream, String charset) throws UnsupportedEncodingException {
        if (charset == null || charset.length() == 0) {
            return new InputStreamReader(inputStream);
        }
        return new InputStreamReader(inputStream, Charset.forName(charset));
    }

    private static enum VariableStatus {
        NOTHING,
        FOUND_DOLLAR,
        FOUND_OPEN_BRACE,
        FOUND_POSSIBLE_VARIABLE;

    }

    private static enum Part {
        NOT_UNDO_LINE,
        NEW_LINE,
        COMMENT_PREFIX,
        AFTER_COMMENT_PREFIX,
        DOUBLE_SLASH,
        AFTER_DOUBLE_SLASH,
        UNDO_TAG,
        AFTER_UNDO_TAG;

    }
}

