/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class VariableReplacer {
    private static final String openToken = "${";
    private static final String closeToken = "}";
    private final List<Map<? extends Object, ? extends Object>> variablesList;

    public VariableReplacer(Map<? extends Object, ? extends Object> variablesList) {
        this(Arrays.asList(variablesList));
    }

    public VariableReplacer(List<Map<? extends Object, ? extends Object>> variablesList) {
        this.variablesList = variablesList == null ? Collections.emptyList() : variablesList.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public String replace(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        int start = text.indexOf(openToken);
        if (start == -1) {
            return text;
        }
        char[] src = text.toCharArray();
        int offset = 0;
        StringBuilder builder = new StringBuilder();
        StringBuilder expression = null;
        while (start > -1) {
            if (start > 0 && src[start - 1] == '\\') {
                builder.append(src, offset, start - offset - 1).append(openToken);
                offset = start + openToken.length();
            } else {
                if (expression == null) {
                    expression = new StringBuilder();
                } else {
                    expression.setLength(0);
                }
                builder.append(src, offset, start - offset);
                offset = start + openToken.length();
                int end = text.indexOf(closeToken, offset);
                while (end > -1) {
                    if (end > offset && src[end - 1] == '\\') {
                        expression.append(src, offset, end - offset - 1).append(closeToken);
                        offset = end + closeToken.length();
                        end = text.indexOf(closeToken, offset);
                        continue;
                    }
                    expression.append(src, offset, end - offset);
                    break;
                }
                if (end == -1) {
                    builder.append(src, start, src.length - start);
                    offset = src.length;
                } else {
                    this.appendWithReplace(builder, expression.toString());
                    offset = end + closeToken.length();
                }
            }
            start = text.indexOf(openToken, offset);
        }
        if (offset < src.length) {
            builder.append(src, offset, src.length - offset);
        }
        return builder.toString();
    }

    private StringBuilder appendWithReplace(StringBuilder builder, String key) {
        String value = null;
        for (Map<? extends Object, ? extends Object> variables : this.variablesList) {
            value = (String)variables.get(key);
            if (value == null) continue;
            builder.append(value);
            break;
        }
        if (value == null) {
            builder.append(openToken).append(key).append(closeToken);
        }
        return builder;
    }
}

