/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration.commands;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.TimeZone;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.migration.Change;
import org.apache.ibatis.migration.ConnectionProvider;
import org.apache.ibatis.migration.Environment;
import org.apache.ibatis.migration.FileMigrationLoader;
import org.apache.ibatis.migration.FileMigrationLoaderFactory;
import org.apache.ibatis.migration.JdbcConnectionProvider;
import org.apache.ibatis.migration.MigrationException;
import org.apache.ibatis.migration.MigrationLoader;
import org.apache.ibatis.migration.VariableReplacer;
import org.apache.ibatis.migration.commands.Command;
import org.apache.ibatis.migration.hook.FileHookScriptFactory;
import org.apache.ibatis.migration.hook.FileMigrationHook;
import org.apache.ibatis.migration.hook.MigrationHook;
import org.apache.ibatis.migration.options.DatabaseOperationOption;
import org.apache.ibatis.migration.options.Options;
import org.apache.ibatis.migration.options.SelectedOptions;
import org.apache.ibatis.migration.options.SelectedPaths;
import org.apache.ibatis.migration.utils.Util;

public abstract class BaseCommand
implements Command {
    private static final String DATE_FORMAT = "yyyyMMddHHmmss";
    protected static final String DESC_CREATE_CHANGELOG = "create changelog";
    private ClassLoader driverClassLoader;
    private Environment environment;
    protected PrintStream printStream = System.out;
    protected final SelectedOptions options;
    protected final SelectedPaths paths;

    protected BaseCommand(SelectedOptions selectedOptions) {
        this.options = selectedOptions;
        this.paths = selectedOptions.getPaths();
        if (this.options.isQuiet()) {
            this.printStream = new PrintStream(new OutputStream(){

                @Override
                public void write(int b) {
                }
            });
        }
    }

    public void setDriverClassLoader(ClassLoader aDriverClassLoader) {
        this.driverClassLoader = aDriverClassLoader;
    }

    public void setPrintStream(PrintStream aPrintStream) {
        if (this.options.isQuiet()) {
            aPrintStream.println("You selected to suppress output but a PrintStream is being set");
        }
        this.printStream = aPrintStream;
    }

    protected boolean paramsEmpty(String ... params) {
        return params == null || params.length < 1 || params[0] == null || params[0].length() < 1;
    }

    protected String changelogTable() {
        return this.environment().getVariables().getProperty("changelog", "CHANGELOG");
    }

    protected String getNextIDAsString() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String idPattern = this.options.getIdPattern();
        if (idPattern == null) {
            idPattern = Util.getPropertyOption(Options.IDPATTERN.toString().toLowerCase());
        }
        if (idPattern != null && !idPattern.isEmpty()) {
            return this.generatePatternedId(idPattern);
        }
        return this.generateTimestampId();
    }

    private String generatePatternedId(String pattern) {
        DecimalFormat fmt = new DecimalFormat(pattern);
        List<Change> migrations = this.getMigrationLoader().getMigrations();
        if (migrations.size() == 0) {
            return fmt.format(1L);
        }
        Change lastChange = migrations.get(migrations.size() - 1);
        try {
            long lastId = (Long)fmt.parse(lastChange.getId().toString());
            return fmt.format(++lastId);
        }
        catch (ParseException e) {
            throw new MigrationException("Failed to parse last id '" + lastChange.getId() + "' using the specified idPattern '" + pattern + "'");
        }
    }

    private String generateTimestampId() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        Date now = new Date();
        dateFormat.setTimeZone(TimeZone.getTimeZone(this.environment().getTimeZone()));
        return dateFormat.format(now);
    }

    protected void copyResourceTo(String resource, File toFile) {
        this.copyResourceTo(resource, toFile, null);
    }

    protected void copyResourceTo(String resource, File toFile, Properties variables) {
        this.printStream.println("Creating: " + toFile.getName());
        try {
            BaseCommand.copyTemplate(Resources.getResourceAsReader((ClassLoader)this.getClass().getClassLoader(), (String)resource), toFile, variables);
        }
        catch (IOException e) {
            throw new MigrationException("Error copying " + resource + " to " + toFile.getAbsolutePath() + ".  Cause: " + e, e);
        }
    }

    protected void copyExternalResourceTo(String resource, File toFile, Properties variables) {
        this.printStream.println("Creating: " + toFile.getName());
        try {
            File sourceFile = new File(resource);
            BaseCommand.copyTemplate(sourceFile, toFile, variables);
        }
        catch (Exception e) {
            throw new MigrationException("Error copying " + resource + " to " + toFile.getAbsolutePath() + ".  Cause: " + e, e);
        }
    }

    protected static void copyTemplate(File templateFile, File toFile, Properties variables) throws IOException {
        BaseCommand.copyTemplate(new FileReader(templateFile), toFile, variables);
    }

    protected static void copyTemplate(Reader templateReader, File toFile, Properties variables) throws IOException {
        VariableReplacer replacer = new VariableReplacer(variables);
        try (LineNumberReader reader = new LineNumberReader(templateReader);
             PrintWriter writer = new PrintWriter(new FileWriter(toFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                line = replacer.replace(line);
                writer.println(line);
            }
        }
    }

    protected File environmentFile() {
        return Util.file(this.paths.getEnvPath(), this.options.getEnvironment() + ".properties");
    }

    protected File existingEnvironmentFile() {
        File envFile = this.environmentFile();
        if (!envFile.exists()) {
            throw new MigrationException("Environment file missing: " + envFile.getAbsolutePath());
        }
        return envFile;
    }

    protected Environment environment() {
        if (this.environment != null) {
            return this.environment;
        }
        this.environment = new Environment(this.existingEnvironmentFile());
        return this.environment;
    }

    protected int getStepCountParameter(int defaultSteps, String ... params) {
        String stringParam;
        String string = stringParam = params.length > 0 ? params[0] : null;
        if (stringParam == null || "".equals(stringParam)) {
            return defaultSteps;
        }
        try {
            return Integer.parseInt(stringParam);
        }
        catch (NumberFormatException e) {
            throw new MigrationException("Invalid parameter passed to command: " + params[0]);
        }
    }

    protected ConnectionProvider getConnectionProvider() {
        try {
            return new JdbcConnectionProvider(this.getDriverClassLoader(), this.environment().getDriver(), this.environment().getUrl(), this.environment().getUsername(), this.environment().getPassword());
        }
        catch (Exception e) {
            throw new MigrationException("Error creating ScriptRunner.  Cause: " + e, e);
        }
    }

    private ClassLoader getDriverClassLoader() {
        File localDriverPath = this.getCustomDriverPath();
        if (this.driverClassLoader != null) {
            return this.driverClassLoader;
        }
        if (localDriverPath.exists()) {
            try {
                ArrayList<URL> urlList = new ArrayList<URL>();
                File[] files = localDriverPath.listFiles();
                if (files != null) {
                    for (File file : files) {
                        String filename = file.getCanonicalPath();
                        if (!filename.startsWith("/")) {
                            filename = "/" + filename;
                        }
                        urlList.add(new URL("jar:file:" + filename + "!/"));
                        urlList.add(new URL("file:" + filename));
                    }
                }
                URL[] urls = urlList.toArray(new URL[0]);
                return new URLClassLoader(urls);
            }
            catch (Exception e) {
                throw new MigrationException("Error creating a driver ClassLoader. Cause: " + e, e);
            }
        }
        return null;
    }

    private File getCustomDriverPath() {
        String customDriverPath = this.environment().getDriverPath();
        if (customDriverPath != null && customDriverPath.length() > 0) {
            return new File(customDriverPath);
        }
        return this.options.getPaths().getDriverPath();
    }

    protected MigrationLoader getMigrationLoader() {
        Environment env = this.environment();
        MigrationLoader migrationLoader = null;
        for (FileMigrationLoaderFactory factory : ServiceLoader.load(FileMigrationLoaderFactory.class)) {
            if (migrationLoader != null) {
                throw new MigrationException("Found multiple implementations of FileMigrationLoaderFactory via SPI.");
            }
            migrationLoader = factory.create(this.paths, env);
        }
        return migrationLoader != null ? migrationLoader : new FileMigrationLoader(this.paths.getScriptPath(), env.getScriptCharset(), env.getVariables());
    }

    protected MigrationHook createUpHook() {
        String before = this.environment().getHookBeforeUp();
        String beforeEach = this.environment().getHookBeforeEachUp();
        String afterEach = this.environment().getHookAfterEachUp();
        String after = this.environment().getHookAfterUp();
        if (before == null && beforeEach == null && afterEach == null && after == null) {
            return null;
        }
        return this.createFileMigrationHook(before, beforeEach, afterEach, after);
    }

    protected MigrationHook createDownHook() {
        String before = this.environment().getHookBeforeDown();
        String beforeEach = this.environment().getHookBeforeEachDown();
        String afterEach = this.environment().getHookAfterEachDown();
        String after = this.environment().getHookAfterDown();
        if (before == null && beforeEach == null && afterEach == null && after == null) {
            return null;
        }
        return this.createFileMigrationHook(before, beforeEach, afterEach, after);
    }

    protected MigrationHook createFileMigrationHook(String before, String beforeEach, String afterEach, String after) {
        FileHookScriptFactory factory = new FileHookScriptFactory(this.options.getPaths(), this.environment(), this.printStream);
        return new FileMigrationHook(factory.create(before), factory.create(beforeEach), factory.create(afterEach), factory.create(after));
    }

    protected DatabaseOperationOption getDatabaseOperationOption() {
        DatabaseOperationOption option = new DatabaseOperationOption();
        option.setChangelogTable(this.changelogTable());
        option.setStopOnError(!this.options.isForce());
        option.setThrowWarning(!this.options.isForce() && !this.environment().isIgnoreWarnings());
        option.setEscapeProcessing(false);
        option.setAutoCommit(this.environment().isAutoCommit());
        option.setFullLineDelimiter(this.environment().isFullLineDelimiter());
        option.setSendFullScript(this.environment().isSendFullScript());
        option.setRemoveCRs(this.environment().isRemoveCrs());
        option.setDelimiter(this.environment().getDelimiter());
        return option;
    }
}

