/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration.commands;

import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.ibatis.migration.Change;
import org.apache.ibatis.migration.MigrationException;
import org.apache.ibatis.migration.commands.BaseCommand;
import org.apache.ibatis.migration.operations.DatabaseOperation;
import org.apache.ibatis.migration.operations.StatusOperation;
import org.apache.ibatis.migration.options.SelectedOptions;

public final class ScriptCommand
extends BaseCommand {
    public ScriptCommand(SelectedOptions options) {
        super(options);
    }

    @Override
    public void execute(String ... sparams) {
        try {
            if (sparams == null || sparams.length < 1 || sparams[0] == null) {
                throw new MigrationException("The script command requires a range of versions from v1 - v2.");
            }
            StringTokenizer parser = new StringTokenizer(sparams[0]);
            int tokenCount = parser.countTokens();
            boolean scriptPending = false;
            boolean scriptPendingUndo = false;
            String firstToken = parser.nextToken();
            if (tokenCount == 1 && firstToken.equals("pending")) {
                scriptPending = true;
            } else if (tokenCount == 1 && firstToken.equals("pending_undo")) {
                scriptPendingUndo = true;
            } else if (!scriptPending && !scriptPendingUndo && tokenCount != 2) {
                throw new MigrationException("The script command requires a range of versions from v1 - v2.");
            }
            BigDecimal v1 = scriptPending || scriptPendingUndo ? null : new BigDecimal(firstToken);
            BigDecimal v2 = scriptPending || scriptPendingUndo ? null : new BigDecimal(parser.nextToken());
            boolean undo = scriptPendingUndo;
            if (!scriptPending && !scriptPendingUndo) {
                int comparison = v1.compareTo(v2);
                if (comparison == 0) {
                    throw new MigrationException("The script command requires two different versions. Use 0 to include the first version.");
                }
                undo = comparison > 0;
            }
            List<Change> migrations = scriptPending || scriptPendingUndo ? new StatusOperation().operate(this.getConnectionProvider(), this.getMigrationLoader(), this.getDatabaseOperationOption(), null).getCurrentStatus() : this.getMigrationLoader().getMigrations();
            Collections.sort(migrations);
            if (undo) {
                Collections.reverse(migrations);
            }
            for (Change change : migrations) {
                int l;
                if (!this.shouldRun(change, v1, v2, scriptPending || scriptPendingUndo)) continue;
                this.printStream.println("-- " + change.getFilename());
                Reader migrationReader = this.getMigrationLoader().getScriptReader(change, undo);
                char[] cbuf = new char[1024];
                while ((l = migrationReader.read(cbuf)) > -1) {
                    this.printStream.print(l == cbuf.length ? cbuf : Arrays.copyOf(cbuf, l));
                }
                this.printStream.println();
                this.printStream.println();
                this.printStream.println(undo ? this.generateVersionDelete(change) : this.generateVersionInsert(change));
                this.printStream.println();
            }
        }
        catch (IOException e) {
            throw new MigrationException("Error generating script. Cause: " + e, e);
        }
    }

    private String generateVersionInsert(Change change) {
        return "INSERT INTO " + this.changelogTable() + " (ID, APPLIED_AT, DESCRIPTION) VALUES (" + change.getId() + ", '" + DatabaseOperation.generateAppliedTimeStampAsString() + "', '" + change.getDescription().replace('\'', ' ') + "')" + this.getDelimiter();
    }

    private String generateVersionDelete(Change change) {
        return "DELETE FROM " + this.changelogTable() + " WHERE ID = " + change.getId() + this.getDelimiter();
    }

    private boolean shouldRun(Change change, BigDecimal v1, BigDecimal v2, boolean pendingOnly) {
        if (!pendingOnly) {
            BigDecimal id = change.getId();
            if (v1.compareTo(v2) > 0) {
                return id.compareTo(v2) > 0 && id.compareTo(v1) <= 0;
            }
            return id.compareTo(v1) > 0 && id.compareTo(v2) <= 0;
        }
        return change.getAppliedTimestamp() == null;
    }

    private String getDelimiter() {
        StringBuilder delimiter = new StringBuilder();
        if (this.environment().isFullLineDelimiter()) {
            delimiter.append("\n");
        }
        delimiter.append(this.environment().getDelimiter());
        return delimiter.toString();
    }
}

