/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration.hook;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.migration.MigrationException;
import org.apache.ibatis.migration.hook.HookContext;
import org.apache.ibatis.migration.hook.HookScript;
import org.apache.ibatis.migration.utils.Util;
import org.apache.ibatis.parsing.PropertyParser;

public class SqlHookScript
implements HookScript {
    protected final File scriptFile;
    protected final String charset;
    protected final Properties variables;
    protected final PrintStream printStream;

    public SqlHookScript(File scriptFile, String charset, String[] options, Properties variables, PrintStream printStream) {
        this.scriptFile = scriptFile;
        this.charset = charset;
        this.variables = variables;
        this.printStream = printStream;
        for (String option : options) {
            int sep = option.indexOf(61);
            if (sep <= -1) continue;
            this.variables.put(option.substring(0, sep), option.substring(sep + 1));
        }
    }

    @Override
    public void execute(Map<String, Object> bindingMap) {
        HookContext context = (HookContext)bindingMap.get("hookContext");
        this.printStream.println(Util.horizontalLine("Applying SQL hook: " + this.scriptFile.getName(), 80));
        FileInputStream inputStream = null;
        try {
            int length;
            inputStream = new FileInputStream(this.scriptFile);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, length);
            }
            context.executeSql(new StringReader(PropertyParser.parse((String)outputStream.toString(this.charset), (Properties)this.variables)));
        }
        catch (IOException e) {
            throw new MigrationException("Error occurred while running SQL hook script.", e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

