/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration.operations;

import java.io.PrintStream;
import java.io.Reader;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ibatis.migration.Change;
import org.apache.ibatis.migration.ConnectionProvider;
import org.apache.ibatis.migration.MigrationException;
import org.apache.ibatis.migration.MigrationLoader;
import org.apache.ibatis.migration.hook.HookContext;
import org.apache.ibatis.migration.hook.MigrationHook;
import org.apache.ibatis.migration.operations.DatabaseOperation;
import org.apache.ibatis.migration.options.DatabaseOperationOption;
import org.apache.ibatis.migration.utils.Util;

public final class PendingOperation
extends DatabaseOperation {
    public PendingOperation operate(ConnectionProvider connectionProvider, MigrationLoader migrationsLoader, DatabaseOperationOption option, PrintStream printStream) {
        return this.operate(connectionProvider, migrationsLoader, option, printStream, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public PendingOperation operate(ConnectionProvider connectionProvider, MigrationLoader migrationsLoader, DatabaseOperationOption option, PrintStream printStream, MigrationHook hook) {
        try (Connection con = connectionProvider.getConnection();){
            if (option == null) {
                option = new DatabaseOperationOption();
            }
            if (!this.changelogExists(con, option)) {
                throw new MigrationException("Change log doesn't exist, no migrations applied.  Try running 'up' instead.");
            }
            List<Change> pending = this.getPendingChanges(con, migrationsLoader, option);
            int stepCount = 0;
            HashMap<String, Object> hookBindings = new HashMap<String, Object>();
            this.println(printStream, "WARNING: Running pending migrations out of order can create unexpected results.");
            try (Reader scriptReader = null;){
                ScriptRunner runner = this.getScriptRunner(con, option, printStream);
                for (Change change : pending) {
                    if (stepCount == 0 && hook != null) {
                        hookBindings.put("hookContext", new HookContext(connectionProvider, runner, null));
                        hook.before(hookBindings);
                    }
                    if (hook != null) {
                        hookBindings.put("hookContext", new HookContext(connectionProvider, runner, change.clone()));
                        hook.beforeEach(hookBindings);
                    }
                    this.println(printStream, Util.horizontalLine("Applying: " + change.getFilename(), 80));
                    scriptReader = migrationsLoader.getScriptReader(change, false);
                    runner.runScript(scriptReader);
                    this.insertChangelog(change, con, option);
                    this.println(printStream);
                    if (hook != null) {
                        hookBindings.put("hookContext", new HookContext(connectionProvider, runner, change.clone()));
                        hook.afterEach(hookBindings);
                    }
                    ++stepCount;
                }
                if (stepCount > 0 && hook != null) {
                    hookBindings.put("hookContext", new HookContext(connectionProvider, runner, null));
                    hook.after(hookBindings);
                }
                PendingOperation pendingOperation = this;
                return pendingOperation;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        catch (Throwable e) {
            while (e instanceof MigrationException) {
                e = e.getCause();
            }
            throw new MigrationException("Error executing command.  Cause: " + e, e);
        }
    }

    private List<Change> getPendingChanges(Connection con, MigrationLoader migrationsLoader, DatabaseOperationOption option) {
        ArrayList<Change> pending = new ArrayList<Change>();
        List<Change> migrations = migrationsLoader.getMigrations();
        List<Change> changelog = this.getChangelog(con, option);
        for (Change change : migrations) {
            int index = changelog.indexOf(change);
            if (index >= 0) continue;
            pending.add(change);
        }
        Collections.sort(pending);
        return pending;
    }
}

