/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration.operations;

import java.io.PrintStream;
import java.io.Reader;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.jdbc.RuntimeSqlException;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ibatis.migration.Change;
import org.apache.ibatis.migration.ConnectionProvider;
import org.apache.ibatis.migration.MigrationException;
import org.apache.ibatis.migration.MigrationLoader;
import org.apache.ibatis.migration.hook.HookContext;
import org.apache.ibatis.migration.hook.MigrationHook;
import org.apache.ibatis.migration.operations.DatabaseOperation;
import org.apache.ibatis.migration.options.DatabaseOperationOption;
import org.apache.ibatis.migration.utils.Util;

public final class UpOperation
extends DatabaseOperation {
    private final Integer steps;

    public UpOperation() {
        this.steps = null;
    }

    public UpOperation(Integer steps) {
        this.steps = steps;
        if (steps != null && steps < 1) {
            throw new IllegalArgumentException("step must be positive number or null.");
        }
    }

    public UpOperation operate(ConnectionProvider connectionProvider, MigrationLoader migrationsLoader, DatabaseOperationOption option, PrintStream printStream) {
        return this.operate(connectionProvider, migrationsLoader, option, printStream, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public UpOperation operate(ConnectionProvider connectionProvider, MigrationLoader migrationsLoader, DatabaseOperationOption option, PrintStream printStream, MigrationHook hook) {
        try (Connection con = connectionProvider.getConnection();){
            if (option == null) {
                option = new DatabaseOperationOption();
            }
            List<Change> changesInDb = Collections.emptyList();
            if (this.changelogExists(con, option)) {
                changesInDb = this.getChangelog(con, option);
            }
            List<Change> migrations = migrationsLoader.getMigrations();
            Collections.sort(migrations);
            String skippedOrMissing = this.checkSkippedOrMissing(changesInDb, migrations);
            int stepCount = 0;
            HashMap<String, Object> hookBindings = new HashMap<String, Object>();
            Reader scriptReader = null;
            Reader onAbortScriptReader = null;
            ScriptRunner runner = this.getScriptRunner(con, option, printStream);
            try {
                for (Change change : migrations) {
                    if (!changesInDb.isEmpty() && change.compareTo(changesInDb.get(changesInDb.size() - 1)) <= 0) continue;
                    if (stepCount == 0 && hook != null) {
                        hookBindings.put("hookContext", new HookContext(connectionProvider, runner, null));
                        hook.before(hookBindings);
                    }
                    if (hook != null) {
                        hookBindings.put("hookContext", new HookContext(connectionProvider, runner, change.clone()));
                        hook.beforeEach(hookBindings);
                    }
                    this.println(printStream, Util.horizontalLine("Applying: " + change.getFilename(), 80));
                    scriptReader = migrationsLoader.getScriptReader(change, false);
                    runner.runScript(scriptReader);
                    this.insertChangelog(change, con, option);
                    this.println(printStream);
                    if (hook != null) {
                        hookBindings.put("hookContext", new HookContext(connectionProvider, runner, change.clone()));
                        hook.afterEach(hookBindings);
                    }
                    if (this.steps == null || ++stepCount < this.steps) continue;
                    break;
                }
                if (stepCount > 0 && hook != null) {
                    hookBindings.put("hookContext", new HookContext(connectionProvider, runner, null));
                    hook.after(hookBindings);
                }
                this.println(printStream, skippedOrMissing);
                UpOperation upOperation = this;
                return upOperation;
            }
            catch (RuntimeSqlException e) {
                onAbortScriptReader = migrationsLoader.getOnAbortReader();
                if (onAbortScriptReader != null) {
                    this.println(printStream);
                    this.println(printStream, Util.horizontalLine("Executing onabort.sql script.", 80));
                    runner.runScript(onAbortScriptReader);
                    this.println(printStream);
                }
                throw e;
            }
            finally {
                if (scriptReader != null) {
                    scriptReader.close();
                }
                if (onAbortScriptReader != null) {
                    onAbortScriptReader.close();
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        catch (Throwable e) {
            while (e instanceof MigrationException) {
                e = e.getCause();
            }
            throw new MigrationException("Error executing command.  Cause: " + e, e);
        }
    }
}

