/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.migration.MigrationException;
import org.apache.ibatis.migration.VariableReplacer;

public class Environment {
    public static final String CHANGELOG = "changelog";
    private static final List<String> SETTING_KEYS;
    private final String timeZone;
    private final String delimiter;
    private final String scriptCharset;
    private final boolean fullLineDelimiter;
    private final boolean sendFullScript;
    private final boolean autoCommit;
    private final boolean removeCrs;
    private final boolean ignoreWarnings;
    private final String driverPath;
    private final String driver;
    private final String url;
    private final String username;
    private final String password;
    private final String hookBeforeUp;
    private final String hookBeforeEachUp;
    private final String hookAfterEachUp;
    private final String hookAfterUp;
    private final String hookBeforeDown;
    private final String hookBeforeEachDown;
    private final String hookAfterEachDown;
    private final String hookAfterDown;
    private final String hookBeforeNew;
    private final String hookAfterNew;
    private final String hookBeforeScript;
    private final String hookBeforeEachScript;
    private final String hookAfterEachScript;
    private final String hookAfterScript;
    private static final String PREFIX = "MIGRATIONS_";
    private final Map<String, String> envVars = System.getenv();
    private final Properties sysProps = System.getProperties();
    private final Properties variables = new Properties();
    private final VariableReplacer parser = new VariableReplacer(Arrays.asList(this.sysProps, this.envVars));

    public Environment(File file) {
        Properties prop = this.mergeProperties(file);
        this.timeZone = this.readProperty(prop, SETTING_KEY.TIME_ZONE.toString(), "GMT+0:00");
        this.delimiter = this.readProperty(prop, SETTING_KEY.DELIMITER.toString(), ";");
        this.scriptCharset = this.readProperty(prop, SETTING_KEY.SCRIPT_CHAR_SET.toString(), Charset.defaultCharset().toString());
        this.fullLineDelimiter = Boolean.parseBoolean(this.readProperty(prop, SETTING_KEY.FULL_LINE_DELIMITER.toString()));
        this.sendFullScript = Boolean.parseBoolean(this.readProperty(prop, SETTING_KEY.SEND_FULL_SCRIPT.toString()));
        this.autoCommit = Boolean.parseBoolean(this.readProperty(prop, SETTING_KEY.AUTO_COMMIT.toString()));
        this.removeCrs = Boolean.parseBoolean(this.readProperty(prop, SETTING_KEY.REMOVE_CRS.toString()));
        this.ignoreWarnings = Boolean.parseBoolean(this.readProperty(prop, SETTING_KEY.IGNORE_WARNINGS.toString(), "true"));
        this.driverPath = this.readProperty(prop, SETTING_KEY.DRIVER_PATH.toString());
        this.driver = this.readProperty(prop, SETTING_KEY.DRIVER.toString());
        this.url = this.readProperty(prop, SETTING_KEY.URL.toString());
        this.username = this.readProperty(prop, SETTING_KEY.USERNAME.toString());
        this.password = this.readProperty(prop, SETTING_KEY.PASSWORD.toString());
        this.hookBeforeUp = this.readProperty(prop, SETTING_KEY.HOOK_BEFORE_UP.toString());
        this.hookBeforeEachUp = this.readProperty(prop, SETTING_KEY.HOOK_BEFORE_EACH_UP.toString());
        this.hookAfterEachUp = this.readProperty(prop, SETTING_KEY.HOOK_AFTER_EACH_UP.toString());
        this.hookAfterUp = this.readProperty(prop, SETTING_KEY.HOOK_AFTER_UP.toString());
        this.hookBeforeDown = this.readProperty(prop, SETTING_KEY.HOOK_BEFORE_DOWN.toString());
        this.hookBeforeEachDown = this.readProperty(prop, SETTING_KEY.HOOK_BEFORE_EACH_DOWN.toString());
        this.hookAfterEachDown = this.readProperty(prop, SETTING_KEY.HOOK_AFTER_EACH_DOWN.toString());
        this.hookAfterDown = this.readProperty(prop, SETTING_KEY.HOOK_AFTER_DOWN.toString());
        this.hookBeforeNew = this.readProperty(prop, SETTING_KEY.HOOK_BEFORE_NEW.toString());
        this.hookAfterNew = this.readProperty(prop, SETTING_KEY.HOOK_AFTER_NEW.toString());
        this.hookBeforeScript = this.readProperty(prop, SETTING_KEY.HOOK_BEFORE_SCRIPT.toString());
        this.hookBeforeEachScript = this.readProperty(prop, SETTING_KEY.HOOK_BEFORE_EACH_SCRIPT.toString());
        this.hookAfterEachScript = this.readProperty(prop, SETTING_KEY.HOOK_AFTER_EACH_SCRIPT.toString());
        this.hookAfterScript = this.readProperty(prop, SETTING_KEY.HOOK_AFTER_SCRIPT.toString());
        prop.entrySet().stream().filter(e -> !SETTING_KEYS.contains(e.getKey())).forEach(e -> this.variables.put(e.getKey(), this.parser.replace((String)e.getValue())));
    }

    private Properties mergeProperties(File file) {
        Properties prop = this.loadPropertiesFromFile(file);
        this.envVars.entrySet().stream().filter(e -> this.isMigrationsKey((String)e.getKey())).forEach(e -> prop.put(this.normalizeKey((String)e.getKey()), e.getValue()));
        this.sysProps.entrySet().stream().filter(e -> this.isMigrationsKey((String)e.getKey())).forEach(e -> prop.put(this.normalizeKey((String)e.getKey()), e.getValue()));
        return prop;
    }

    private String normalizeKey(String key) {
        return key.substring(PREFIX.length()).toLowerCase(Locale.ENGLISH);
    }

    private boolean isMigrationsKey(String key) {
        return key.length() > PREFIX.length() && key.toUpperCase(Locale.ENGLISH).startsWith(PREFIX);
    }

    private Properties loadPropertiesFromFile(File file) {
        Properties properties;
        Properties properties2 = new Properties();
        FileInputStream inputStream = new FileInputStream(file);
        try {
            properties2.load(inputStream);
            properties = properties2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new MigrationException("Environment file missing: " + file.getAbsolutePath());
            }
            catch (IOException e) {
                throw new MigrationException("Error loading environment properties.  Cause: " + e, e);
            }
        }
        inputStream.close();
        return properties;
    }

    private String readProperty(Properties properties, String propertyKey) {
        return this.readProperty(properties, propertyKey, null);
    }

    private String readProperty(Properties properties, String propertyKey, String defaultValue) {
        String property = properties.getProperty(propertyKey, defaultValue);
        return property == null ? null : this.parser.replace(property);
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getScriptCharset() {
        return this.scriptCharset;
    }

    public boolean isFullLineDelimiter() {
        return this.fullLineDelimiter;
    }

    public boolean isSendFullScript() {
        return this.sendFullScript;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public boolean isRemoveCrs() {
        return this.removeCrs;
    }

    public boolean isIgnoreWarnings() {
        return this.ignoreWarnings;
    }

    public String getDriverPath() {
        return this.driverPath;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHookBeforeUp() {
        return this.hookBeforeUp;
    }

    public String getHookBeforeEachUp() {
        return this.hookBeforeEachUp;
    }

    public String getHookAfterEachUp() {
        return this.hookAfterEachUp;
    }

    public String getHookAfterUp() {
        return this.hookAfterUp;
    }

    public String getHookBeforeDown() {
        return this.hookBeforeDown;
    }

    public String getHookBeforeEachDown() {
        return this.hookBeforeEachDown;
    }

    public String getHookAfterEachDown() {
        return this.hookAfterEachDown;
    }

    public String getHookAfterDown() {
        return this.hookAfterDown;
    }

    public String getHookBeforeNew() {
        return this.hookBeforeNew;
    }

    public String getHookAfterNew() {
        return this.hookAfterNew;
    }

    public String getHookBeforeScript() {
        return this.hookBeforeScript;
    }

    public String getHookBeforeEachScript() {
        return this.hookBeforeEachScript;
    }

    public String getHookAfterEachScript() {
        return this.hookAfterEachScript;
    }

    public String getHookAfterScript() {
        return this.hookAfterScript;
    }

    public Properties getVariables() {
        return this.variables;
    }

    static {
        SETTING_KEY[] keys;
        ArrayList<String> list = new ArrayList<String>();
        for (SETTING_KEY key : keys = SETTING_KEY.values()) {
            list.add(key.toString());
        }
        SETTING_KEYS = Collections.unmodifiableList(list);
    }

    private static enum SETTING_KEY {
        TIME_ZONE,
        DELIMITER,
        SCRIPT_CHAR_SET,
        FULL_LINE_DELIMITER,
        SEND_FULL_SCRIPT,
        AUTO_COMMIT,
        REMOVE_CRS,
        IGNORE_WARNINGS,
        DRIVER_PATH,
        DRIVER,
        URL,
        USERNAME,
        PASSWORD,
        HOOK_BEFORE_UP,
        HOOK_BEFORE_EACH_UP,
        HOOK_AFTER_EACH_UP,
        HOOK_AFTER_UP,
        HOOK_BEFORE_DOWN,
        HOOK_BEFORE_EACH_DOWN,
        HOOK_AFTER_EACH_DOWN,
        HOOK_AFTER_DOWN,
        HOOK_BEFORE_NEW,
        HOOK_AFTER_NEW,
        HOOK_BEFORE_SCRIPT,
        HOOK_BEFORE_EACH_SCRIPT,
        HOOK_AFTER_EACH_SCRIPT,
        HOOK_AFTER_SCRIPT;


        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

