/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration;

import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.ibatis.migration.BootstrapScript;
import org.apache.ibatis.migration.Change;
import org.apache.ibatis.migration.MigrationException;
import org.apache.ibatis.migration.MigrationLoader;
import org.apache.ibatis.migration.MigrationScript;
import org.apache.ibatis.migration.OnAbortScript;
import org.apache.ibatis.migration.SimpleScript;
import org.apache.ibatis.migration.io.ResolverUtil;

public class JavaMigrationLoader
implements MigrationLoader {
    private String[] packageNames;
    private ClassLoader classLoader;

    public JavaMigrationLoader(String ... packageNames) {
        this((ClassLoader)null, packageNames);
    }

    public JavaMigrationLoader(ClassLoader classLoader, String ... packageNames) {
        this.classLoader = classLoader;
        this.packageNames = packageNames;
    }

    @Override
    public List<Change> getMigrations() {
        ArrayList<Change> migrations = new ArrayList<Change>();
        ResolverUtil resolver = this.getResolver();
        resolver.findImplementations(MigrationScript.class, this.packageNames);
        Set classes = resolver.getClasses();
        for (Class clazz : classes) {
            try {
                if (Modifier.isAbstract(clazz.getModifiers())) continue;
                MigrationScript script = (MigrationScript)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Change change = this.parseChangeFromMigrationScript(script);
                migrations.add(change);
            }
            catch (Exception e) {
                throw new MigrationException("Could not instanciate MigrationScript: " + clazz.getName(), e);
            }
        }
        return migrations;
    }

    private Change parseChangeFromMigrationScript(MigrationScript script) {
        Change change = new Change();
        change.setId(script.getId());
        change.setDescription(script.getDescription());
        change.setFilename(script.getClass().getName());
        return change;
    }

    @Override
    public Reader getScriptReader(Change change, boolean undo) {
        ResolverUtil resolver = this.getResolver();
        String className = change.getFilename();
        for (String pkg : this.packageNames) {
            resolver.find(type -> type != null && MigrationScript.class.isAssignableFrom(type) && type.getName().equals(className), pkg);
        }
        Set classes = resolver.getClasses();
        Iterator iterator = classes.iterator();
        if (iterator.hasNext()) {
            Class clazz = iterator.next();
            try {
                MigrationScript script = (MigrationScript)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return new StringReader(undo ? script.getDownScript() : script.getUpScript());
            }
            catch (Exception e) {
                throw new MigrationException("Could not instanciate MigrationScript: " + clazz.getName(), e);
            }
        }
        return null;
    }

    @Override
    public Reader getBootstrapReader() {
        return this.getSoleScriptReader(BootstrapScript.class);
    }

    @Override
    public Reader getOnAbortReader() {
        return this.getSoleScriptReader(OnAbortScript.class);
    }

    public <T extends SimpleScript> Reader getSoleScriptReader(Class<T> scriptClass) {
        ResolverUtil<T> resolver = this.getResolver();
        resolver.findImplementations(scriptClass, this.packageNames);
        Set<Class<T>> classes = resolver.getClasses();
        if (classes == null || classes.isEmpty()) {
            return null;
        }
        if (classes.size() > 1) {
            throw new MigrationException("There can be only one implementation of " + scriptClass.getName());
        }
        Class<T> clazz = classes.iterator().next();
        try {
            SimpleScript script = (SimpleScript)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return new StringReader(script.getScript());
        }
        catch (Exception e) {
            throw new MigrationException("Could not instanciate script class: " + clazz.getName(), e);
        }
    }

    private <T> ResolverUtil<T> getResolver() {
        ResolverUtil resolver = new ResolverUtil();
        if (this.classLoader != null) {
            resolver.setClassLoader(this.classLoader);
        }
        return resolver;
    }
}

