/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class VariableReplacer {
    private static final String OPEN_TOKEN = "${";
    private static final String CLOSE_TOKEN = "}";
    private final List<Map<? extends Object, ? extends Object>> variablesList;

    public VariableReplacer(Map<? extends Object, ? extends Object> variablesList) {
        this(Arrays.asList(variablesList));
    }

    public VariableReplacer(List<Map<? extends Object, ? extends Object>> variablesList) {
        this.variablesList = variablesList == null ? Collections.emptyList() : variablesList.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public String replace(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        int start = text.indexOf(OPEN_TOKEN);
        if (start == -1) {
            return text;
        }
        char[] src = text.toCharArray();
        int offset = 0;
        StringBuilder builder = new StringBuilder();
        StringBuilder expression = null;
        while (start > -1) {
            if (start > 0 && src[start - 1] == '\\') {
                builder.append(src, offset, start - offset - 1).append(OPEN_TOKEN);
                offset = start + OPEN_TOKEN.length();
            } else {
                if (expression == null) {
                    expression = new StringBuilder();
                } else {
                    expression.setLength(0);
                }
                builder.append(src, offset, start - offset);
                offset = start + OPEN_TOKEN.length();
                int end = text.indexOf(CLOSE_TOKEN, offset);
                while (end > -1) {
                    if (end <= offset || src[end - 1] != '\\') {
                        expression.append(src, offset, end - offset);
                        break;
                    }
                    expression.append(src, offset, end - offset - 1).append(CLOSE_TOKEN);
                    offset = end + CLOSE_TOKEN.length();
                    end = text.indexOf(CLOSE_TOKEN, offset);
                }
                if (end == -1) {
                    builder.append(src, start, src.length - start);
                    offset = src.length;
                } else {
                    this.appendWithReplace(builder, expression.toString());
                    offset = end + CLOSE_TOKEN.length();
                }
            }
            start = text.indexOf(OPEN_TOKEN, offset);
        }
        if (offset < src.length) {
            builder.append(src, offset, src.length - offset);
        }
        return builder.toString();
    }

    private StringBuilder appendWithReplace(StringBuilder builder, String key) {
        String value = null;
        for (Map<? extends Object, ? extends Object> variables : this.variablesList) {
            value = (String)variables.get(key);
            if (value == null) continue;
            builder.append(value);
            break;
        }
        if (value == null) {
            builder.append(OPEN_TOKEN).append(key).append(CLOSE_TOKEN);
        }
        return builder;
    }
}

