/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration.commands;

import org.apache.ibatis.migration.MigrationException;
import org.apache.ibatis.migration.commands.BootstrapCommand;
import org.apache.ibatis.migration.commands.Command;
import org.apache.ibatis.migration.commands.DownCommand;
import org.apache.ibatis.migration.commands.InfoCommand;
import org.apache.ibatis.migration.commands.InitializeCommand;
import org.apache.ibatis.migration.commands.NewCommand;
import org.apache.ibatis.migration.commands.PendingCommand;
import org.apache.ibatis.migration.commands.RedoCommand;
import org.apache.ibatis.migration.commands.ScriptCommand;
import org.apache.ibatis.migration.commands.StatusCommand;
import org.apache.ibatis.migration.commands.UpCommand;
import org.apache.ibatis.migration.commands.VersionCommand;
import org.apache.ibatis.migration.options.SelectedOptions;

public enum Commands {
    INFO,
    INIT,
    BOOTSTRAP,
    NEW,
    UP,
    DOWN,
    PENDING,
    SCRIPT,
    VERSION,
    STATUS,
    REDO;


    public static Command resolveCommand(String commandString, SelectedOptions selectedOptions) {
        String upperCasedStr = commandString.toUpperCase();
        for (Commands command : Commands.values()) {
            if (!command.name().startsWith(upperCasedStr)) continue;
            return Commands.createCommand(command, selectedOptions);
        }
        throw new MigrationException("Attempt to execute unknown command: " + commandString);
    }

    private static Command createCommand(Commands aResolvedCommand, SelectedOptions selectedOptions) {
        switch (aResolvedCommand.ordinal()) {
            case 0: {
                return new InfoCommand(System.out);
            }
            case 1: {
                return new InitializeCommand(selectedOptions);
            }
            case 2: {
                return new BootstrapCommand(selectedOptions);
            }
            case 3: {
                return new NewCommand(selectedOptions);
            }
            case 4: {
                return new UpCommand(selectedOptions);
            }
            case 5: {
                return new DownCommand(selectedOptions);
            }
            case 6: {
                return new PendingCommand(selectedOptions);
            }
            case 7: {
                return new ScriptCommand(selectedOptions);
            }
            case 8: {
                return new VersionCommand(selectedOptions);
            }
            case 9: {
                return new StatusCommand(selectedOptions);
            }
            case 10: {
                return new RedoCommand(selectedOptions);
            }
        }
        return params -> System.out.println("unknown command");
    }
}

