/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration.commands;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Properties;
import org.apache.ibatis.migration.commands.Command;

public final class InfoCommand
implements Command {
    private final PrintStream out;

    public InfoCommand(PrintStream out) {
        this.out = out;
    }

    @Override
    public void execute(String ... params) {
        Properties properties = new Properties();
        try (InputStream is = this.getClass().getResourceAsStream("/mybatis-migrations.properties");){
            if (is != null) {
                properties.load(is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.out.printf("%s %s (%s)%n", properties.getProperty("name"), properties.getProperty("version"), properties.getProperty("build"));
        this.out.printf("Java version: %s, vendor: %s%n", System.getProperty("java.version"), System.getProperty("java.vendor"));
        this.out.printf("Java home: %s%n", System.getProperty("java.home"));
        this.out.printf("Default locale: %s, platform encoding: %s%n", Locale.getDefault().toLanguageTag(), Charset.defaultCharset().name());
        this.out.printf("OS name: \"%s\", version: \"%s\", arch: \"%s\", family: \"%s\"%n", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), InfoCommand.getOsFamily());
    }

    private static String getOsFamily() {
        String osName = System.getProperty("os.name").toLowerCase();
        String pathSep = File.pathSeparator;
        if (osName.indexOf("windows") != -1) {
            return "windows";
        }
        if (osName.indexOf("os/2") != -1) {
            return "os/2";
        }
        if (osName.indexOf("z/os") != -1 || osName.indexOf("os/390") != -1) {
            return "z/os";
        }
        if (osName.indexOf("os/400") != -1) {
            return "os/400";
        }
        if (pathSep.equals(";")) {
            return "dos";
        }
        if (osName.indexOf("mac") != -1) {
            if (osName.endsWith("x")) {
                return "mac";
            }
            return "unix";
        }
        if (osName.indexOf("nonstop_kernel") != -1) {
            return "tandem";
        }
        if (osName.indexOf("openvms") != -1) {
            return "openvms";
        }
        if (pathSep.equals(":")) {
            return "unix";
        }
        return "undefined";
    }
}

