/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration.commands;

import java.io.File;
import java.util.Properties;
import org.apache.ibatis.migration.MigrationException;
import org.apache.ibatis.migration.commands.BaseCommand;
import org.apache.ibatis.migration.options.SelectedOptions;
import org.apache.ibatis.migration.utils.Util;

public final class InitializeCommand
extends BaseCommand {
    public InitializeCommand(SelectedOptions selectedOptions) {
        super(selectedOptions);
    }

    @Override
    public void execute(String ... params) {
        File basePath = this.paths.getBasePath();
        File scriptPath = this.paths.getScriptPath();
        this.printStream.println("Initializing: " + basePath);
        this.createDirectoryIfNecessary(basePath);
        this.ensureDirectoryIsEmpty(basePath);
        this.createDirectoryIfNecessary(this.paths.getEnvPath());
        this.createDirectoryIfNecessary(scriptPath);
        this.createDirectoryIfNecessary(this.paths.getDriverPath());
        this.copyResourceTo("org/apache/ibatis/migration/template_README", Util.file(basePath, "README"));
        this.copyResourceTo("org/apache/ibatis/migration/template_environment.properties", this.environmentFile());
        this.copyResourceTo("org/apache/ibatis/migration/template_bootstrap.sql", Util.file(scriptPath, "bootstrap.sql"));
        this.copyResourceTo("org/apache/ibatis/migration/template_changelog.sql", Util.file(scriptPath, this.getNextIDAsString() + "_" + "create changelog".replace(' ', '_') + ".sql"));
        Properties firstMigration = new Properties();
        firstMigration.setProperty("description", "First migration.");
        this.copyResourceTo("org/apache/ibatis/migration/template_migration.sql", Util.file(scriptPath, this.getNextIDAsString() + "_first_migration.sql"), firstMigration);
        this.printStream.println("Done!");
        this.printStream.println();
    }

    protected void ensureDirectoryIsEmpty(File path) {
        String[] list = path.list();
        if (list.length != 0) {
            for (String entry : list) {
                if (entry.startsWith(".")) continue;
                throw new MigrationException("Directory must be empty (.svn etc allowed): " + path.getAbsolutePath());
            }
        }
    }

    protected void createDirectoryIfNecessary(File path) {
        if (!path.exists()) {
            this.printStream.println("Creating: " + path.getName());
            if (!path.mkdirs()) {
                throw new MigrationException("Could not create directory path for an unknown reason. Make sure you have access to the directory.");
            }
        }
    }
}

