/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration.hook;

import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Properties;
import org.apache.ibatis.migration.Environment;
import org.apache.ibatis.migration.MigrationException;
import org.apache.ibatis.migration.hook.HookScript;
import org.apache.ibatis.migration.hook.HookScriptFactory;
import org.apache.ibatis.migration.hook.Jsr223HookScript;
import org.apache.ibatis.migration.hook.SqlHookScript;
import org.apache.ibatis.migration.options.SelectedPaths;

public class FileHookScriptFactory
implements HookScriptFactory {
    protected final SelectedPaths paths;
    protected final Environment environment;
    protected final PrintStream printStream;

    public FileHookScriptFactory(SelectedPaths paths, Environment environment, PrintStream printStream) {
        this.paths = paths;
        this.environment = environment;
        this.printStream = printStream;
    }

    @Override
    public HookScript create(String hookSetting) {
        if (hookSetting == null) {
            return null;
        }
        File hooksDir = this.paths.getHookPath();
        if (hooksDir == null) {
            throw new MigrationException("Hooks directory must not be null.");
        }
        if (!hooksDir.exists()) {
            throw new MigrationException("Hooks directory not found : " + hooksDir.getAbsolutePath());
        }
        String[] segments = hookSetting.split(":");
        if (segments.length < 2) {
            throw new MigrationException("Error creating a HookScript. Hook setting must contain 'language' and 'file name' separated by ':' (e.g. SQL:post-up.sql).");
        }
        String charset = this.environment.getScriptCharset();
        Properties variables = this.environment.getVariables();
        String scriptLang = segments[0];
        File scriptFile = new File(hooksDir, segments[1]);
        String[] hookOptions = Arrays.copyOfRange(segments, 2, segments.length);
        if (!scriptFile.exists()) {
            throw new MigrationException("Hook script not found : " + scriptFile.getAbsolutePath());
        }
        if ("sql".equalsIgnoreCase(scriptLang)) {
            return new SqlHookScript(scriptFile, charset, hookOptions, variables, this.printStream);
        }
        return new Jsr223HookScript(scriptLang, scriptFile, charset, hookOptions, this.paths, variables, this.printStream);
    }
}

