/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration.hook;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.ibatis.migration.Change;
import org.apache.ibatis.migration.ConnectionProvider;
import org.apache.ibatis.migration.operations.ScriptRunner;

public class HookContext {
    private ConnectionProvider connectionProvider;
    private ScriptRunner scriptRunner;
    private Change change;

    public HookContext(ConnectionProvider connectionProvider, ScriptRunner scriptRunner, Change change) {
        this.connectionProvider = connectionProvider;
        this.scriptRunner = scriptRunner;
        this.change = change;
    }

    public Connection getConnection() throws SQLException {
        return this.connectionProvider.getConnection();
    }

    public void executeSql(Reader reader) {
        this.scriptRunner.runScript(reader);
    }

    public void executeSql(String sql) {
        try (StringReader reader = new StringReader(sql);){
            this.executeSql(reader);
        }
    }

    public Change getChange() {
        return this.change;
    }
}

