/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ibatis.migration.io.VFS;

public class DefaultVFS
extends VFS {
    private static final Logger log = Logger.getLogger(DefaultVFS.class.getName());
    private static final byte[] JAR_MAGIC = new byte[]{80, 75, 3, 4};

    @Override
    public boolean isValid() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> list(URL url, String path) throws IOException {
        InputStream is = null;
        try {
            ArrayList<String> resources = new ArrayList();
            URL jarUrl = this.findJarForResource(url);
            if (jarUrl != null) {
                is = jarUrl.openStream();
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Listing " + url);
                }
                resources = this.listResources(new JarInputStream(is), path);
            } else {
                List<String> children;
                block38: {
                    children = new ArrayList<String>();
                    try {
                        if (this.isJar(url)) {
                            is = url.openStream();
                            try (JarInputStream jarInput = new JarInputStream(is);){
                                JarEntry entry;
                                if (log.isLoggable(Level.FINER)) {
                                    log.log(Level.FINER, "Listing " + url);
                                }
                                while ((entry = jarInput.getNextJarEntry()) != null) {
                                    if (log.isLoggable(Level.FINER)) {
                                        log.log(Level.FINER, "Jar entry: " + entry.getName());
                                    }
                                    children.add(entry.getName());
                                }
                                break block38;
                            }
                        }
                        is = url.openStream();
                        ArrayList<String> lines = new ArrayList<String>();
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                            String line;
                            while ((line = reader.readLine()) != null) {
                                if (log.isLoggable(Level.FINER)) {
                                    log.log(Level.FINER, "Reader entry: " + line);
                                }
                                lines.add(line);
                                if (!DefaultVFS.getResources(path + "/" + line).isEmpty()) continue;
                                lines.clear();
                                break;
                            }
                        }
                        catch (InvalidPathException e) {
                            lines.clear();
                        }
                        if (!lines.isEmpty()) {
                            if (log.isLoggable(Level.FINER)) {
                                log.log(Level.FINER, "Listing " + url);
                            }
                            children.addAll(lines);
                        }
                    }
                    catch (FileNotFoundException e) {
                        if (!"file".equals(url.getProtocol())) {
                            throw e;
                        }
                        File file = new File(url.getFile());
                        if (log.isLoggable(Level.FINER)) {
                            log.log(Level.FINER, "Listing directory " + file.getAbsolutePath());
                        }
                        if (!file.isDirectory()) break block38;
                        if (log.isLoggable(Level.FINER)) {
                            log.log(Level.FINER, "Listing " + url);
                        }
                        children = Arrays.asList(file.list());
                    }
                }
                String prefix = url.toExternalForm();
                if (!prefix.endsWith("/")) {
                    prefix = prefix + "/";
                }
                for (String child : children) {
                    String resourcePath = path + "/" + child;
                    resources.add(resourcePath);
                    URL childUrl = new URL(prefix + child);
                    resources.addAll(this.list(childUrl, resourcePath));
                }
            }
            ArrayList<String> arrayList = resources;
            return arrayList;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected List<String> listResources(JarInputStream jar, String path) throws IOException {
        JarEntry entry;
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        if (!path.endsWith("/")) {
            path = path + '/';
        }
        ArrayList<String> resources = new ArrayList<String>();
        while ((entry = jar.getNextJarEntry()) != null) {
            if (entry.isDirectory()) continue;
            StringBuilder name = new StringBuilder(entry.getName());
            if (name.charAt(0) != '/') {
                name.insert(0, '/');
            }
            if (name.indexOf(path) != 0) continue;
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Found resource: " + name);
            }
            resources.add(name.substring(1));
        }
        return resources;
    }

    protected URL findJarForResource(URL url) throws MalformedURLException {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Find JAR URL: " + url);
        }
        boolean continueLoop = true;
        while (continueLoop) {
            try {
                url = new URL(url.getFile());
                if (!log.isLoggable(Level.FINER)) continue;
                log.log(Level.FINER, "Inner URL: " + url);
            }
            catch (MalformedURLException e) {
                continueLoop = false;
            }
        }
        StringBuilder jarUrl = new StringBuilder(url.toExternalForm());
        int index = jarUrl.lastIndexOf(".jar");
        if (index < 0) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Not a JAR: " + jarUrl);
            }
            return null;
        }
        jarUrl.setLength(index + 4);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Extracted JAR URL: " + jarUrl);
        }
        try {
            URL testUrl = new URL(jarUrl.toString());
            if (this.isJar(testUrl)) {
                return testUrl;
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Not a JAR: " + jarUrl);
            }
            jarUrl.replace(0, jarUrl.length(), testUrl.getFile());
            File file = new File(jarUrl.toString());
            if (!file.exists()) {
                try {
                    file = new File(URLEncoder.encode(jarUrl.toString(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Unsupported encoding?  UTF-8?  That's impossible.");
                }
            }
            if (file.exists()) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Trying real file: " + file.getAbsolutePath());
                }
                if (this.isJar(testUrl = file.toURI().toURL())) {
                    return testUrl;
                }
            }
        }
        catch (MalformedURLException e) {
            log.log(Level.WARNING, "Invalid JAR URL: " + jarUrl);
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Not a JAR: " + jarUrl);
        }
        return null;
    }

    protected String getPackagePath(String packageName) {
        return packageName == null ? null : packageName.replace('.', '/');
    }

    protected boolean isJar(URL url) {
        return this.isJar(url, new byte[JAR_MAGIC.length]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isJar(URL url, byte[] buffer) {
        try (InputStream is = url.openStream();){
            is.read(buffer, 0, JAR_MAGIC.length);
            if (!Arrays.equals(buffer, JAR_MAGIC)) return false;
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Found JAR: " + url);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

