/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration.io;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ibatis.migration.io.VFS;

public class ResolverUtil<T> {
    private Set<Class<? extends T>> matches = new HashSet<Class<? extends T>>();
    private ClassLoader classloader;

    public Set<Class<? extends T>> getClasses() {
        return this.matches;
    }

    public ClassLoader getClassLoader() {
        return this.classloader == null ? Thread.currentThread().getContextClassLoader() : this.classloader;
    }

    public void setClassLoader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public ResolverUtil<T> findImplementations(Class<?> parent, String ... packageNames) {
        if (packageNames == null) {
            return this;
        }
        IsA test = new IsA(parent);
        for (String pkg : packageNames) {
            this.find(test, pkg);
        }
        return this;
    }

    public ResolverUtil<T> findAnnotated(Class<? extends Annotation> annotation, String ... packageNames) {
        if (packageNames == null) {
            return this;
        }
        AnnotatedWith test = new AnnotatedWith(annotation);
        for (String pkg : packageNames) {
            this.find(test, pkg);
        }
        return this;
    }

    public ResolverUtil<T> find(Test test, String packageName) {
        String path = this.getPackagePath(packageName);
        try {
            List<String> children = VFS.getInstance().list(path);
            for (String child : children) {
                if (!child.endsWith(".class")) continue;
                this.addIfMatching(test, child);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    protected String getPackagePath(String packageName) {
        return packageName == null ? null : packageName.replace('.', '/');
    }

    protected void addIfMatching(Test test, String fqn) {
        try {
            String externalName = fqn.substring(0, fqn.indexOf(46)).replace('/', '.');
            ClassLoader loader = this.getClassLoader();
            Class<?> type = loader.loadClass(externalName);
            if (test.matches(type)) {
                this.matches.add(type);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static class IsA
    implements Test {
        private Class<?> parent;

        public IsA(Class<?> parentType) {
            this.parent = parentType;
        }

        @Override
        public boolean matches(Class<?> type) {
            return type != null && this.parent.isAssignableFrom(type);
        }

        public String toString() {
            return "is assignable to " + this.parent.getSimpleName();
        }
    }

    public static interface Test {
        public boolean matches(Class<?> var1);
    }

    public static class AnnotatedWith
    implements Test {
        private Class<? extends Annotation> annotation;

        public AnnotatedWith(Class<? extends Annotation> annotation) {
            this.annotation = annotation;
        }

        @Override
        public boolean matches(Class<?> type) {
            return type != null && type.isAnnotationPresent(this.annotation);
        }

        public String toString() {
            return "annotated with @" + this.annotation.getSimpleName();
        }
    }
}

