/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration.operations;

import java.io.PrintStream;
import java.io.Reader;
import java.sql.Connection;
import org.apache.ibatis.migration.ConnectionProvider;
import org.apache.ibatis.migration.MigrationException;
import org.apache.ibatis.migration.MigrationLoader;
import org.apache.ibatis.migration.operations.DatabaseOperation;
import org.apache.ibatis.migration.operations.ScriptRunner;
import org.apache.ibatis.migration.options.DatabaseOperationOption;
import org.apache.ibatis.migration.utils.Util;

public final class BootstrapOperation
extends DatabaseOperation {
    private final boolean force;

    public BootstrapOperation() {
        this(false);
    }

    public BootstrapOperation(boolean force) {
        this.force = force;
    }

    public BootstrapOperation operate(ConnectionProvider connectionProvider, MigrationLoader migrationsLoader, DatabaseOperationOption option, PrintStream printStream) {
        BootstrapOperation bootstrapOperation;
        block20: {
            Connection con = connectionProvider.getConnection();
            try {
                if (option == null) {
                    option = new DatabaseOperationOption();
                }
                if (this.changelogExists(con, option) && !this.force) {
                    this.println(printStream, "For your safety, the bootstrap SQL script will only run before migrations are applied (i.e. before the changelog exists).  If you're certain, you can run it using the --force option.");
                } else {
                    try (Reader bootstrapReader = migrationsLoader.getBootstrapReader();){
                        if (bootstrapReader != null) {
                            this.println(printStream, Util.horizontalLine("Applying: bootstrap.sql", 80));
                            ScriptRunner runner = this.getScriptRunner(con, option, printStream);
                            runner.runScript(bootstrapReader);
                            this.println(printStream);
                        } else {
                            this.println(printStream, "Error, could not run bootstrap.sql.  The file does not exist.");
                        }
                    }
                }
                bootstrapOperation = this;
                if (con == null) break block20;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new MigrationException("Error running bootstrapper.  Cause: " + e, e);
                }
            }
            con.close();
        }
        return bootstrapOperation;
    }
}

